/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.resource;

import com.metamatrix.common.xa.CommonXAPlugin;

public class ResourceUnitOfWork {
    public static final int UNSTARTED = 0;
    public static final int STARTED = 10;
    public static final int SUSPENDED = 20;
    public static final int PREPARED = 30;
    public static final int COMMITTED = 40;
    public static final int FORGOTTEN = 50;
    public static final int FAILED = 60;
    protected static final String UNSTARTED_LITERAL = "UNSTARTED";
    protected static final String STARTED_LITERAL = "STARTED";
    protected static final String SUSPENDED_LITERAL = "SUSPENDED";
    protected static final String PREPARED_LITERAL = "PREPARED";
    protected static final String COMMITTED_LITERAL = "COMMITTED";
    protected static final String FORGOTTEN_LITERAL = "FORGOTTEN";
    protected static final String FAILED_LITERAL = "FAILED";
    private int state = 0;

    protected static String getLiteralForState(int value) {
        switch (value) {
            case 0: {
                return UNSTARTED_LITERAL;
            }
            case 10: {
                return STARTED_LITERAL;
            }
            case 20: {
                return SUSPENDED_LITERAL;
            }
            case 30: {
                return PREPARED_LITERAL;
            }
            case 40: {
                return COMMITTED_LITERAL;
            }
            case 50: {
                return FORGOTTEN_LITERAL;
            }
            case 60: {
                return FAILED_LITERAL;
            }
        }
        throw new IllegalArgumentException(CommonXAPlugin.Util.getString("ERR.003.031.0041", value));
    }

    public int getState() {
        return this.state;
    }

    public boolean isRollbackOnly() {
        return this.state == 60;
    }

    public void setState(int newState) throws IllegalStateException {
        switch (newState) {
            case 0: {
                if (this.state == 0) break;
                throw new IllegalStateException(CommonXAPlugin.Util.getString("ERR.003.031.0042", UNSTARTED_LITERAL));
            }
            case 10: {
                if (this.state == 10) break;
                if (this.state == 0 || this.state == 20) {
                    this.performStart();
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CommonXAPlugin.Util.getString("ERR.003.031.0043", ResourceUnitOfWork.getLiteralForState(this.state), STARTED_LITERAL));
            }
            case 20: {
                if (this.state == 20) break;
                if (this.state == 0 || this.state == 10 || this.state == 30) {
                    this.performSuspend();
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CommonXAPlugin.Util.getString("ERR.003.031.0043", ResourceUnitOfWork.getLiteralForState(this.state), STARTED_LITERAL));
            }
            case 30: {
                if (this.state == 30) break;
                if (this.state == 10) {
                    this.performPrepare();
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CommonXAPlugin.Util.getString("ERR.003.031.0043", ResourceUnitOfWork.getLiteralForState(this.state), PREPARED_LITERAL));
            }
            case 40: {
                if (this.state == 40) break;
                if (this.state == 10 || this.state == 30) {
                    this.performPrepare();
                    this.state = 30;
                    this.performCommit();
                    this.state = newState;
                    break;
                }
                if (this.state == 30) {
                    this.performCommit();
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CommonXAPlugin.Util.getString("ERR.003.031.0043", ResourceUnitOfWork.getLiteralForState(this.state), COMMITTED_LITERAL));
            }
            case 50: {
                if (this.state == 50) break;
                this.performForget();
                this.state = newState;
                break;
            }
            case 60: {
                if (this.state == 60) break;
                if (this.state == 10 || this.state == 20 || this.state == 30) {
                    this.performFail();
                    this.state = newState;
                    break;
                }
                throw new IllegalStateException(CommonXAPlugin.Util.getString("ERR.003.031.0043", ResourceUnitOfWork.getLiteralForState(this.state), FAILED_LITERAL));
            }
            default: {
                throw new IllegalArgumentException(CommonXAPlugin.Util.getString("ERR.003.031.0041", newState));
            }
        }
    }

    protected void performStart() {
    }

    protected void performSuspend() {
    }

    protected void performPrepare() {
    }

    protected void performCommit() {
    }

    protected void performFail() {
    }

    protected void performForget() {
    }
}

