/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Command
implements LanguageObject {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_QUERY = 1;
    public static final int TYPE_INSERT = 2;
    public static final int TYPE_UPDATE = 3;
    public static final int TYPE_DELETE = 4;
    public static final int TYPE_SQL = 5;
    public static final int TYPE_STORED_PROCEDURE = 6;
    public static final int TYPE_UPDATE_PROCEDURE = 7;
    public static final int TYPE_XQUERY = 8;
    public static final int TYPE_BATCHED_UPDATE = 9;
    private static List updateCommandSymbol = null;
    protected List subCommands;
    protected Map tempGroupIDs;
    protected Collection externalGroups;
    protected boolean isEmbedded = false;
    private boolean isResolved = false;
    private Option option;

    public abstract int getType();

    public void addSubCommand(Command command) {
        if (this.subCommands == null) {
            this.subCommands = new ArrayList();
        }
        this.subCommands.add(command);
    }

    public void addSubCommands(Collection commands) {
        if (commands == null || commands.size() == 0) {
            return;
        }
        if (this.subCommands == null) {
            this.subCommands = new ArrayList();
        }
        this.subCommands.addAll(commands);
    }

    public boolean hasSubCommands() {
        return this.subCommands != null && this.subCommands.size() > 0;
    }

    public List getSubCommands() {
        if (this.hasSubCommands()) {
            return this.subCommands;
        }
        return Collections.EMPTY_LIST;
    }

    public void setTemporaryMetadata(Map metadata) {
        this.tempGroupIDs = metadata;
    }

    public Map getTemporaryMetadata() {
        return this.tempGroupIDs;
    }

    public void addExternalGroup(GroupSymbol group) {
        if (this.externalGroups == null) {
            this.externalGroups = new ArrayList();
        }
        this.externalGroups.add(group);
    }

    public void addExternalGroups(Collection groups) {
        if (this.externalGroups == null) {
            this.externalGroups = new ArrayList();
        }
        this.externalGroups.addAll(groups);
    }

    public Collection getExternalGroups() {
        if (this.externalGroups == null) {
            return Collections.EMPTY_LIST;
        }
        return this.externalGroups;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public void setIsEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setIsResolved(boolean isResolved) {
        this.isResolved = isResolved;
    }

    public abstract Object clone();

    protected void copyMetadataState(Command copy) {
        if (this.getExternalGroups() != null) {
            copy.addExternalGroups(this.getExternalGroups());
        }
        if (this.tempGroupIDs != null) {
            copy.setTemporaryMetadata(this.tempGroupIDs);
        }
    }

    public String printCommandTree() {
        StringBuffer str = new StringBuffer();
        this.printCommandTree(str, 0);
        return str.toString();
    }

    protected void printCommandTree(StringBuffer str, int tabLevel) {
        for (int i = 0; i < tabLevel; ++i) {
            str.append("\t");
        }
        str.append(this.toString());
        str.append("\n");
        if (this.subCommands != null) {
            ++tabLevel;
            Iterator iter = this.subCommands.iterator();
            while (iter.hasNext()) {
                Command subCommand = (Command)iter.next();
                subCommand.printCommandTree(str, tabLevel);
            }
        }
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public abstract List getProjectedSymbols();

    public abstract boolean areResultsCachable();

    public static List getUpdateCommandSymbol() {
        if (updateCommandSymbol == null) {
            ElementSymbol symbol = new ElementSymbol("Count");
            symbol.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            updateCommandSymbol = Arrays.asList(symbol);
        }
        return updateCommandSymbol;
    }

    public abstract int updatingModelCount(QueryMetadataInterface var1) throws MetaMatrixComponentException;

    protected int getSubCommandsUpdatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        int sunCommandUpdatingModelCount = 0;
        if (this.subCommands != null && !this.subCommands.isEmpty()) {
            Iterator iter = this.subCommands.iterator();
            while (iter.hasNext()) {
                Command command = (Command)iter.next();
                sunCommandUpdatingModelCount += command.updatingModelCount(metadata);
            }
        }
        return sunCommandUpdatingModelCount;
    }
}

