/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.ReservedWords;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.BulkInsert;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.SQLQuery;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.lang.XQuery;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.BreakStatement;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.ContinueStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.CriteriaSelector;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.HasCriteria;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.RaiseErrorStatement;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.proc.TranslateCriteria;
import com.metamatrix.query.sql.proc.WhileStatement;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class SQLStringVisitor
extends LanguageVisitor {
    private static final String SPACE = " ";
    private static final String OPTIONAL_COMMENTS = "/* optional */";
    private int counter = 0;
    private Map nodeIDs = new IdentityHashMap();
    private LinkedList stringParts = new LinkedList();
    private static final char ID_ESCAPE_CHAR = '\"';
    static /* synthetic */ Class class$java$lang$Number;

    public SQLStringVisitor() {
        this.stringParts.add(new Integer(this.counter));
    }

    public static final String getSQLString(LanguageObject obj) {
        SQLStringVisitor visitor = new SQLStringVisitor();
        if (obj == null) {
            return visitor.getUnknownObject();
        }
        PreOrderNavigator.doVisit(obj, visitor);
        return visitor.getSQLString();
    }

    protected Integer registerNode(LanguageObject obj) {
        if (this.nodeIDs.containsKey(obj)) {
            return (Integer)this.nodeIDs.get(obj);
        }
        Integer newID = new Integer(this.counter);
        this.nodeIDs.put(obj, newID);
        ++this.counter;
        return newID;
    }

    protected void replaceStringParts(Integer node, Object[] parts) {
        ListIterator<Object> iter = this.stringParts.listIterator();
        while (iter.hasNext()) {
            Object part = iter.next();
            if (!part.equals(node)) continue;
            iter.remove();
            for (int i = 0; i < parts.length; ++i) {
                iter.add(parts[i]);
            }
        }
    }

    public String getSQLString() {
        StringBuffer str = new StringBuffer();
        Iterator iter = this.stringParts.iterator();
        while (iter.hasNext()) {
            Object part = iter.next();
            if (!(part instanceof String)) continue;
            str.append((String)part);
        }
        return str.toString();
    }

    public String getUnknownObject() {
        return "<undefined>";
    }

    public void visit(BetweenCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (obj.getExpression() != null) {
            parts.add(this.registerNode(obj.getExpression()));
        } else {
            parts.add(this.getUnknownObject());
        }
        parts.add(SPACE);
        if (obj.isNegated()) {
            parts.add("NOT");
            parts.add(SPACE);
        }
        parts.add("BETWEEN");
        parts.add(SPACE);
        if (obj.getLowerExpression() != null) {
            parts.add(this.registerNode(obj.getLowerExpression()));
        } else {
            parts.add(this.getUnknownObject());
        }
        parts.add(SPACE);
        parts.add("AND");
        parts.add(SPACE);
        if (obj.getUpperExpression() != null) {
            parts.add(this.registerNode(obj.getUpperExpression()));
        } else {
            parts.add(this.getUnknownObject());
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(CaseExpression obj) {
        int i;
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("CASE");
        parts.add(SPACE);
        for (i = 0; i < obj.getWhenCount(); ++i) {
            if (!"NULL".equalsIgnoreCase(obj.getWhenExpression(i).toString())) continue;
            parts.add("WHEN");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getExpression()));
            parts.add(SPACE);
            parts.add("IS");
            parts.add(SPACE);
            parts.add("NULL");
            parts.add(SPACE);
            parts.add("THEN");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getThenExpression(i)));
            parts.add(SPACE);
        }
        for (i = 0; i < obj.getWhenCount(); ++i) {
            if ("NULL".equalsIgnoreCase(obj.getWhenExpression(i).toString())) continue;
            parts.add("WHEN");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getExpression()));
            parts.add("=");
            parts.add(this.registerNode(obj.getWhenExpression(i)));
            parts.add(SPACE);
            parts.add("THEN");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getThenExpression(i)));
            parts.add(SPACE);
        }
        if (obj.getElseExpression() != null) {
            parts.add("ELSE");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getElseExpression()));
            parts.add(SPACE);
        }
        parts.add("END");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(CompareCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        Expression leftExpression = obj.getLeftExpression();
        Object leftPart = null;
        leftPart = leftExpression != null ? this.registerNode(leftExpression) : this.getUnknownObject();
        String operator = obj.getOperatorAsString();
        Expression rightExpression = obj.getRightExpression();
        Object rightPart = null;
        rightPart = rightExpression != null ? this.registerNode(rightExpression) : this.getUnknownObject();
        this.replaceStringParts(nodeID, new Object[]{leftPart, SPACE, operator, SPACE, rightPart});
    }

    public void visit(CompoundCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        int operator = obj.getOperator();
        String operatorStr = "";
        if (operator == 0) {
            operatorStr = "AND";
        } else if (operator == 1) {
            operatorStr = "OR";
        }
        List subCriteria = obj.getCriteria();
        if (subCriteria.size() == 1) {
            Criteria firstChild = (Criteria)subCriteria.get(0);
            if (firstChild == null) {
                this.replaceStringParts(nodeID, new Object[]{this.getUnknownObject()});
            } else {
                this.replaceStringParts(nodeID, new Object[]{this.registerNode(firstChild)});
            }
        } else {
            Object[] parts = new Object[6 * subCriteria.size() - 3];
            Iterator iter = subCriteria.iterator();
            Criteria crit = (Criteria)iter.next();
            parts[0] = "(";
            parts[1] = crit != null ? this.registerNode(crit) : this.getUnknownObject();
            parts[2] = ")";
            int i = 3;
            while (iter.hasNext()) {
                parts[i] = SPACE;
                parts[i + 1] = operatorStr;
                parts[i + 2] = SPACE;
                crit = (Criteria)iter.next();
                parts[i + 3] = "(";
                parts[i + 4] = crit != null ? this.registerNode(crit) : this.getUnknownObject();
                parts[i + 5] = ")";
                i += 6;
            }
            this.replaceStringParts(nodeID, parts);
        }
    }

    public void visit(Delete obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("DELETE");
        parts.add(SPACE);
        parts.add("FROM");
        parts.add(SPACE);
        parts.add(this.registerNode(obj.getGroup()));
        if (obj.getCriteria() != null) {
            parts.add(SPACE);
            parts.add("WHERE");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getCriteria()));
        }
        if (obj.getOption() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOption()));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(DependentSetCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (obj.getExpression() == null) {
            parts.add(this.getUnknownObject());
        } else {
            parts.add(this.registerNode(obj.getExpression()));
        }
        parts.add(SPACE);
        if (obj.isNegated()) {
            parts.add("NOT");
            parts.add(SPACE);
        }
        parts.add("IN");
        parts.add(" (<dependent values>)");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(From obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = null;
        List clauses = obj.getClauses();
        if (clauses.size() == 1) {
            this.replaceStringParts(nodeID, new Object[]{"FROM", SPACE, this.registerNode((FromClause)clauses.get(0))});
        } else if (clauses.size() > 1) {
            parts = new Object[2 + clauses.size() + (clauses.size() - 1)];
            parts[0] = "FROM";
            parts[1] = SPACE;
            Iterator clauseIter = clauses.iterator();
            parts[2] = this.registerNode((FromClause)clauseIter.next());
            int i = 3;
            while (clauseIter.hasNext()) {
                parts[i] = ", ";
                parts[i + 1] = this.registerNode((FromClause)clauseIter.next());
                i += 2;
            }
            this.replaceStringParts(nodeID, parts);
        } else {
            this.replaceStringParts(nodeID, new Object[]{"FROM"});
        }
    }

    public void visit(GroupBy obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = null;
        List symbols = obj.getSymbols();
        if (symbols.size() == 1) {
            this.replaceStringParts(nodeID, new Object[]{"GROUP", SPACE, "BY", SPACE, this.registerNode((Expression)symbols.get(0))});
        } else if (symbols.size() > 1) {
            parts = new Object[4 + symbols.size() + (symbols.size() - 1)];
            parts[0] = "GROUP";
            parts[1] = SPACE;
            parts[2] = "BY";
            parts[3] = SPACE;
            Iterator symbolIter = symbols.iterator();
            parts[4] = this.registerNode((Expression)symbolIter.next());
            int i = 5;
            while (symbolIter.hasNext()) {
                parts[i] = ", ";
                parts[i + 1] = this.registerNode((Expression)symbolIter.next());
                i += 2;
            }
            this.replaceStringParts(nodeID, parts);
        } else {
            this.replaceStringParts(nodeID, new Object[]{"GROUP", SPACE, "BY"});
        }
    }

    public void visit(Insert obj) {
        Integer nodeID = this.registerNode(obj);
        List parts = this.formatBasicInsert(obj);
        parts.add("VALUES");
        parts.add(" (");
        Iterator valueIter = obj.getValues().iterator();
        while (valueIter.hasNext()) {
            Expression valObj = (Expression)valueIter.next();
            parts.add(this.registerNode(valObj));
            if (!valueIter.hasNext()) continue;
            parts.add(", ");
        }
        parts.add(")");
        if (obj.getOption() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOption()));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    private List formatBasicInsert(Insert obj) {
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("INSERT");
        parts.add(SPACE);
        parts.add("INTO");
        parts.add(SPACE);
        parts.add(this.registerNode(obj.getGroup()));
        parts.add(SPACE);
        List vars = obj.getVariables();
        if (vars != null) {
            parts.add("(");
            Iterator iter = vars.iterator();
            while (iter.hasNext()) {
                ElementSymbol element = (ElementSymbol)iter.next();
                parts.add(this.registerNode(element));
                if (!iter.hasNext()) continue;
                parts.add(", ");
            }
            parts.add(") ");
        }
        return parts;
    }

    public void visit(BulkInsert obj) {
        Integer nodeID = this.registerNode(obj);
        List parts = this.formatBasicInsert(obj);
        int varCount = obj.getVariables().size();
        parts.add("VALUES");
        parts.add(" (");
        for (int i = 0; i < varCount; ++i) {
            parts.add("?");
            if (i >= varCount - 1) continue;
            parts.add(",");
        }
        parts.add(")");
        if (obj.getOption() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOption()));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(IsNullCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        Object exprPart = null;
        Expression expr = obj.getExpression();
        exprPart = expr == null ? this.getUnknownObject() : this.registerNode(expr);
        parts.add(exprPart);
        parts.add(SPACE);
        parts.add("IS");
        parts.add(SPACE);
        if (obj.isNegated()) {
            parts.add("NOT");
            parts.add(SPACE);
        }
        parts.add("NULL");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(JoinPredicate obj) {
        FromClause leftClause;
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (obj.isOptional()) {
            parts.add(OPTIONAL_COMMENTS);
            parts.add(SPACE);
            parts.add("(");
        }
        if ((leftClause = obj.getLeftClause()) == null) {
            parts.add(this.getUnknownObject());
        } else if (leftClause instanceof JoinPredicate) {
            parts.add("(");
            parts.add(this.registerNode(leftClause));
            parts.add(")");
        } else {
            parts.add(this.registerNode(leftClause));
        }
        parts.add(SPACE);
        parts.add(this.registerNode(obj.getJoinType()));
        parts.add(SPACE);
        FromClause rightClause = obj.getRightClause();
        if (rightClause == null) {
            parts.add(this.getUnknownObject());
        } else if (rightClause instanceof JoinPredicate) {
            parts.add("(");
            parts.add(this.registerNode(rightClause));
            parts.add(")");
        } else {
            parts.add(this.registerNode(rightClause));
        }
        List joinCriteria = obj.getJoinCriteria();
        if (joinCriteria != null && joinCriteria.size() > 0) {
            parts.add(SPACE);
            parts.add("ON");
            parts.add(SPACE);
            Iterator critIter = joinCriteria.iterator();
            while (critIter.hasNext()) {
                Criteria crit = (Criteria)critIter.next();
                if (crit instanceof PredicateCriteria) {
                    parts.add(this.registerNode(crit));
                } else {
                    parts.add("(");
                    parts.add(this.registerNode(crit));
                    parts.add(")");
                }
                if (!critIter.hasNext()) continue;
                parts.add(SPACE);
                parts.add("AND");
                parts.add(SPACE);
            }
        }
        if (obj.isOptional()) {
            parts.add(")");
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(JoinType obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = null;
        if (obj.equals(JoinType.JOIN_INNER)) {
            parts = new Object[]{"INNER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_CROSS)) {
            parts = new Object[]{"CROSS", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_LEFT_OUTER)) {
            parts = new Object[]{"LEFT", SPACE, "OUTER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_RIGHT_OUTER)) {
            parts = new Object[]{"RIGHT", SPACE, "OUTER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_FULL_OUTER)) {
            parts = new Object[]{"FULL", SPACE, "OUTER", SPACE, "JOIN"};
        }
        this.replaceStringParts(nodeID, parts);
    }

    public void visit(MatchCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (obj.getLeftExpression() != null) {
            parts.add(this.registerNode(obj.getLeftExpression()));
        } else {
            parts.add(this.getUnknownObject());
        }
        parts.add(SPACE);
        if (obj.isNegated()) {
            parts.add("NOT");
            parts.add(SPACE);
        }
        parts.add("LIKE");
        parts.add(SPACE);
        if (obj.getRightExpression() != null) {
            parts.add(this.registerNode(obj.getRightExpression()));
        } else {
            parts.add(this.getUnknownObject());
        }
        if (obj.getEscapeChar() != '\u0000') {
            parts.add(SPACE);
            parts.add("ESCAPE");
            parts.add(" '");
            parts.add("" + obj.getEscapeChar());
            parts.add("'");
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(NotCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        if (obj.getCriteria() != null) {
            this.replaceStringParts(nodeID, new Object[]{"NOT", " (", this.registerNode(obj.getCriteria()), ")"});
        } else {
            this.replaceStringParts(nodeID, new Object[]{"NOT", " (", this.getUnknownObject(), ")"});
        }
    }

    public void visit(Option obj) {
        Iterator iter;
        List groups;
        Integer nodeID = this.registerNode(obj);
        boolean anOption = false;
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("OPTION");
        if (obj.getShowPlan()) {
            anOption = true;
            parts.add(SPACE);
            parts.add("SHOWPLAN");
        }
        if (obj.getPlanOnly()) {
            anOption = true;
            parts.add(SPACE);
            parts.add("PLANONLY");
        }
        if (obj.getDebug()) {
            anOption = true;
            parts.add(SPACE);
            parts.add("DEBUG");
        }
        if (obj.isVirtualDependentJoinAllowed()) {
            anOption = true;
            parts.add(SPACE);
            parts.add("VIRTUALDEP");
        }
        if ((groups = obj.getDependentGroups()) != null && groups.size() > 0) {
            anOption = true;
            parts.add(SPACE);
            parts.add("MAKEDEP");
            parts.add(SPACE);
            iter = groups.iterator();
            parts.add((String)iter.next());
            while (iter.hasNext()) {
                parts.add(", ");
                parts.add((String)iter.next());
            }
        }
        if ((groups = obj.getNotDependentGroups()) != null && groups.size() > 0) {
            anOption = true;
            parts.add(SPACE);
            parts.add("MAKENOTDEP");
            parts.add(SPACE);
            iter = groups.iterator();
            parts.add((String)iter.next());
            while (iter.hasNext()) {
                parts.add(", ");
                parts.add((String)iter.next());
            }
        }
        if ((groups = obj.getNoCacheGroups()) != null && groups.size() > 0) {
            anOption = true;
            parts.add(SPACE);
            parts.add("NOCACHE");
            parts.add(SPACE);
            iter = groups.iterator();
            parts.add((String)iter.next());
            while (iter.hasNext()) {
                parts.add(", ");
                parts.add((String)iter.next());
            }
        } else if (obj.isNoCache()) {
            anOption = true;
            parts.add(SPACE);
            parts.add("NOCACHE");
        }
        if (anOption) {
            this.replaceStringParts(nodeID, parts.toArray());
        } else {
            this.replaceStringParts(nodeID, new Object[0]);
        }
    }

    public void visit(OrderBy obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("ORDER");
        parts.add(SPACE);
        parts.add("BY");
        parts.add(SPACE);
        List variables = obj.getVariables();
        List types = obj.getTypes();
        if (variables != null && variables.size() > 0) {
            Iterator iter = variables.iterator();
            Iterator typeIter = types.iterator();
            parts.add(((SingleElementSymbol)iter.next()).getName());
            Boolean type = (Boolean)typeIter.next();
            if (type == OrderBy.DESC) {
                parts.add(SPACE);
                parts.add("DESC");
            }
            while (iter.hasNext()) {
                parts.add(", ");
                parts.add(((SingleElementSymbol)iter.next()).getName());
                type = (Boolean)typeIter.next();
                if (type != OrderBy.DESC) continue;
                parts.add(SPACE);
                parts.add("DESC");
            }
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(Query obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add(this.registerNode(obj.getSelect()));
        if (obj.getInto() != null) {
            parts.add(SPACE);
            parts.add("INTO");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getInto()));
        }
        if (obj.getFrom() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getFrom()));
        }
        if (obj.getCriteria() != null) {
            parts.add(SPACE);
            parts.add("WHERE");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getCriteria()));
        }
        if (obj.getGroupBy() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getGroupBy()));
        }
        if (obj.getHaving() != null) {
            parts.add(SPACE);
            parts.add("HAVING");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getHaving()));
        }
        if (obj.getOrderBy() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOrderBy()));
        }
        if (obj.getLimit() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getLimit()));
        }
        if (obj.getOption() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOption()));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(SearchedCaseExpression obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("CASE");
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            parts.add(SPACE);
            parts.add("WHEN");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getWhenCriteria(i)));
            parts.add(SPACE);
            parts.add("THEN");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getThenExpression(i)));
        }
        parts.add(SPACE);
        if (obj.getElseExpression() != null) {
            parts.add("ELSE");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getElseExpression()));
            parts.add(SPACE);
        }
        parts.add("END");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(Select obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("SELECT");
        parts.add(SPACE);
        if (obj.isDistinct()) {
            parts.add("DISTINCT");
            parts.add(SPACE);
        }
        Iterator iter = obj.getSymbols().iterator();
        while (iter.hasNext()) {
            SelectSymbol symbol = (SelectSymbol)iter.next();
            parts.add(this.registerNode(symbol));
            if (!iter.hasNext()) continue;
            parts.add(", ");
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(SetCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (obj.getExpression() == null) {
            parts.add(this.getUnknownObject());
        } else {
            parts.add(this.registerNode(obj.getExpression()));
        }
        parts.add(SPACE);
        if (obj.isNegated()) {
            parts.add("NOT");
            parts.add(SPACE);
        }
        parts.add("IN");
        parts.add(" (");
        List vals = obj.getValues();
        int size = vals.size();
        if (size == 1) {
            Iterator iter = vals.iterator();
            Expression expr = (Expression)iter.next();
            if (expr == null) {
                parts.add(this.getUnknownObject());
            } else {
                parts.add(this.registerNode(expr));
            }
        } else if (size > 1) {
            Iterator iter = vals.iterator();
            Expression expr = (Expression)iter.next();
            if (expr == null) {
                parts.add(this.getUnknownObject());
            } else {
                parts.add(this.registerNode(expr));
            }
            while (iter.hasNext()) {
                expr = (Expression)iter.next();
                parts.add(", ");
                if (expr == null) {
                    parts.add(this.getUnknownObject());
                    continue;
                }
                parts.add(this.registerNode(expr));
            }
        }
        parts.add(")");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(SetQuery obj) {
        Integer nodeID = this.registerNode(obj);
        String operationString = SetQuery.getOperationString(obj.getOperation());
        Iterator queryIter = obj.getQueries().iterator();
        Iterator allIter = obj.getUseAllFlags().iterator();
        ArrayList<Object> parts = new ArrayList<Object>();
        QueryCommand query = (QueryCommand)queryIter.next();
        Boolean useAll = (Boolean)allIter.next();
        if (query instanceof Query) {
            parts.add(this.registerNode(query));
        } else {
            parts.add("(");
            parts.add(this.registerNode(query));
            parts.add(")");
        }
        while (queryIter.hasNext()) {
            query = (QueryCommand)queryIter.next();
            useAll = (Boolean)allIter.next();
            parts.add(SPACE);
            parts.add(operationString);
            parts.add(SPACE);
            if (useAll.equals(Boolean.TRUE)) {
                parts.add("ALL");
                parts.add(SPACE);
            }
            if (query instanceof Query) {
                parts.add(this.registerNode(query));
                continue;
            }
            parts.add("(");
            parts.add(this.registerNode(query));
            parts.add(")");
        }
        if (obj.getOrderBy() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOrderBy()));
        }
        if (obj.getLimit() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getLimit()));
        }
        if (obj.getOption() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOption()));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(SQLQuery obj) {
        Integer nodeID = this.registerNode(obj);
        this.replaceStringParts(nodeID, new Object[]{obj.getQuery()});
    }

    public void visit(XQuery obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add(obj.getXQuery());
        if (obj.getOption() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOption()));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(StoredProcedure obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>(2);
        parts.add("EXEC");
        parts.add(SPACE);
        parts.add(obj.getProcedureName());
        parts.add("(");
        List params = obj.getInputParameters();
        if (params != null) {
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                SPParameter param = (SPParameter)iter.next();
                if (obj.displayNamedParameters()) {
                    parts.add(this.escapeSinglePart(param.getParameterSymbol().getShortName()));
                    parts.add(" = ");
                }
                if (param.getExpression() == null) {
                    if (param.getName() != null) {
                        parts.add(this.escapeSinglePart(obj.getParamFullName(param)));
                    } else {
                        parts.add("?");
                    }
                } else {
                    parts.add(param.getExpression().toString());
                }
                if (!iter.hasNext()) continue;
                parts.add(", ");
            }
        }
        parts.add(")");
        if (obj.getOption() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOption()));
        } else {
            parts.add("");
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(SubqueryFromClause obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<String> parts = new ArrayList<String>();
        if (obj.isOptional()) {
            parts.add(OPTIONAL_COMMENTS);
            parts.add(SPACE);
        }
        parts.add("(");
        parts.add(obj.getCommand().toString());
        parts.add(")");
        parts.add(" AS ");
        parts.add(obj.getName());
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(SubquerySetCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (obj.getExpression() == null) {
            parts.add(this.getUnknownObject());
        } else {
            parts.add(this.registerNode(obj.getExpression()));
        }
        parts.add(SPACE);
        if (obj.isNegated()) {
            parts.add("NOT");
            parts.add(SPACE);
        }
        parts.add("IN");
        parts.add(" (");
        parts.add(obj.getCommand().toString());
        parts.add(")");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(UnaryFromClause obj) {
        Integer nodeID = this.registerNode(obj);
        if (obj.isOptional()) {
            ArrayList<Object> parts = new ArrayList<Object>(4);
            parts.add(OPTIONAL_COMMENTS);
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getGroup()));
            this.replaceStringParts(nodeID, parts.toArray());
        } else {
            this.replaceStringParts(nodeID, new Object[]{this.registerNode(obj.getGroup())});
        }
    }

    public void visit(Update obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("UPDATE");
        parts.add(SPACE);
        parts.add(this.registerNode(obj.getGroup()));
        parts.add(SPACE);
        parts.add("SET");
        parts.add(SPACE);
        Iterator iter = obj.getChangeList().iterator();
        while (iter.hasNext()) {
            CompareCriteria cc = (CompareCriteria)iter.next();
            parts.add(this.registerNode(cc));
            if (!iter.hasNext()) continue;
            parts.add(", ");
        }
        if (obj.getCriteria() != null) {
            parts.add(SPACE);
            parts.add("WHERE");
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getCriteria()));
        }
        if (obj.getOption() != null) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOption()));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(Into obj) {
        Integer nodeID = this.registerNode(obj);
        this.replaceStringParts(nodeID, new Object[]{this.registerNode(obj.getGroup())});
    }

    public void visit(AggregateSymbol obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add(obj.getAggregateFunction());
        parts.add("(");
        if (obj.isDistinct()) {
            parts.add("DISTINCT");
            parts.add(SPACE);
        }
        if (obj.getExpression() == null) {
            parts.add("*");
        } else {
            parts.add(this.registerNode(obj.getExpression()));
        }
        parts.add(")");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(AliasSymbol obj) {
        Integer nodeID = this.registerNode(obj);
        this.replaceStringParts(nodeID, new Object[]{this.registerNode(obj.getSymbol()), SPACE, "AS", SPACE, this.escapeSinglePart(obj.getName())});
    }

    public void visit(AllInGroupSymbol obj) {
        Integer nodeID = this.registerNode(obj);
        this.replaceStringParts(nodeID, new Object[]{obj.getName()});
    }

    public void visit(AllSymbol obj) {
        Integer nodeID = this.registerNode(obj);
        this.replaceStringParts(nodeID, new Object[]{obj.getName()});
    }

    public void visit(Constant obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] constantParts = null;
        if (obj.isNull()) {
            constantParts = new Object[]{"null"};
        } else {
            try {
                Class type = obj.getType();
                if (type.equals(DataTypeManager.DefaultDataClasses.STRING)) {
                    String strValue = (String)obj.getValue();
                    strValue = this.escapeStringValue(strValue);
                    constantParts = new Object[]{this.getStringQuoteBegin(), strValue, this.getStringQuoteEnd()};
                } else {
                    constantParts = (class$java$lang$Number == null ? (class$java$lang$Number = SQLStringVisitor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type) ? new Object[]{obj.getValue().toString()} : (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN) ? new Object[]{obj.getValue().equals(Boolean.TRUE) ? "TRUE" : "FALSE"} : (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP) ? new Object[]{"{ts'", obj.getValue().toString(), "'}"} : (type.equals(DataTypeManager.DefaultDataClasses.TIME) ? new Object[]{"{t'", obj.getValue().toString(), "'}"} : (type.equals(DataTypeManager.DefaultDataClasses.DATE) ? new Object[]{"{d'", obj.getValue().toString(), "'}"} : new Object[]{this.getStringQuoteBegin(), obj.getValue().toString(), this.getStringQuoteEnd()}))));
                }
            }
            catch (RuntimeException e) {
                Assertion.failed(QueryPlugin.Util.getString("ERR.015.010.0026", e.getMessage()));
            }
        }
        this.replaceStringParts(nodeID, constantParts);
    }

    protected String getStringQuoteBegin() {
        return "'";
    }

    protected String getStringQuoteEnd() {
        return "'";
    }

    protected String escapeStringValue(String str) {
        int index = str.indexOf(39);
        if (index < 0) {
            return str;
        }
        int last = 0;
        StringBuffer temp = new StringBuffer();
        while (index >= 0) {
            temp.append(str.substring(last, index));
            temp.append("''");
            last = index + 1;
            index = str.indexOf(39, last);
        }
        if (last <= str.length() - 1) {
            temp.append(str.substring(last));
        }
        return temp.toString();
    }

    public void visit(ElementSymbol obj) {
        Integer nodeID = this.registerNode(obj);
        if (obj.getDisplayFullyQualified()) {
            this.displayElementFullyQualified(nodeID, obj);
        } else {
            String shortName = obj.getShortName();
            String escapedShortName = this.escapeSinglePart(shortName);
            if (escapedShortName.charAt(0) != shortName.charAt(0)) {
                this.displayElementFullyQualified(nodeID, obj);
            } else {
                this.replaceStringParts(nodeID, new Object[]{shortName});
            }
        }
    }

    private void displayElementFullyQualified(Integer nodeID, ElementSymbol obj) {
        String vdbName = obj.getVirtualDatabaseName();
        String fullElement = obj.getName();
        String model = null;
        String group = null;
        String element = null;
        int elementSeparator = fullElement.lastIndexOf(46);
        if (elementSeparator < 0) {
            element = fullElement;
        } else {
            element = fullElement.substring(elementSeparator + 1);
            group = fullElement.substring(0, elementSeparator);
            int modelSeparator = group.indexOf(46);
            if (modelSeparator >= 0) {
                model = group.substring(0, modelSeparator);
                group = group.substring(modelSeparator + 1);
            }
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (vdbName != null) {
            parts.add(this.escapeSinglePart(vdbName));
            parts.add(".");
        }
        if (model != null) {
            parts.add(this.escapeSinglePart(model));
            parts.add(".");
        }
        if (group != null) {
            parts.add(this.escapeSinglePart(group));
            parts.add(".");
        }
        parts.add(this.escapeSinglePart(element));
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(ExpressionSymbol obj) {
        Integer nodeID = this.registerNode(obj);
        this.replaceStringParts(nodeID, new Object[]{this.registerNode(obj.getExpression())});
    }

    public void visit(Function obj) {
        Integer nodeID = this.registerNode(obj);
        String name = obj.getName();
        Expression[] args = obj.getArgs();
        ArrayList<Object> parts = new ArrayList<Object>();
        if (obj.isImplicit()) {
            parts.add(this.registerNode(args[0]));
        } else if (name.equalsIgnoreCase("CONVERT") || name.equalsIgnoreCase("CAST")) {
            parts.add(name);
            parts.add("(");
            if (args != null && args.length > 0) {
                if (args[0] == null) {
                    parts.add(this.getUnknownObject());
                } else {
                    parts.add(this.registerNode(args[0]));
                }
                if (name.equalsIgnoreCase("CONVERT")) {
                    parts.add(", ");
                } else {
                    parts.add(SPACE);
                    parts.add("AS");
                    parts.add(SPACE);
                }
                if (args.length < 2 || args[1] == null || !(args[1] instanceof Constant)) {
                    parts.add(this.getUnknownObject());
                } else {
                    parts.add(((Constant)args[1]).getValue());
                }
            }
            parts.add(")");
        } else if (name.equals("+") || name.equals("-") || name.equals("*") || name.equals("/") || name.equals("||")) {
            parts.add("(");
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) {
                        parts.add(this.getUnknownObject());
                    } else {
                        parts.add(this.registerNode(args[i]));
                    }
                    if (i >= args.length - 1) continue;
                    parts.add(SPACE);
                    parts.add(name);
                    parts.add(SPACE);
                }
            }
            parts.add(")");
        } else if (name.equalsIgnoreCase("TIMESTAMPADD") || name.equalsIgnoreCase("TIMESTAMPDIFF")) {
            parts.add(name);
            parts.add("(");
            if (args != null && args.length > 0) {
                if (args[0] == null) {
                    parts.add(this.getUnknownObject());
                } else {
                    parts.add(((Constant)args[0]).getValue());
                }
                for (int i = 1; i < args.length; ++i) {
                    parts.add(", ");
                    if (args[i] == null) {
                        parts.add(this.getUnknownObject());
                        continue;
                    }
                    parts.add(this.registerNode(args[i]));
                }
            }
            parts.add(")");
        } else {
            parts.add(name);
            parts.add("(");
            if (args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) {
                        parts.add(this.getUnknownObject());
                    } else {
                        parts.add(this.registerNode(args[i]));
                    }
                    if (i >= args.length - 1) continue;
                    parts.add(", ");
                }
            }
            parts.add(")");
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(GroupSymbol obj) {
        Integer nodeID = this.registerNode(obj);
        String vdbName = obj.getVirtualDatabaseName();
        String alias = null;
        String fullGroup = null;
        if (obj.getDefinition() == null) {
            fullGroup = obj.getName();
        } else {
            fullGroup = obj.getDefinition();
            alias = obj.getName();
        }
        String model = null;
        String group = null;
        int separatorIndex = fullGroup.indexOf(46);
        if (separatorIndex < 0) {
            model = null;
            group = fullGroup;
        } else {
            model = fullGroup.substring(0, separatorIndex);
            group = fullGroup.substring(separatorIndex + 1);
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (vdbName != null) {
            parts.add(this.escapeSinglePart(vdbName));
            parts.add(".");
        }
        if (model != null) {
            parts.add(this.escapeSinglePart(model));
            parts.add(".");
        }
        parts.add(this.escapeSinglePart(group));
        if (alias != null) {
            parts.add(SPACE);
            parts.add("AS");
            parts.add(SPACE);
            parts.add(this.escapeSinglePart(alias));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(Reference obj) {
        Integer nodeID = this.registerNode(obj);
        this.replaceStringParts(nodeID, new Object[]{"?"});
    }

    public void visit(Block obj) {
        Integer nodeID = this.registerNode(obj);
        List statements = obj.getStatements();
        if (statements.size() == 1) {
            this.replaceStringParts(nodeID, new Object[]{"BEGIN", "\n", this.registerNode((Statement)obj.getStatements().get(0)), "\n", "END"});
        } else if (statements.size() > 1) {
            ArrayList<Object> parts = new ArrayList<Object>();
            parts.add("BEGIN");
            parts.add("\n");
            Iterator stmtIter = statements.iterator();
            while (stmtIter.hasNext()) {
                parts.add(this.registerNode((Statement)stmtIter.next()));
                parts.add("\n");
            }
            parts.add("END");
            this.replaceStringParts(nodeID, parts.toArray());
        } else {
            this.replaceStringParts(nodeID, new Object[]{"BEGIN", "\n", "END"});
        }
    }

    public void visit(CommandStatement obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = new Object[]{this.registerNode(obj.getCommand()), ";"};
        this.replaceStringParts(nodeID, parts);
    }

    public void visit(CreateUpdateProcedureCommand obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("CREATE");
        parts.add(SPACE);
        if (!obj.isUpdateProcedure()) {
            parts.add("VIRTUAL");
            parts.add(SPACE);
        }
        parts.add("PROCEDURE");
        parts.add("\n");
        parts.add(this.registerNode(obj.getBlock()));
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(DeclareStatement obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = new Object[]{"DECLARE", SPACE, obj.getVariableType(), SPACE, this.registerNode(obj.getVariable()), ";"};
        this.replaceStringParts(nodeID, parts);
    }

    public void visit(IfStatement obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("IF");
        parts.add("(");
        parts.add(this.registerNode(obj.getCondition()));
        parts.add(")\n");
        parts.add(this.registerNode(obj.getIfBlock()));
        if (obj.hasElseBlock()) {
            parts.add("\n");
            parts.add("ELSE");
            parts.add("\n");
            parts.add(this.registerNode(obj.getElseBlock()));
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(AssignmentStatement obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = new Object[4];
        parts[0] = this.registerNode(obj.getVariable());
        parts[1] = " = ";
        if (obj.hasCommand()) {
            parts[2] = this.registerNode(obj.getCommand());
        } else if (obj.hasExpression()) {
            parts[2] = this.registerNode(obj.getExpression());
        }
        parts[3] = ";";
        this.replaceStringParts(nodeID, parts);
    }

    public void visit(HasCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = new Object[]{"HAS", SPACE, this.registerNode(obj.getSelector())};
        this.replaceStringParts(nodeID, parts);
    }

    public void visit(TranslateCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("TRANSLATE");
        parts.add(SPACE);
        parts.add(this.registerNode(obj.getSelector()));
        if (obj.hasTranslations()) {
            parts.add(SPACE);
            parts.add("WITH");
            parts.add(SPACE);
            parts.add("(");
            Iterator critIter = obj.getTranslations().iterator();
            while (critIter.hasNext()) {
                parts.add(this.registerNode((Criteria)critIter.next()));
                if (critIter.hasNext()) {
                    parts.add(", ");
                }
                if (critIter.hasNext()) continue;
                parts.add(")");
            }
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(CriteriaSelector obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        int selectorType = obj.getSelectorType();
        switch (selectorType) {
            case 1: {
                parts.add("= ");
                break;
            }
            case 6: {
                parts.add(">= ");
                break;
            }
            case 4: {
                parts.add("> ");
                break;
            }
            case 5: {
                parts.add("<= ");
                break;
            }
            case 3: {
                parts.add("< ");
                break;
            }
            case 2: {
                parts.add("<> ");
                break;
            }
            case 8: {
                parts.add("IN");
                parts.add(SPACE);
                break;
            }
            case 9: {
                parts.add("IS");
                parts.add(SPACE);
                parts.add("NULL");
                parts.add(SPACE);
                break;
            }
            case 7: {
                parts.add("LIKE");
                parts.add(SPACE);
                break;
            }
            case 10: {
                parts.add("BETWEEN");
                parts.add(SPACE);
            }
        }
        parts.add("CRITERIA");
        if (obj.hasElements()) {
            parts.add(SPACE);
            parts.add("ON");
            parts.add(SPACE);
            parts.add("(");
            Iterator elmtIter = obj.getElements().iterator();
            while (elmtIter.hasNext()) {
                parts.add(this.registerNode((ElementSymbol)elmtIter.next()));
                if (!elmtIter.hasNext()) continue;
                parts.add(", ");
            }
            parts.add(")");
        }
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(RaiseErrorStatement obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = new Object[]{"ERROR", SPACE, this.registerNode(obj.getExpression()), ";"};
        this.replaceStringParts(nodeID, parts);
    }

    public void visit(BreakStatement obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = new Object[]{"BREAK", ";"};
        this.replaceStringParts(nodeID, parts);
    }

    public void visit(ContinueStatement obj) {
        Integer nodeID = this.registerNode(obj);
        Object[] parts = new Object[]{"CONTINUE", ";"};
        this.replaceStringParts(nodeID, parts);
    }

    public void visit(LoopStatement obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("LOOP");
        parts.add(SPACE);
        parts.add("ON");
        parts.add(" (");
        parts.add(this.registerNode(obj.getCommand()));
        parts.add(") ");
        parts.add("AS");
        parts.add(SPACE);
        parts.add(obj.getCursorName());
        parts.add("\n");
        parts.add(this.registerNode(obj.getBlock()));
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(WhileStatement obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("WHILE");
        parts.add("(");
        parts.add(this.registerNode(obj.getCondition()));
        parts.add(")\n");
        parts.add(this.registerNode(obj.getBlock()));
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(ExistsCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("EXISTS");
        parts.add(" (");
        parts.add(obj.getCommand().toString());
        parts.add(")");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(SubqueryCompareCriteria obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>();
        Expression leftExpression = obj.getLeftExpression();
        if (leftExpression != null) {
            parts.add(this.registerNode(leftExpression));
        } else {
            parts.add(this.getUnknownObject());
        }
        String operator = obj.getOperatorAsString();
        String quantifier = obj.getPredicateQuantifierAsString();
        parts.add(SPACE);
        parts.add(operator);
        parts.add(SPACE);
        parts.add(quantifier);
        parts.add("(");
        parts.add(obj.getCommand().toString());
        parts.add(")");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(ScalarSubquery obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("(");
        parts.add(obj.getCommand().toString());
        parts.add(")");
        this.replaceStringParts(nodeID, parts.toArray());
    }

    public void visit(Limit obj) {
        Integer nodeID = this.registerNode(obj);
        ArrayList<Object> parts = new ArrayList<Object>(6);
        parts.add("LIMIT");
        if (!(obj.getOffset() == null || obj.getOffset() instanceof Constant && (Integer)((Constant)obj.getOffset()).getValue() <= 0)) {
            parts.add(SPACE);
            parts.add(this.registerNode(obj.getOffset()));
            parts.add(",");
        }
        parts.add(SPACE);
        parts.add(this.registerNode(obj.getRowLimit()));
        this.replaceStringParts(nodeID, parts.toArray());
    }

    private String escapeSinglePart(String part) {
        if (this.isReservedWord(part)) {
            return '\"' + part + '\"';
        }
        return part;
    }

    protected boolean isReservedWord(String string) {
        if (string == null) {
            return false;
        }
        return ReservedWords.isReservedWord(string);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

