/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.core.message;

import com.metamatrix.api.core.message.Message;
import com.metamatrix.common.CommonPlugin;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class MessageList
implements List {
    private List messages = new LinkedList();
    private Statistics stats = new Statistics();

    public MessageList() {
    }

    public MessageList(Collection messages) {
        this();
        this.addAll(messages);
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public boolean removeByTarget(Object messageTarget) {
        return MessageList.removeMessagesWithTarget(this.messages, messageTarget);
    }

    public boolean removeByClass(Class messageClass) {
        boolean removedAtLeastOne = false;
        if (messageClass != null) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                Message msg = (Message)iter.next();
                if (msg == null || !messageClass.isAssignableFrom(msg.getClass())) continue;
                iter.remove();
                removedAtLeastOne = true;
                this.messageRemoved(msg);
            }
        }
        return removedAtLeastOne;
    }

    public boolean removeByType(int messageType) {
        boolean removedAtLeastOne = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Message msg = (Message)iter.next();
            if (!MessageList.matchesType(msg, messageType)) continue;
            iter.remove();
            removedAtLeastOne = true;
            this.messageRemoved(msg);
        }
        return removedAtLeastOne;
    }

    public boolean removeByType(int[] messageTypes) {
        boolean removedAtLeastOne = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Message msg = (Message)iter.next();
            if (!MessageList.matchesType(msg, messageTypes)) continue;
            iter.remove();
            removedAtLeastOne = true;
            this.messageRemoved(msg);
        }
        return removedAtLeastOne;
    }

    public Iterator iteratorByTarget(Object target) {
        return new MessageTargetIterator(target, this.messages.listIterator());
    }

    public Iterator iteratorByType(int messageType) {
        return this.iteratorByType(new int[]{messageType});
    }

    public Iterator iteratorByType(int[] messageTypes) {
        return new MessageTypeIterator(messageTypes, this.messages.listIterator());
    }

    public List subListByTarget(Object messageTarget) {
        MessageList result = new MessageList(this);
        MessageList.removeMessagesWithTarget(result, messageTarget);
        return result;
    }

    public List subListByType(int messageType) {
        MessageList result = new MessageList(this);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            if (MessageList.matchesType((Message)iter.next(), messageType)) continue;
            iter.remove();
        }
        return result;
    }

    public List subListByType(int[] messageTypes) {
        MessageList result = new MessageList(this);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            if (MessageList.matchesType((Message)iter.next(), messageTypes)) continue;
            iter.remove();
        }
        return result;
    }

    protected static boolean removeMessagesWithTarget(List messages, Object target) {
        boolean removedAtLeastOne = false;
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            Message msg = (Message)iter.next();
            if (MessageList.matchesTarget(msg, target)) continue;
            iter.remove();
            removedAtLeastOne = true;
        }
        return removedAtLeastOne;
    }

    protected static boolean matchesTarget(Message msg, Object target) {
        if (msg != null) {
            return msg.getTarget() == target;
        }
        return false;
    }

    protected static boolean matchesType(Message msg, int[] messageTypes) {
        if (msg != null && messageTypes != null) {
            for (int i = 0; i != messageTypes.length; ++i) {
                if (msg.getType() != messageTypes[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean matchesType(Message msg, int messageType) {
        if (msg != null) {
            return msg.getType() == messageType;
        }
        return false;
    }

    protected static void verifyMessage(Object obj) {
        if (obj != null && !(obj instanceof Message)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("MessageList.Only_Message_in_MessageList"));
        }
    }

    public void add(int index, Object message) {
        MessageList.verifyMessage(message);
        this.messages.add(index, message);
        this.stats.addMessage((Message)message);
        this.messageAdded((Message)message);
    }

    public boolean add(Object message) {
        MessageList.verifyMessage(message);
        if (this.messages.add(message)) {
            this.stats.addMessage((Message)message);
            this.messageAdded((Message)message);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection messages) {
        if (messages != null) {
            LinkedList addedMsgs = new LinkedList();
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof Message) {
                    this.messages.add(obj);
                    addedMsgs.add(obj);
                    this.stats.addMessage((Message)obj);
                    this.messageAdded((Message)obj);
                    continue;
                }
                Iterator removeIter = addedMsgs.iterator();
                while (removeIter.hasNext()) {
                    this.stats.removeMessage((Message)removeIter.next());
                }
                throw new IllegalArgumentException(CommonPlugin.Util.getString("MessageList.Only_Message_in_MessageList"));
            }
            return true;
        }
        return false;
    }

    public boolean addAll(int index, Collection messages) {
        if (messages != null) {
            int addIndex = index;
            LinkedList addedMsgs = new LinkedList();
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof Message) {
                    this.messages.add(addIndex, obj);
                    addedMsgs.add(obj);
                    this.stats.addMessage((Message)obj);
                    this.messageAdded((Message)obj);
                    ++addIndex;
                    continue;
                }
                Iterator removeIter = addedMsgs.iterator();
                while (removeIter.hasNext()) {
                    this.stats.removeMessage((Message)removeIter.next());
                }
                throw new IllegalArgumentException(CommonPlugin.Util.getString("MessageList.Only_Message_in_MessageList"));
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.messages.clear();
        this.stats.clear();
        this.messagesCleared();
    }

    public boolean contains(Object message) {
        return this.messages.contains(message);
    }

    public boolean containsAll(Collection messages) {
        return this.messages.containsAll(messages);
    }

    public Object get(int index) {
        return this.messages.get(index);
    }

    public int indexOf(Object message) {
        return this.messages.indexOf(message);
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public Iterator iterator() {
        return new MessageListIterator(this.messages.listIterator());
    }

    public int lastIndexOf(Object message) {
        return this.messages.lastIndexOf(message);
    }

    public ListIterator listIterator() {
        return new MessageListIterator(this.messages.listIterator());
    }

    public ListIterator listIterator(int index) {
        return new MessageListIterator(this.messages.listIterator(index));
    }

    protected void messageRemoved(Message message) {
    }

    protected void messageAdded(Message message) {
    }

    protected void messagesCleared() {
    }

    public Object remove(int index) {
        Object result = this.messages.remove(index);
        this.stats.removeMessage((Message)result);
        this.messageRemoved((Message)result);
        return result;
    }

    public boolean remove(Object message) {
        if (this.messages.remove(message)) {
            this.stats.removeMessage((Message)message);
            this.messageRemoved((Message)message);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection messages) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Message msg = (Message)iter.next();
            if (!messages.contains(msg)) continue;
            iter.remove();
            modified = true;
            this.messageRemoved(msg);
        }
        return modified;
    }

    public boolean retainAll(Collection messages) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Message msg = (Message)iter.next();
            if (messages.contains(msg)) continue;
            iter.remove();
            modified = true;
            this.messageRemoved(msg);
        }
        return modified;
    }

    public Object set(int index, Object message) {
        MessageList.verifyMessage(message);
        Message previous = (Message)this.messages.set(index, message);
        this.stats.removeMessage(previous);
        this.stats.addMessage((Message)message);
        return previous;
    }

    public int size() {
        return this.messages.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.messages.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.messages.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.messages.toArray(a);
    }

    private class MessageTargetIterator
    extends MessageSubsetIterator {
        private final Object messageTarget;

        MessageTargetIterator(Object messageTarget, ListIterator iter) {
            super(iter);
            this.messageTarget = messageTarget;
        }

        protected boolean matchesCriteria(Message msg) {
            return MessageList.matchesTarget(msg, this.messageTarget);
        }
    }

    private class MessageTypeIterator
    extends MessageSubsetIterator {
        private final int[] messageTypes;

        MessageTypeIterator(int[] messageTypes, ListIterator iter) {
            super(iter);
            int length = messageTypes.length;
            this.messageTypes = new int[length];
            for (int i = 0; i != length; ++i) {
                this.messageTypes[i] = messageTypes[i];
            }
        }

        protected boolean matchesCriteria(Message msg) {
            return MessageList.matchesType(msg, this.messageTypes);
        }
    }

    private abstract class MessageSubsetIterator
    extends MessageListIterator {
        MessageSubsetIterator(ListIterator iter) {
            super(iter);
        }

        protected void setToNextMatchingMessage() {
            boolean foundNext = false;
            Message msg = null;
            while (super.hasNext()) {
                msg = (Message)super.next();
                if (!this.matchesCriteria(msg)) continue;
                foundNext = true;
                break;
            }
            if (foundNext && super.hasPrevious()) {
                super.previous();
            }
        }

        protected abstract boolean matchesCriteria(Message var1);

        public boolean hasNext() {
            this.setToNextMatchingMessage();
            return super.hasNext();
        }

        public Object next() {
            this.setToNextMatchingMessage();
            return super.next();
        }
    }

    private class MessageListIterator
    implements ListIterator {
        private final ListIterator iter;
        private Message current;

        MessageListIterator(ListIterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            this.current = (Message)this.iter.next();
            return this.current;
        }

        public void remove() {
            if (this.current != null) {
                this.iter.remove();
                MessageList.this.stats.removeMessage(this.current);
            }
        }

        public void add(Object o) {
            MessageList.verifyMessage(o);
            this.iter.add(o);
            MessageList.this.stats.addMessage(this.current);
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public Object previous() {
            this.current = (Message)this.iter.previous();
            return this.current;
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public void set(Object o) {
            MessageList.verifyMessage(o);
            if (this.current != null) {
                this.iter.set(o);
                MessageList.this.stats.removeMessage(this.current);
                this.current = (Message)o;
                MessageList.this.stats.addMessage(this.current);
            }
        }
    }

    public class Statistics {
        private int errors;
        private int warnings;
        private int notifications;
        private int none;
        private int others;

        protected Statistics() {
        }

        protected void clear() {
            this.errors = 0;
            this.warnings = 0;
            this.notifications = 0;
            this.none = 0;
            this.none = 0;
        }

        protected void addMessage(Message msg) {
            if (msg != null) {
                switch (msg.getType()) {
                    case 3: {
                        ++this.errors;
                        break;
                    }
                    case 2: {
                        ++this.warnings;
                        break;
                    }
                    case 1: {
                        ++this.notifications;
                        break;
                    }
                    case 0: {
                        ++this.none;
                        break;
                    }
                    default: {
                        ++this.others;
                    }
                }
            }
        }

        protected void removeMessage(Message msg) {
            if (msg != null) {
                switch (msg.getType()) {
                    case 3: {
                        --this.errors;
                        if (this.errors >= 0) break;
                        this.errors = 0;
                        break;
                    }
                    case 2: {
                        --this.warnings;
                        if (this.warnings >= 0) break;
                        this.warnings = 0;
                        break;
                    }
                    case 1: {
                        --this.notifications;
                        if (this.notifications >= 0) break;
                        this.notifications = 0;
                        break;
                    }
                    case 0: {
                        --this.none;
                        if (this.none >= 0) break;
                        this.none = 0;
                        break;
                    }
                    default: {
                        --this.others;
                        if (this.others >= 0) break;
                        this.others = 0;
                    }
                }
            }
        }

        public int getErrorCount() {
            return this.errors;
        }

        public int getWarningCount() {
            return this.warnings;
        }

        public int getNotificationCount() {
            return this.notifications;
        }

        public int getNoneCount() {
            return this.none;
        }

        public int getOtherCount() {
            return this.others;
        }

        public int getTotalCount() {
            return MessageList.this.size();
        }

        public String toString() {
            return "" + this.errors + " errors, " + this.warnings + " warnings, " + this.notifications + " notifications, " + this.none + " no-type, " + this.others + " others, " + this.getTotalCount() + " total";
        }
    }
}

