/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.core.message;

import com.metamatrix.api.core.message.DefaultProgressMonitor;
import com.metamatrix.api.core.message.ProgressMonitor;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.core.util.Assertion;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamProgressMonitor
extends FilterOutputStream {
    private final DefaultProgressMonitor monitor;

    public OutputStreamProgressMonitor(OutputStream stream, DefaultProgressMonitor monitor) {
        super(stream);
        if (stream == null) {
            Assertion.isNotNull((Object)stream, (String)CommonPlugin.Util.getString("ERR.003.003.0011"));
        }
        if (monitor == null) {
            Assertion.isNotNull((Object)monitor, (String)CommonPlugin.Util.getString("ERR.003.003.0012"));
        }
        this.monitor = monitor;
    }

    protected void addWorkToMonitor(long bytes) throws IOException {
        this.monitor.addWork(bytes);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.addWorkToMonitor(1L);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.addWorkToMonitor(b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.addWorkToMonitor(b.length);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }
}

