/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BufferManagerLookup;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.StorageManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public interface BufferManager
extends Remote {
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_FULL = 2;
    public static final int TYPE_CONNECTOR = 0;
    public static final int TYPE_PROCESSOR = 1;
    public static final int TYPE_FINAL = 2;

    public void initialize(BufferManagerLookup var1, Properties var2) throws MetaMatrixComponentException, RemoteException;

    public int getProcessorBatchSize() throws RemoteException;

    public int getConnectorBatchSize() throws RemoteException;

    public void addStorageManager(StorageManager var1) throws RemoteException;

    public TupleSourceID createTupleSource(List var1, String[] var2, String var3, int var4) throws MetaMatrixComponentException, RemoteException;

    public void removeTupleSource(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public void removeTupleSources(String var1) throws MetaMatrixComponentException, RemoteException;

    public TupleSource getTupleSource(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public TupleBatch pinTupleBatch(TupleSourceID var1, int var2, int var3) throws TupleSourceNotFoundException, MemoryNotAvailableException, MetaMatrixComponentException, RemoteException;

    public void unpinTupleBatch(TupleSourceID var1, int var2, int var3) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public List getTupleSchema(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public void addTupleBatch(TupleSourceID var1, TupleBatch var2) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public int getRowCount(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public void setStatus(TupleSourceID var1, int var2) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public int getStatus(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public int getFinalRowCount(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException, RemoteException;

    public void stop() throws RemoteException;
}

