/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.impl.BatchMap;
import com.metamatrix.common.buffer.impl.BatchMapValueTranslator;
import com.metamatrix.common.buffer.impl.ManagedBatch;
import com.metamatrix.common.buffer.impl.TupleGroupInfo;
import java.util.Iterator;
import java.util.List;

public class TupleSourceInfo {
    private static final BatchMapValueTranslator TRANSLATOR = new BatchMapValueTranslator(){

        public int getBeginRow(Object batchMapValue) {
            return ((ManagedBatch)batchMapValue).getBeginRow();
        }

        public int getEndRow(Object batchMapValue) {
            return ((ManagedBatch)batchMapValue).getEndRow();
        }
    };
    private int type;
    private TupleSourceID tsID;
    private List schema;
    private String[] types;
    private int rowCount;
    private int status;
    private TupleGroupInfo groupInfo;
    private boolean removed = false;
    private BatchMap batches;

    public TupleSourceInfo(TupleSourceID tsID, List schema, String[] types, TupleGroupInfo groupInfo, int type) {
        this.tsID = tsID;
        this.schema = schema;
        this.types = types;
        this.groupInfo = groupInfo;
        this.status = 1;
        this.rowCount = 0;
        this.type = type;
        this.batches = new BatchMap(TRANSLATOR);
    }

    public TupleSourceID getTupleSourceID() {
        return this.tsID;
    }

    public List getTupleSchema() {
        return this.schema;
    }

    public TupleGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rows) {
        this.rowCount = rows;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getType() {
        return this.type;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved() {
        this.removed = true;
    }

    public void addBatch(ManagedBatch batch) {
        this.batches.addBatch(batch.getBeginRow(), batch);
    }

    public void removeBatch(int beginRow) {
        this.batches.removeBatch(beginRow);
    }

    public ManagedBatch getBatch(int beginRow) {
        return (ManagedBatch)this.batches.getBatch(beginRow);
    }

    public Iterator getBatchIterator() {
        return this.batches.getBatchIterator();
    }

    public String[] getTypes() {
        return this.types;
    }

    public String toString() {
        return "TupleSourceInfo[" + this.tsID + "]";
    }
}

