/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.storage.memory;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.buffer.StorageManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.buffer.impl.BatchMap;
import com.metamatrix.common.buffer.impl.BatchMapValueTranslator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MemoryStorageManager
implements StorageManager {
    private static final BatchMapValueTranslator TRANSLATOR = new BatchMapValueTranslator(){

        public int getBeginRow(Object batchMapValue) {
            return ((TupleBatch)batchMapValue).getBeginRow();
        }

        public int getEndRow(Object batchMapValue) {
            return ((TupleBatch)batchMapValue).getEndRow();
        }
    };
    private Map storage = new HashMap();

    public void initialize(Properties props) throws MetaMatrixComponentException {
    }

    public int getStorageType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(TupleSourceID storageID, TupleBatch batch, String[] types) throws MetaMatrixComponentException {
        BatchMap batches = null;
        Object object = this.storage;
        synchronized (object) {
            batches = (BatchMap)this.storage.get(storageID);
            if (batches == null) {
                batches = new BatchMap(TRANSLATOR);
                this.storage.put(storageID, batches);
            }
        }
        object = batches;
        synchronized (object) {
            batches.addBatch(batch.getBeginRow(), batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleBatch getBatch(TupleSourceID storageID, int beginRow, String[] types) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        BatchMap batches = null;
        Object object = this.storage;
        synchronized (object) {
            batches = (BatchMap)this.storage.get(storageID);
        }
        if (batches == null) {
            throw new TupleSourceNotFoundException("ERR.003.006.0036", CommonPlugin.Util.getString("ERR.003.006.0036", (Object)storageID));
        }
        object = batches;
        synchronized (object) {
            Object batch = batches.getBatch(beginRow);
            if (batch != null) {
                return (TupleBatch)batch;
            }
            return new TupleBatch(beginRow, Collections.EMPTY_LIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBatch(TupleSourceID sourceID, int beginRow) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        BatchMap batches = null;
        Object object = this.storage;
        synchronized (object) {
            batches = (BatchMap)this.storage.get(sourceID);
        }
        if (batches == null) {
            return;
        }
        object = batches;
        synchronized (object) {
            batches.removeBatch(beginRow);
            if (batches.isEmpty()) {
                this.storage.remove(sourceID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBatches(TupleSourceID storageID) throws MetaMatrixComponentException {
        Map map = this.storage;
        synchronized (map) {
            this.storage.remove(storageID);
        }
    }

    public void shutdown() {
        this.storage.clear();
        this.storage = null;
    }
}

