/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.distrib;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.cache.ObjectCache;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.distrib.DistribObjectCacheEventPolicy;
import com.metamatrix.common.cache.distrib.DistributedCacheEvent;
import com.metamatrix.common.cache.distrib.DistributedCacheEventFactory;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.util.ReflectionHelper;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Properties;

public class DistributedObjectCache
extends ObjectCache
implements EventObjectListener {
    public static final String EVENT_FACTORY_NAME = "com.metamatrix.common.cache.distrib.DistributedObjectCache.EventFactory";
    public static final String EVENT_POLICY_NAME = "com.metamatrix.common.cache.distrib.DistributedObjectCache.EventPolicy";
    private static final String DEFAULT_EVENT_POLICY = "com.metamatrix.common.cache.distrib.DefaultDistribObjectCacheEventPolicy";
    private DistributedCacheEventFactory eventFactory;
    private DistribObjectCacheEventPolicy eventPolicy;
    private MessageBus messageBus;
    private String cacheName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedObjectCache(String cacheInstanceName, Properties environment) throws ObjectCacheException {
        super(environment);
        Properties env = null;
        this.cacheName = cacheInstanceName;
        Properties properties = environment;
        synchronized (properties) {
            env = (Properties)environment.clone();
        }
        String eventPolicyClassName = env.getProperty(EVENT_POLICY_NAME);
        if (eventPolicyClassName == null) {
            eventPolicyClassName = DEFAULT_EVENT_POLICY;
        }
        try {
            DistribObjectCacheEventPolicy eventPolicy;
            this.eventPolicy = eventPolicy = (DistribObjectCacheEventPolicy)ReflectionHelper.create((String)eventPolicyClassName, null, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            LogManager.logError("DISTRIB_CACHE", (Throwable)e, CommonPlugin.Util.getString("ERR.003.008.0007", (Object)eventPolicyClassName));
            throw new ObjectCacheException(e, "ERR.003.008.0007", CommonPlugin.Util.getString("ERR.003.008.0007", (Object)eventPolicyClassName));
        }
        if (this.eventPolicy == null) {
            LogManager.logError("DISTRIB_CACHE", CommonPlugin.Util.getString("ERR.003.008.0008", (Object)eventPolicyClassName));
            throw new ObjectCacheException("ERR.003.008.0008", CommonPlugin.Util.getString("ERR.003.008.0008", (Object)eventPolicyClassName));
        }
        String eventFactoryName = env.getProperty(EVENT_FACTORY_NAME);
        if (eventFactoryName == null) {
            LogManager.logError("DISTRIB_CACHE", CommonPlugin.Util.getString("ERR.003.008.0009", (Object)EVENT_FACTORY_NAME));
            throw new ObjectCacheException("ERR.003.008.0009", CommonPlugin.Util.getString("ERR.003.008.0009", (Object)EVENT_FACTORY_NAME));
        }
        try {
            DistributedCacheEventFactory eventFactory;
            this.eventFactory = eventFactory = (DistributedCacheEventFactory)ReflectionHelper.create((String)eventFactoryName, null, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            LogManager.logError("DISTRIB_CACHE", CommonPlugin.Util.getString("ERR.003.008.0010", (Object)eventFactoryName));
            throw new ObjectCacheException(e, "ERR.003.008.0010", CommonPlugin.Util.getString("ERR.003.008.0010", (Object)eventFactoryName));
        }
        if (this.eventFactory == null) {
            LogManager.logError("DISTRIB_CACHE", CommonPlugin.Util.getString("ERR.003.008.0011", (Object)eventFactoryName));
            throw new ObjectCacheException("ERR.003.008.0011", CommonPlugin.Util.getString("ERR.003.008.0011", (Object)eventFactoryName));
        }
        this.messageBus = new VMMessageBus();
        try {
            this.messageBus.addListener(this.eventFactory.getEventClass(), this);
        }
        catch (MessagingException e) {
            LogManager.logError("DISTRIB_CACHE", CommonPlugin.Util.getString("ERR.003.008.0012", (Object)this.cacheName));
            throw new ObjectCacheException((Exception)((Object)e), "ERR.003.008.0012", CommonPlugin.Util.getString("ERR.003.008.0012", (Object)this.cacheName));
        }
    }

    public void processEvent(EventObject obj) {
        if (obj instanceof DistributedCacheEvent) {
            String sourceCache;
            DistributedCacheEvent event = (DistributedCacheEvent)((Object)obj);
            Object source = event.getSource();
            if (source instanceof String && this.cacheName.equals(sourceCache = (String)source)) {
                if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                    LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> ignoring event from (same) source <" + sourceCache + ">");
                }
                return;
            }
            switch (event.getEventType()) {
                case 1: {
                    if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                        LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> Received ADD_EVENT");
                    }
                    Object key = this.eventPolicy.getCachedObjectsKey(event);
                    Serializable target = this.eventPolicy.getAddEventTarget(event);
                    if (key == null || target == null) break;
                    if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                        LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> adding <" + key + ">-<" + target + ">");
                    }
                    super.mark(key, target);
                    break;
                }
                case 0: {
                    Object key;
                    if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                        LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> Received REMOVE_EVENT");
                    }
                    if ((key = this.eventPolicy.getCachedObjectsKey(event)) == null) break;
                    if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                        LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> removing <" + key + ">");
                    }
                    super.remove(key);
                    break;
                }
                case 2: {
                    if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                        LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> Received CLEAR_EVENT");
                    }
                    super.clear();
                    break;
                }
                default: {
                    LogManager.logError("DISTRIB_CACHE", CommonPlugin.Util.getString("ERR.003.008.0013", new Object[]{this.cacheName, String.valueOf(event.getEventType())}));
                }
            }
        }
    }

    public void mark(Object key, Object value) {
        if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
            LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> adding <" + key + ">-<" + value + ">");
        }
        super.mark(key, value);
        DistributedCacheEvent event = this.eventFactory.createAddEvent(this.getName(), key, value);
        Serializable target = this.eventPolicy.getAddEventTarget(event);
        if (target != null) {
            if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> sending ADD_EVENT");
            }
            try {
                this.messageBus.processEvent((EventObject)((Object)event));
            }
            catch (MessagingException e) {
                LogManager.logError("DISTRIB_CACHE", (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.003.008.0014", new Object[]{this.cacheName, "ADD_EVENT", key}));
            }
        } else if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
            LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> NOT sending ADD_EVENT for <" + value + ">; user-defined cache event policy returned null.");
        }
    }

    public void remove(Object key) {
        if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
            LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> removing <" + key + ">");
        }
        super.remove(key);
        DistributedCacheEvent event = this.eventFactory.createRemoveEvent(this.getName(), key);
        Serializable theKey = this.eventPolicy.getRemoveEventTarget(event);
        if (theKey != null) {
            if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> sending REMOVE_EVENT");
            }
            try {
                this.messageBus.processEvent((EventObject)((Object)event));
            }
            catch (MessagingException e) {
                LogManager.logError("DISTRIB_CACHE", (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.003.008.0014", new Object[]{this.cacheName, "REMOVE_EVENT", theKey}));
            }
        } else if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
            LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> NOT sending REMOVE_EVENT for <" + key + ">; user-defined cache event policy returned null.");
        }
    }

    public void clear() {
        if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
            LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> clearing");
        }
        super.clear();
        DistributedCacheEvent event = this.eventFactory.createClearEvent(this.getName());
        Serializable theSource = this.eventPolicy.getClearEventSource(event);
        if (theSource != null) {
            if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
                LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> sending CLEAR_EVENT");
            }
            try {
                this.messageBus.processEvent((EventObject)((Object)event));
            }
            catch (MessagingException e) {
                LogManager.logError("DISTRIB_CACHE", (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.003.008.0014", new Object[]{this.cacheName, "CLEAR_EVENT", theSource}));
            }
        } else if (LogManager.isMessageToBeRecorded("DISTRIB_CACHE", 5)) {
            LogManager.logDetail("DISTRIB_CACHE", "Cache <" + this.cacheName + "> NOT sending CLEAR_EVENT for cache <" + this.getName() + ">; user-defined cache event policy returned null.");
        }
    }

    public String getName() {
        return this.cacheName;
    }

    public String toString() {
        return this.cacheName;
    }
}

