/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.policy;

import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.ObjectCacheStatistics;
import com.metamatrix.common.cache.policy.ObjectCachePolicy;
import java.util.Collection;

public abstract class ResourceRecaptureStrategy {
    private ObjectCachePolicy policy;

    protected void finalize() {
        this.policy = null;
    }

    public void setPolicy(ObjectCachePolicy policy) throws ObjectCacheException {
        this.policy = policy;
        this.initialize();
    }

    public synchronized ObjectCacheStatistics getStatistics() {
        return this.policy.getStatistics();
    }

    public synchronized Object find(Object key) {
        return this.policy.find(key);
    }

    public synchronized void mark(Object key, Object value) {
        this.policy.mark(key, value);
    }

    public synchronized boolean containsValue(Object key) {
        return this.policy.containsValue(key);
    }

    public synchronized Collection getKeysNotInCache(Collection keys) {
        return this.policy.getKeysNotInCache(keys);
    }

    public synchronized void remove(Object key) {
        this.policy.remove(key);
    }

    public synchronized void clear() {
        this.policy.clear();
    }

    public void stop() {
    }

    protected ObjectCachePolicy getPolicy() {
        return this.policy;
    }

    protected void initialize() throws ObjectCacheException {
    }
}

