/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.classloader;

import com.metamatrix.common.classloader.NestedException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassLoaderUtil {
    public static boolean debug = false;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static String getClassLoaderInformation(ClassLoader classLoader, String label) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(byteStream);
        stream.println("START CLASS LOADERS - " + label);
        ClassLoaderUtil.getClassPathRecursively(classLoader, stream);
        stream.println("END CLASS LOADERS - " + label);
        stream.flush();
        return byteStream.toString();
    }

    private static void getClassPathRecursively(ClassLoader classLoader, PrintStream stream) {
        ClassLoaderUtil.getClassPath(classLoader, stream);
        if (classLoader.getParent() != null) {
            ClassLoaderUtil.getClassPathRecursively(classLoader.getParent(), stream);
        }
    }

    private static void getClassPath(ClassLoader classLoader, PrintStream stream) {
        stream.println("ClassLoader: " + classLoader);
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            URL[] urls = urlClassLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                stream.println(urls[i].toString());
            }
        }
    }

    private static void log(String label, String value) {
        if (debug) {
            System.out.println("ClassLoaderUtil " + label + " = " + value);
        }
    }

    public static Object getInstanceInNewClassLoader(String className, String classPath) {
        ClassLoaderUtil.log("className", className);
        ClassLoaderUtil.log("classPath", classPath);
        URLClassLoader classLoader = new URLClassLoader(ClassLoaderUtil.toUrls(classPath), ClassLoaderUtil.getParentClassLoader());
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Object result = clazz.newInstance();
            if (debug) {
                ClassLoaderUtil.log("ClassLoaderUtil.getInstanceInNewClassLoader classLoader information", ClassLoaderUtil.getClassLoaderInformation(result.getClass().getClassLoader(), "object loaded by ClassLoaderUtil.getInstanceInNewClassLoader"));
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new NestedException(e);
        }
        catch (InstantiationException e) {
            throw new NestedException(e);
        }
        catch (IllegalAccessException e) {
            throw new NestedException(e);
        }
    }

    private static ClassLoader getParentClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader parent = loader.getParent();
        while (parent != null) {
            loader = parent;
            parent = loader.getParent();
        }
        return loader;
    }

    private static URL[] toUrls(String classPath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, System.getProperty("path.separator"));
        while (tokenizer.hasMoreElements()) {
            String path = tokenizer.nextToken();
            try {
                urls.add(new File(path).toURL());
            }
            catch (MalformedURLException e) {
                throw new NestedException(e);
            }
        }
        return urls.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(String resourceName) {
        String string;
        block8: {
            StringWriter result = new StringWriter();
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new RuntimeException("Resource not found: " + resourceName);
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(inputStream));
                char[] buffer = new char[1024];
                while (reader.ready()) {
                    int bytesRead = reader.read(buffer);
                    result.write(buffer, 0, bytesRead);
                }
                string = result.toString();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NestedException(e);
                }
            }
            reader.close();
        }
        return string;
    }

    public static void printLoadedClasses(ClassLoader classLoader, PrintStream stream) {
        Class<?> classLoaderClass;
        for (classLoaderClass = classLoader.getClass(); classLoaderClass != (class$java$lang$ClassLoader == null ? ClassLoaderUtil.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader); classLoaderClass = classLoaderClass.getSuperclass()) {
        }
        try {
            Field classesField = classLoaderClass.getDeclaredField("classes");
            classesField.setAccessible(true);
            Vector classes = (Vector)classesField.get(classLoader);
            Iterator i = classes.iterator();
            while (i.hasNext()) {
                Class clazz = (Class)i.next();
                String location = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
                stream.println(location + "\t" + clazz.getName());
            }
        }
        catch (SecurityException e) {
            throw new NestedException(e);
        }
        catch (IllegalArgumentException e) {
            throw new NestedException(e);
        }
        catch (NoSuchFieldException e) {
            throw new NestedException(e);
        }
        catch (IllegalAccessException e) {
            throw new NestedException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

