/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.common.config.api.ReleaseInfo;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.util.ApplicationInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class ProductReleaseInfoUtil {
    private static final String PLATFORM_PROJECT = "platform";
    private static final String SERVER_PROJECT = "server";
    private static final String METADATA_PROJECT = "metadata";
    private static final String CONNECTORS_PROJECT = "connector";
    private static final String METAMATRIX_COMPLETE = "metamatrix-server.jar";
    private static final Map NAMES = new HashMap();
    private static Collection RELEASE_INFOS;

    public static synchronized Collection getProductReleaseInfos() throws ConfigurationException {
        if (RELEASE_INFOS == null) {
            RELEASE_INFOS = new HashSet();
            ApplicationInfo info = ApplicationInfo.getInstance();
            if (!info.isUnmodifiable()) {
                try {
                    info.addComponent(METAMATRIX_COMPLETE);
                }
                catch (ComponentNotFoundException e) {
                    throw new ConfigurationException((Throwable)((Object)e), "Could not load product release information for product platform");
                }
                try {
                    info.setMainComponent(METAMATRIX_COMPLETE);
                }
                catch (ComponentNotFoundException c) {
                    throw new ConfigurationException(c.getMessage());
                }
                info.markUnmodifiable();
            }
            ApplicationInfo.Component component = info.getMainComponent();
            String version = component.getReleaseNumber();
            String date = component.getBuildDate();
            String build = component.getBuildNumber();
            ReleaseInfo releaseInfo = null;
            Iterator i = NAMES.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                String name = (String)NAMES.get(key);
                releaseInfo = new ReleaseInfo(name, version, date, build);
                RELEASE_INFOS.add(releaseInfo);
            }
        }
        return RELEASE_INFOS;
    }

    static {
        NAMES.put(PLATFORM_PROJECT, "Platform");
        NAMES.put(SERVER_PROJECT, "Integration Server");
        NAMES.put(METADATA_PROJECT, "Repository");
        NAMES.put(CONNECTORS_PROJECT, "Connectors");
    }
}

