/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.model.BasicComponentDefn;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class BasicProductServiceConfig
extends BasicComponentDefn
implements ProductServiceConfig,
Serializable {
    private HashMap serviceComponentDefnIDs;

    public BasicProductServiceConfig(ConfigurationID configurationID, ProductServiceConfigID componentID, ProductTypeID productTypeID) {
        super(configurationID, componentID, productTypeID);
        this.serviceComponentDefnIDs = new HashMap();
    }

    protected BasicProductServiceConfig(BasicProductServiceConfig psc) {
        super(psc);
        this.serviceComponentDefnIDs = new HashMap(psc.serviceComponentDefnIDs);
    }

    public boolean isServiceEnabled(ServiceComponentDefnID serviceID) {
        if (this.serviceComponentDefnIDs.containsKey(serviceID)) {
            Boolean b = (Boolean)this.serviceComponentDefnIDs.get(serviceID);
            return b;
        }
        return false;
    }

    public void setServiceEnabled(ServiceComponentDefnID serviceID, boolean isEnabled) {
        if (this.serviceComponentDefnIDs.containsKey(serviceID)) {
            this.serviceComponentDefnIDs.put(serviceID, isEnabled);
        }
    }

    public boolean containsService(ServiceComponentDefnID serviceID) {
        return this.serviceComponentDefnIDs.containsKey(serviceID);
    }

    public Collection getServiceComponentDefnIDs() {
        return new HashSet(this.serviceComponentDefnIDs.keySet());
    }

    void resetServices() {
        this.serviceComponentDefnIDs.clear();
    }

    void addServiceComponentDefnID(ServiceComponentDefnID serviceDefnID) {
        this.serviceComponentDefnIDs.put(serviceDefnID, Boolean.TRUE);
    }

    void removeServiceComponentDefnID(ServiceComponentDefnID serviceDefnID) {
        this.serviceComponentDefnIDs.remove(serviceDefnID);
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return new BasicProductServiceConfig(this);
    }
}

