/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfig_42_HelperImpl;
import com.metamatrix.common.util.DateUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Content;
import org.jdom.Element;

public class XMLHelperUtil {
    static final String DEFAULT_USER_CREATED_BY = "Unknown";
    static final String APPLICATION_CREATED_BY = "ApplicationCreatedBy";
    static final String APPLICATION_VERSION_CREATED_BY = "ApplicationVersion";
    static final String USER_CREATED_BY = "UserCreatedBy";
    static final String CONFIGURATION_VERSION = "ConfigurationVersion";
    static final String METAMATRIX_SYSTEM_VERSION = "MetaMatrixSystemVersion";
    static final String TIME = "Time";
    static final String MM_CONFIG_4_2_VERSION = "4.2";
    static final String MM_CONFIG_3_0_VERSION = "3.0";
    static final double MM_LATEST_CONFIG_VERSION = 4.2;

    public static final boolean is42ConfigurationCompatible(Element root) throws InvalidConfigurationElementException {
        Element headerElement = root.getChild("Header");
        if (headerElement == null) {
            return false;
        }
        Properties props = XMLHelperUtil.getHeaderProperties(headerElement);
        return XMLHelperUtil.is42ConfigurationCompatible(props);
    }

    public static final boolean is42ConfigurationCompatible(Properties props) throws InvalidConfigurationElementException {
        String sVersion = props.getProperty(CONFIGURATION_VERSION);
        if (sVersion == null) {
            return false;
        }
        try {
            double sv = Double.parseDouble(sVersion);
            return sv >= 4.2;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static final Properties getHeaderProperties(Element element) throws InvalidConfigurationElementException {
        Properties props = new Properties();
        if (!element.getName().equals("Header")) {
            throw new InvalidConfigurationElementException("This is not the header element: " + element.getName() + ".", (Object)element);
        }
        List elements = element.getChildren();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            props.setProperty(e.getName(), e.getText());
        }
        return props;
    }

    public static final Element addHeaderElement(Element root, Properties properties) {
        XMLConfig_42_HelperImpl xmlHelper = new XMLConfig_42_HelperImpl();
        root.addContent((Content)xmlHelper.createHeaderElement(XMLHelperUtil.createHeaderProperties(properties)));
        return root;
    }

    protected static Properties createHeaderProperties(Properties props) {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty(USER_CREATED_BY, DEFAULT_USER_CREATED_BY);
        if (props != null) {
            defaultProperties.putAll((Map<?, ?>)props);
        }
        defaultProperties.setProperty(CONFIGURATION_VERSION, MM_CONFIG_4_2_VERSION);
        defaultProperties.setProperty(METAMATRIX_SYSTEM_VERSION, "5.0");
        defaultProperties.setProperty(TIME, DateUtil.getCurrentDateAsString());
        return defaultProperties;
    }
}

