/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.connection;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.ManagedConnectionPool;
import com.metamatrix.common.connection.TransactionInterface;

public abstract class Transaction
implements TransactionInterface {
    private static boolean ROLLBACK_ON_FINALIZE = true;
    private ManagedConnection connection;
    private ManagedConnectionPool connectionPool;
    private boolean readonly = true;
    private boolean isEnded = false;

    protected void finalize() {
        this.close();
    }

    protected Transaction(ManagedConnectionPool connectionPool, ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        if (connectionPool == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.010.0002"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.010.0004"));
        }
        this.connectionPool = connectionPool;
        this.readonly = readonly;
        this.connection = connection;
        this.connection.setTransaction(this);
    }

    public final void commit() throws ManagedConnectionException {
        if (this.isEnded()) {
            if (this.isClosed()) {
                throw new ManagedConnectionException("ERR.003.010.0002", CommonPlugin.Util.getString("ERR.003.010.0002"));
            }
            throw new ManagedConnectionException("ERR.003.010.0003", CommonPlugin.Util.getString("ERR.003.010.0003"));
        }
        this.connection.commit();
        this.isEnded = true;
    }

    public final void rollback() throws ManagedConnectionException {
        if (this.isEnded()) {
            if (this.isClosed()) {
                throw new ManagedConnectionException("ERR.003.010.0002", CommonPlugin.Util.getString("ERR.003.010.0002"));
            }
            throw new ManagedConnectionException("ERR.003.010.0003", CommonPlugin.Util.getString("ERR.003.010.0003"));
        }
        if (!this.isReadonly()) {
            this.connection.rollback();
            this.isEnded = true;
        }
    }

    public ManagedConnection getConnection() throws ManagedConnectionException {
        if (this.isClosed()) {
            throw new ManagedConnectionException("ERR.003.010.0002", CommonPlugin.Util.getString("ERR.003.010.0002"));
        }
        return this.connection;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public final boolean isEnded() {
        return this.isEnded;
    }

    public final boolean isClosed() {
        return this.connection == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (!this.isClosed()) {
            try {
                block10: {
                    try {
                        if (this.isReadonly()) {
                            if (!this.isEnded()) {
                                this.commit();
                            }
                            this.connectionPool.checkInReadConnection(this.connection);
                            break block10;
                        }
                        if (!this.isEnded()) {
                            if (ROLLBACK_ON_FINALIZE) {
                                this.rollback();
                            } else {
                                this.commit();
                            }
                        }
                        this.connectionPool.checkInWriteConnection(this.connection);
                    }
                    catch (ManagedConnectionException managedConnectionException) {
                        Object var3_2 = null;
                        this.connection = null;
                        this.connectionPool = null;
                    }
                }
                Object var3_1 = null;
                this.connection = null;
                this.connectionPool = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.connection = null;
                this.connectionPool = null;
                throw throwable;
            }
        }
    }

    public static final boolean getRollbackOnFinalize() {
        return ROLLBACK_ON_FINALIZE;
    }

    public static final void setRollbackOnFinalize(boolean rollback) {
        ROLLBACK_ON_FINALIZE = rollback;
    }
}

