/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.connection.ldap;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import java.util.Properties;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;

public class LDAPManagedConnection
extends ManagedConnection {
    private static final String NO_LDAP_USER_NAME = "NoLDAPUserAssigned";
    private DirContext dirContext;
    private String database;

    public LDAPManagedConnection(Properties env) {
        super(env);
        super.setUserName(NO_LDAP_USER_NAME);
    }

    public LDAPManagedConnection(Properties env, String userName) {
        super(env);
        super.setUserName(userName);
    }

    public DirContext getContext() {
        return this.dirContext;
    }

    protected void openConnection() throws ManagedConnectionException {
        LogManager.logTrace("RESOURCE_POOLING", "Opening connection to JNDI");
        Properties env = this.getEnvironment();
        String driverClassName = env.getProperty("com.metamatrix.common.connection.ManagedConnection.Driver");
        String protocol = env.getProperty("com.metamatrix.common.connection.ManagedConnection.Protocol");
        this.database = env.getProperty("com.metamatrix.common.connection.ManagedConnection.Database");
        String username = env.getProperty("com.metamatrix.common.connection.ManagedConnection.User");
        String password = env.getProperty("com.metamatrix.common.connection.ManagedConnection.Password");
        Properties jndiEnv = new Properties();
        if (driverClassName != null && driverClassName.trim().length() != 0) {
            jndiEnv.setProperty("java.naming.factory.initial", driverClassName);
        }
        if (protocol != null && protocol.trim().length() != 0) {
            jndiEnv.setProperty("java.naming.security.authentication", protocol);
        }
        if (this.database != null && this.database.trim().length() != 0) {
            jndiEnv.setProperty("java.naming.provider.url", this.database);
        }
        if (username != null && username.trim().length() != 0) {
            jndiEnv.setProperty("java.naming.security.principal", username);
            if (password != null && password.trim().length() != 0) {
                char[] pwd = null;
                try {
                    pwd = CryptoUtil.stringDecrypt(password.toCharArray());
                }
                catch (CryptoException e) {
                    throw new ManagedConnectionException((Throwable)((Object)e), "ERR.003.010.0015", CommonPlugin.Util.getString("ERR.003.010.0015"));
                }
                jndiEnv.setProperty("java.naming.security.credentials", new String(pwd));
            }
        }
        try {
            this.dirContext = new InitialLdapContext(jndiEnv, null);
        }
        catch (Exception e) {
            throw new ManagedConnectionException(e, "ERR.003.010.0016", CommonPlugin.Util.getString("ERR.003.010.0016", (Object)this.database));
        }
    }

    protected void closeConnection() throws ManagedConnectionException {
        if (this.dirContext != null) {
            LogManager.logTrace("RESOURCE_POOLING", "Closing connection to JNDI");
            try {
                this.dirContext.close();
                this.dirContext = null;
            }
            catch (Exception e) {
                throw new ManagedConnectionException(e, "ERR.003.010.0017", CommonPlugin.Util.getString("ERR.003.010.0017", (Object)this.database));
            }
        }
    }

    protected void prepareForRead() throws ManagedConnectionException {
    }

    protected void prepareForWrite() throws ManagedConnectionException {
    }

    protected void performCommit() throws ManagedConnectionException {
    }

    protected void performRollback() throws ManagedConnectionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("\n**Beginning testing of LDAPManagedConnection ...");
        try {
            String url = "ldap://slux1dv02:389/";
            String metaMatrixDn = "ou=metaMatrix11, ou=applications, o=metamatrix.com";
            String dn = "ou=properties, " + metaMatrixDn;
            String principle = "uid=propMgnt, ou=accounts, " + metaMatrixDn;
            String authentication = "SIMPLE";
            Properties initialContextEnv = new Properties();
            initialContextEnv.put("com.metamatrix.common.connection.ManagedConnection.Driver", "com.sun.jndi.ldap.LdapCtxFactory");
            initialContextEnv.put("com.metamatrix.common.connection.ManagedConnection.Database", url + dn);
            initialContextEnv.put("com.metamatrix.common.connection.ManagedConnection.User", principle);
            initialContextEnv.put("com.metamatrix.common.connection.ManagedConnection.Password", "propMgnt");
            initialContextEnv.put("com.metamatrix.common.connection.ManagedConnection.Protocol", authentication);
            System.out.println("Attempting to get a connection to \"" + url + dn + "\" ...");
            LDAPManagedConnection newConnection = new LDAPManagedConnection(initialContextEnv);
            newConnection.openConnection();
            if (newConnection.getContext() != null) {
                System.out.println("Obtained connection!");
            }
            newConnection.closeConnection();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.out.println("\n**Completed testing of LDAPManagedConnection ...");
    }
}

