/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.connection.BaseTransaction;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.jdbc.JDBCMgdResourceConnection;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.spi.ExtensionModuleTransaction;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleReader;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleWriter;
import com.metamatrix.common.log.LogManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public class JDBCExtensionModuleTransaction
extends BaseTransaction
implements ExtensionModuleTransaction {
    private Connection jdbcConnection;
    private static final String CONTEXT = "JDBC_EXT_MODULE_TRANSACTION";

    JDBCExtensionModuleTransaction(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        super(connection, readonly);
        try {
            JDBCMgdResourceConnection jdbcManagedConnection = (JDBCMgdResourceConnection)connection;
            this.jdbcConnection = jdbcManagedConnection.getConnection();
        }
        catch (Exception e) {
            throw new ManagedConnectionException("ERR.014.004.0051", CommonPlugin.Util.getString("ERR.014.004.0051"));
        }
    }

    public ExtensionModuleDescriptor addSource(String principalName, String type, String sourceName, byte[] data, long checksum, String description, boolean enabled) throws DuplicateExtensionModuleException, MetaMatrixComponentException {
        return JDBCExtensionModuleWriter.addSource(principalName, type, sourceName, data, checksum, description, enabled, this.jdbcConnection);
    }

    public void removeSource(String principalName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        JDBCExtensionModuleWriter.removeSource(principalName, sourceName, this.jdbcConnection);
    }

    public List getSourceNames() throws MetaMatrixComponentException {
        return JDBCExtensionModuleReader.getSourceNames(this.jdbcConnection);
    }

    public List getSourceDescriptors() throws MetaMatrixComponentException {
        return this.getSourceDescriptors(null, true);
    }

    public List getSourceDescriptors(String type, boolean includeDisabled) throws MetaMatrixComponentException {
        return JDBCExtensionModuleReader.getSourceDescriptors(type, includeDisabled, this.jdbcConnection);
    }

    public ExtensionModuleDescriptor getSourceDescriptor(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        return JDBCExtensionModuleReader.getSourceDescriptor(sourceName, this.jdbcConnection);
    }

    public void setSearchOrder(String principalName, List sourceNames) throws ExtensionModuleOrderingException, MetaMatrixComponentException {
        JDBCExtensionModuleWriter.setSearchOrder(principalName, sourceNames, this.jdbcConnection);
    }

    public void setEnabled(String principalName, Collection sourceNames, boolean enabled) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        JDBCExtensionModuleWriter.setEnabled(principalName, sourceNames, enabled, this.jdbcConnection);
    }

    public byte[] getSource(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        try {
            return JDBCExtensionModuleReader.getSource(sourceName, this.jdbcConnection);
        }
        catch (SQLException se) {
            LogManager.logError(CONTEXT, (Throwable)se, CommonPlugin.Util.getString("ERR.014.004.0047", (Object)sourceName));
            throw new MetaMatrixComponentException(se, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", (Object)sourceName));
        }
        catch (ExtensionModuleNotFoundException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException(e, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", (Object)sourceName));
        }
    }

    public ExtensionModuleDescriptor setSource(String principalName, String sourceName, byte[] data, long checksum) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        JDBCExtensionModuleWriter.setSource(principalName, sourceName, data, checksum, this.jdbcConnection);
        return JDBCExtensionModuleReader.getSourceDescriptor(sourceName, this.jdbcConnection);
    }

    public ExtensionModuleDescriptor setSourceName(String principalName, String sourceName, String newName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        return JDBCExtensionModuleWriter.setSourceName(principalName, sourceName, newName, this.jdbcConnection);
    }

    public ExtensionModuleDescriptor setSourceDescription(String principalName, String sourceName, String description) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        return JDBCExtensionModuleWriter.setSourceDescription(principalName, sourceName, description, this.jdbcConnection);
    }

    public boolean needsRefresh() throws MetaMatrixComponentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isNameInUse(String sourceName) throws MetaMatrixComponentException {
        return JDBCExtensionModuleReader.isNameInUse(sourceName, this.jdbcConnection);
    }
}

