/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.sql;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.jdbc.JDBCUtil;
import com.metamatrix.common.jdbc.sql.SQLProcessor;
import com.metamatrix.common.util.PropertiesUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;

public class SQLExecutionManager {
    public static final String BLANK = " ";
    private String sqlFile;
    private Properties configProps;
    private PrintStream logger = System.out;
    private boolean passedLogger = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Properties props) throws Exception {
        if (props == null || props.size() < 1) {
            throw new Exception(CommonPlugin.Util.getString("ERR.003.015.0064"));
        }
        this.init(props);
        Connection theConnection = this.createConnection(this.configProps);
        try {
            this.runProcess(theConnection);
        }
        catch (Throwable t) {
        }
        finally {
            try {
                theConnection.close();
            }
            catch (Exception e) {}
        }
    }

    public void run(Properties props, Connection connection, PrintStream outputStream) throws Exception {
        if (props == null || props.size() < 1) {
            throw new Exception(CommonPlugin.Util.getString("ERR.003.015.0064"));
        }
        if (outputStream != null) {
            this.logger = outputStream;
            this.passedLogger = true;
        }
        this.init(props);
        this.runProcess(connection);
    }

    private void init(Properties props) throws Exception {
        this.configProps = props;
        if (!this.passedLogger) {
            String logfile = props.getProperty("logfile");
            if (logfile == null) {
                logfile = "SQLProcessor.log";
            }
            FileOutputStream lfos = new FileOutputStream(new File(logfile));
            this.logger = new PrintStream(lfos);
        }
        this.sqlFile = props.getProperty("sqlfile");
        if (this.sqlFile == null || this.sqlFile.length() == 0) {
            this.logger.print(CommonPlugin.Util.getString("ERR.003.015.0063", (Object)"sqlfile"));
            throw new Exception(CommonPlugin.Util.getString("ERR.003.015.0063", (Object)"sqlfile"));
        }
    }

    private void runProcess(Connection theConnection) throws Exception {
        PropertiesUtils.print(this.logger, this.configProps);
        List statements = SQLExecutionManager.readFile(this.sqlFile, theConnection, this.configProps);
        SQLProcessor process = new SQLProcessor();
        process.executeListOfStatements(theConnection, statements, this.configProps, this.logger);
    }

    private Connection createConnection(Properties props) throws Exception {
        Connection theConnection = JDBCUtil.createJDBCConnection(props);
        return theConnection;
    }

    public static List readFile(String fileName, Connection theConnection, Properties props) throws Exception {
        List result = null;
        String delim = props.getProperty("delimiter");
        if (delim == null || delim.length() == 0) {
            JDBCPlatform platform = JDBCPlatformFactory.getPlatform(theConnection);
            delim = platform.isOracle() ? ";" : (platform.isMSSQL() ? "GO" : (platform.isDB2() ? "%" : ";"));
        }
        BufferedReader reader = SQLExecutionManager.openFileForReading(fileName);
        JDBCPlatform platform = JDBCPlatformFactory.getPlatform(theConnection);
        result = platform.parseToExecutableStatements(reader, delim);
        SQLExecutionManager.closeFileForReading(reader);
        return result;
    }

    private static BufferedReader openFileForReading(String fileName) throws FileNotFoundException, IOException {
        BufferedReader inputStream = null;
        inputStream = new BufferedReader(new FileReader(fileName));
        return inputStream;
    }

    private static void closeFileForReading(Reader inputStream) throws FileNotFoundException, IOException {
        try {
            inputStream.close();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public static Connection getCurrentConfigurationConnection() throws MetaMatrixException {
        Properties resourceProps = CurrentConfiguration.getResourceProperties("ConfigurationService");
        String poolName = resourceProps.getProperty("metamatrix.common.pooling.resource.name");
        if (poolName == null || poolName.length() == 0) {
            throw new MetaMatrixException("Pool name was not found in the resource properties for ConfigurationService");
        }
        Connection conn = JDBCConnectionPoolHelper.getConnection(poolName, "EXECUTE_SQL");
        return conn;
    }
}

