/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.messaging.rmi;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.common.messaging.rmi.RemoteEventObject;
import com.metamatrix.common.messaging.rmi.RemoteEventObjectListener;
import com.metamatrix.common.messaging.rmi.RemoteEventObjectListenerImpl;
import com.metamatrix.common.messaging.rmi.RemoteRMIMessageBus;
import com.metamatrix.common.messaging.rmi.RemoteRMIMessageBusInterface;
import com.metamatrix.common.util.RemoteUtil;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.core.event.EventBroker;
import com.metamatrix.core.event.EventObjectListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class RMIMessageBus
implements MessageBus {
    public static final String MESSAGE_BUS_URL = "metamatrix.jms.connection.url";
    public static final String MESSAGE_BUS_USER = "metamatrix.jms.connection.username";
    public static final String MESSAGE_BUS_PASSWORD = "metamatrix.jms.connection.password";
    public static final String MESSAGE_BUS_CONTEXT_FACTORY = "metamatrix.jms.connection.contextFactory";
    public static final String REMOTE_MESSAGE_BUS_JNDI_NAME = "metamatrixmessagebusrmi";
    private Hashtable connectionEnv = null;
    private EventBroker eventBroker;
    private RemoteEventObjectListener remoteListener;
    private int remoteListenerID = -1;
    private String url;
    private String user;
    private String password;
    private String contextFactory;
    private RemoteRMIMessageBusInterface remoteMessageBus;
    static /* synthetic */ Class class$com$metamatrix$common$messaging$rmi$RemoteRMIMessageBusInterface;
    static /* synthetic */ Class class$com$metamatrix$common$messaging$rmi$RemoteEventObject;

    public RMIMessageBus(Properties env, EventBroker eventBroker) {
        this.eventBroker = eventBroker;
        this.url = env.getProperty(MESSAGE_BUS_URL);
        this.user = env.getProperty(MESSAGE_BUS_USER);
        this.password = env.getProperty(MESSAGE_BUS_PASSWORD);
        this.contextFactory = env.getProperty(MESSAGE_BUS_CONTEXT_FACTORY);
        CommonPlugin.Util.trace("MESSAGE_BUS", "RMIMessageBus, connecting with url: " + this.url + " user: " + this.user);
        Context context = null;
        try {
            context = this.getContext();
            this.remoteMessageBus = (RemoteRMIMessageBusInterface)PortableRemoteObject.narrow((Object)context.lookup(REMOTE_MESSAGE_BUS_JNDI_NAME), (Class)(class$com$metamatrix$common$messaging$rmi$RemoteRMIMessageBusInterface == null ? (class$com$metamatrix$common$messaging$rmi$RemoteRMIMessageBusInterface = RMIMessageBus.class$("com.metamatrix.common.messaging.rmi.RemoteRMIMessageBusInterface")) : class$com$metamatrix$common$messaging$rmi$RemoteRMIMessageBusInterface));
        }
        catch (Exception e) {
            CommonPlugin.Util.trace("MESSAGE_BUS", "Could not find RMIMessageBus, creating an instance.");
        }
        if (this.remoteMessageBus == null) {
            this.remoteMessageBus = new RemoteRMIMessageBus();
            try {
                RemoteUtil.exportObject(this.remoteMessageBus);
                context.rebind(REMOTE_MESSAGE_BUS_JNDI_NAME, (Object)this.remoteMessageBus);
                CommonPlugin.Util.trace("MESSAGE_BUS", "Bound RemoteRMIMessageBus to jndi");
            }
            catch (Exception e) {
                System.out.println("Error binding remoteMessageBus to jndi");
                e.printStackTrace();
            }
        }
        this.remoteListener = new RemoteEventObjectListenerImpl(this);
        try {
            RemoteUtil.exportObject(this.remoteListener);
            this.remoteListenerID = this.remoteMessageBus.addListener(class$com$metamatrix$common$messaging$rmi$RemoteEventObject == null ? (class$com$metamatrix$common$messaging$rmi$RemoteEventObject = RMIMessageBus.class$("com.metamatrix.common.messaging.rmi.RemoteEventObject")) : class$com$metamatrix$common$messaging$rmi$RemoteEventObject, this.remoteListener);
        }
        catch (Exception e) {
            System.out.println("Error adding listener to remoteMessageBus");
            e.printStackTrace();
        }
    }

    public synchronized void addListener(Class eventClass, EventObjectListener listener) throws MessagingException {
    }

    public void processEvent(EventObject obj) throws MessagingException {
        if (obj != null) {
            try {
                this.remoteMessageBus.processEvent(new RemoteEventObject(this, obj, this.remoteListenerID));
            }
            catch (Exception e) {
                LogManager.logCritical("MESSAGE_BUS", (Throwable)e, CommonPlugin.Util.getString("ERR.003.017.0004"));
                throw new MessagingException(e, "ERR.003.017.0004", CommonPlugin.Util.getString("ERR.003.017.0004"));
            }
        }
    }

    public void shutdown() throws MessagingException {
        LogManager.logCritical("MESSAGE_BUS", CommonPlugin.Util.getString("MSG.003.017.0001"));
        try {
            this.remoteMessageBus.removeListener(this.remoteListener);
        }
        catch (Exception e) {
            System.out.println("Error removing listener from RemoteMessageBus");
            e.printStackTrace();
        }
    }

    public synchronized void removeListener(Class eventClass, EventObjectListener listener) throws MessagingException {
    }

    public synchronized void removeListener(EventObjectListener listener) throws MessagingException {
    }

    public static MessageBus getNoOpMessageBus() {
        return new NoOpMessageBus();
    }

    private Context getContext() throws NamingException, MessagingException {
        boolean running_in_vm;
        String propVal = System.getProperty("metamatrix.appserver_vm");
        boolean bl = running_in_vm = propVal != null && propVal.equalsIgnoreCase("true");
        if (running_in_vm) {
            return new InitialContext();
        }
        if (this.connectionEnv == null) {
            this.connectionEnv = new Hashtable();
            if (this.contextFactory != null) {
                this.connectionEnv.put("java.naming.factory.initial", this.contextFactory);
            }
            if (this.url != null) {
                this.connectionEnv.put("java.naming.provider.url", this.url);
            }
            if (this.user != null && this.user.trim().length() > 0) {
                this.connectionEnv.put("java.naming.security.principal", this.user);
                String connectionPassword = "";
                if (this.password != null && this.password.trim().length() > 0) {
                    try {
                        char[] pwd = CryptoUtil.stringDecrypt(this.password.toCharArray());
                        connectionPassword = new String(pwd);
                    }
                    catch (CryptoException e) {
                        throw new MessagingException((Throwable)((Object)e), "ERR.003.017.0010", CommonPlugin.Util.getString("ERR.003.017.0010"));
                    }
                }
                this.connectionEnv.put("java.naming.security.credentials", connectionPassword);
            }
        }
        return new InitialContext(this.connectionEnv);
    }

    public void remoteProcessEvent(EventObject obj) throws MessagingException {
        RemoteEventObject remoteEvent = (RemoteEventObject)obj;
        if (remoteEvent.getSourceID() != this.remoteListenerID) {
            EventObject event = remoteEvent.getEvent();
            this.eventBroker.processEvent(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

