/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.impl;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.pooling.api.PoolStatistic;
import com.metamatrix.core.util.ArgCheck;
import java.io.Serializable;
import java.util.Date;

public abstract class BasicPoolStatistic
implements PoolStatistic,
Serializable {
    public static final long serialVersionUID = -984913469025279555L;
    public static final int TYPE_SUM = 1;
    public static final int TYPE_AVG = 2;
    public static final int TYPE_HIGHEST = 3;
    public static final int TYPE_LOWEST = 4;
    private String name;
    private String displayName;
    private String description;
    private int aggregateType;
    private long startDateTime;

    protected BasicPoolStatistic(String statName, String displayName, String description, int aggregateType) {
        if (statName == null) {
            ArgCheck.isNotNull((Object)statName, (String)CommonPlugin.Util.getString("ERR.003.002.0010"));
        }
        if (displayName == null) {
            ArgCheck.isNotNull((Object)displayName, (String)CommonPlugin.Util.getString("ERR.003.002.0011"));
        }
        if (description == null) {
            ArgCheck.isNotNull((Object)description, (String)CommonPlugin.Util.getString("ERR.003.002.0012"));
        }
        this.name = statName;
        this.displayName = displayName;
        this.description = description;
        this.aggregateType = aggregateType;
        this.performReset();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getAggregationType() {
        return this.aggregateType;
    }

    public long getStartDateTime() {
        return this.startDateTime;
    }

    protected void performReset() {
        this.startDateTime = new Date().getTime();
        this.reset();
    }

    public void increment() {
    }

    public void decrement() {
    }

    public void increment(long value) {
    }

    public void decrement(long value) {
    }

    public abstract void reset();
}

