/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.impl;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourceContainer;
import com.metamatrix.common.pooling.api.ResourcePool;
import com.metamatrix.common.pooling.api.ResourceStatistics;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.impl.BaseResource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BasicResourceContainer
implements ResourceContainer {
    private Map checkedOutResources;
    private Object resourceObject = null;
    private BaseResource holdResource;
    private ResourcePool pool = null;
    private ResourceStatistics stats = new ResourceStatistics();
    private int maxUsers = 1;
    private boolean shutdown = false;
    protected static final String LOG_CONTEXT = "RESOURCE_POOLING";
    private static final String HOLD_FOR_CONTAINER = "HoldForContainer";

    public BasicResourceContainer(long containerID) {
    }

    public synchronized void init(ResourcePool resourcePool, Object physicalResourceObject, int maxConcurrentUsers) throws ResourcePoolException {
        this.pool = resourcePool;
        this.resourceObject = physicalResourceObject;
        this.maxUsers = maxConcurrentUsers;
        this.checkedOutResources = new HashMap(this.maxUsers);
        this.holdResource = (BaseResource)this.pool.getResourceAdapter().createResource(physicalResourceObject);
        this.holdResource.init(this, HOLD_FOR_CONTAINER);
        LogManager.logTrace(LOG_CONTEXT, "ResourceContainer created for resource " + resourcePool.getResourceDescriptor().getName());
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.pool.getResourceDescriptor();
    }

    public Properties getProperties() {
        return this.pool.getResourceDescriptor().getProperties();
    }

    public boolean hasAvailableResource() {
        return this.getStats().getConcurrentUserCount() < this.maxUsers;
    }

    public synchronized boolean isAlive() throws ResourcePoolException {
        if (this.pool == null || this.resourceObject == null) {
            return false;
        }
        return this.holdResource.isResourceAlive();
    }

    public synchronized Resource checkOut(String userName) throws ResourcePoolException {
        BaseResource resource = (BaseResource)this.pool.getResourceAdapter().createResource(this.resourceObject);
        resource.init(this, userName);
        this.checkedOutResources.put(resource, userName);
        this.getStats().addConcurrentUser(userName);
        LogManager.logTrace(LOG_CONTEXT, "ResourceContainer checkout resource for user " + userName);
        return resource;
    }

    public synchronized boolean checkin(Resource resource, String userName) throws ResourcePoolException {
        if (this.shutdown) {
            return true;
        }
        if (!this.checkedOutResources.containsKey(resource)) {
            throw new ResourcePoolException(CommonPlugin.Util.getString("ERR.003.002.0013", new Object[]{userName, this.pool.getResourceDescriptorID()}));
        }
        this.checkedOutResources.remove(resource);
        ResourceStatistics stats = this.getStats();
        stats.removeConcurrentUser(userName);
        this.pool.checkIn(this, userName);
        LogManager.logTrace(LOG_CONTEXT, "ResourceContainer checkin resource for user " + userName);
        return true;
    }

    public Object getResourceObject() {
        return this.resourceObject;
    }

    public final synchronized void shutDown() throws ResourcePoolException {
        try {
            try {
                this.shutdown = true;
                this.pool.getResourceAdapter().closePhyicalResourceObject(this.holdResource);
            }
            catch (Exception e) {
                throw new ResourcePoolException(e, "ERR.003.002.0014", CommonPlugin.Util.getString("ERR.003.002.0014", (Object)this.pool.getResourceDescriptor().getName()));
            }
            Object var3_1 = null;
            this.pool = null;
            this.stats = null;
            this.resourceObject = null;
            this.holdResource = null;
            this.checkedOutResources.clear();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.pool = null;
            this.stats = null;
            this.resourceObject = null;
            this.holdResource = null;
            this.checkedOutResources.clear();
            throw throwable;
        }
    }

    public ResourceStatistics getStats() {
        return this.stats;
    }

    protected ResourcePool getResourcePool() {
        return this.pool;
    }
}

