/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.impl;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ResourceDescriptorID;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourceAdapter;
import com.metamatrix.common.pooling.api.ResourceContainer;
import com.metamatrix.common.pooling.api.ResourcePool;
import com.metamatrix.common.pooling.api.ResourcePoolStatisticNames;
import com.metamatrix.common.pooling.api.ResourcePoolStatistics;
import com.metamatrix.common.pooling.api.ResourceStatistics;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.api.exception.ResourceWaitTimeOutException;
import com.metamatrix.common.pooling.impl.BasicPoolStatistic;
import com.metamatrix.common.pooling.impl.BasicResourceContainer;
import com.metamatrix.common.pooling.impl.BasicResourcePoolStatistics;
import com.metamatrix.common.pooling.impl.CleanUpThread;
import com.metamatrix.common.pooling.impl.statistics.CounterStat;
import com.metamatrix.common.pooling.impl.statistics.HighestValueStat;
import com.metamatrix.common.pooling.util.PoolingUtil;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.ArgCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BasicResourcePool
implements ResourcePool {
    private ResourceDescriptor resourceDescriptor;
    private Properties properties;
    private int minimum_pool_size;
    private int maximum_pool_size;
    private int num_concurrent_users_allowed;
    private long liveAndUsedTime;
    private long shrinkPeriod;
    private int shrinkIncrement;
    private boolean allowsShrinking = true;
    private boolean extendMode = false;
    private double extendPercent = 0.0;
    private int extend_maximum_pool_size;
    private long waitForResourceTime;
    private long containerCounter = 0L;
    private ResourceAdapter resourceAdapter;
    WriterPreferenceReadWriteLock lock;
    private CleanUpThread cleanerThread;
    private boolean shutdownRequested = false;
    private Set resourcePool = Collections.synchronizedSet(new HashSet(25));
    private Set inuseResourcePool = Collections.synchronizedSet(new HashSet(25));
    protected static final String CONTEXT = "RESOURCE_POOLING";
    private BasicResourcePoolStatistics poolStatistics;
    private static BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor();
    static /* synthetic */ Class class$com$metamatrix$common$pooling$api$ResourceAdapter;

    public BasicResourcePool() {
        this.lock = new WriterPreferenceReadWriteLock();
    }

    public void init(ResourceDescriptor descriptor) throws ResourcePoolException {
        if (descriptor == null) {
            ArgCheck.isNotNull((Object)descriptor, (String)CommonPlugin.Util.getString("ERR.003.002.0015"));
        }
        try {
            this.lock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.resourceDescriptor = descriptor;
            this.initProperties();
            this.initStatistics();
            this.initResources();
            this.cleanerThread = new CleanUpThread(this, this.shrinkPeriod);
            this.cleanerThread.start();
        }
        catch (ResourcePoolException e) {
            I18nLogManager.logError(CONTEXT, "ERR.003.002.0016", (Throwable)((Object)e), new Object[]{this.resourceDescriptor.getName()});
            throw e;
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public int getResourcePoolSize() {
        return this.resourcePool.size() + this.inuseResourcePool.size();
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public ResourceDescriptorID getResourceDescriptorID() {
        return (ResourceDescriptorID)this.resourceDescriptor.getID();
    }

    public ComponentTypeID getComponentTypeID() {
        return this.resourceDescriptor.getComponentTypeID();
    }

    public ResourcePoolStatistics getResourcePoolStatistics() {
        return this.poolStatistics;
    }

    public Collection getPoolResourceStatistics() {
        ResourceContainer rc;
        ArrayList<ResourceStatistics> stats = new ArrayList<ResourceStatistics>();
        HashSet inusePool = new HashSet(this.inuseResourcePool);
        HashSet pool = new HashSet(this.resourcePool);
        Iterator iter = inusePool.iterator();
        while (iter.hasNext()) {
            rc = (ResourceContainer)iter.next();
            stats.add(rc.getStats());
        }
        iter = pool.iterator();
        while (iter.hasNext()) {
            rc = (ResourceContainer)iter.next();
            stats.add(rc.getStats());
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutDown() {
        String pn = this.resourceDescriptor.getName();
        this.shutdownRequested = true;
        try {
            if (this.cleanerThread != null) {
                this.cleanerThread.stopCleanup();
            }
        }
        catch (Exception e) {
            I18nLogManager.logError(CONTEXT, "ERR.003.002.0017", (Throwable)e, new Object[]{pn});
        }
        finally {
            this.cleanerThread = null;
        }
        try {
            if (this.resourcePool != null) {
                this.closeContainers(this.resourcePool);
            }
        }
        catch (Exception e) {
            I18nLogManager.logError(CONTEXT, "ERR.003.002.0017", (Throwable)e, new Object[]{pn});
        }
        finally {
            this.resourcePool.clear();
        }
        try {
            block18: {
                try {
                    if (this.inuseResourcePool == null) break block18;
                    this.closeContainers(this.inuseResourcePool);
                }
                catch (Exception e) {
                    I18nLogManager.logError(CONTEXT, "ERR.003.002.0017", (Throwable)e, new Object[]{pn});
                    Object var6_9 = null;
                    this.inuseResourcePool.clear();
                    this.resourceDescriptor = null;
                    this.poolStatistics = null;
                    this.resourceAdapter = null;
                }
            }
            Object var6_8 = null;
            this.inuseResourcePool.clear();
            this.resourceDescriptor = null;
            this.poolStatistics = null;
            this.resourceAdapter = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.inuseResourcePool.clear();
            this.resourceDescriptor = null;
            this.poolStatistics = null;
            this.resourceAdapter = null;
            throw throwable;
        }
    }

    public synchronized void update(Properties properties) throws ResourcePoolException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        try {
            Properties props = PropertiesUtils.clone(properties, false);
            props = this.updatePoolProperties(props);
            editor.modifyProperties(this.resourceDescriptor, props, 1);
            this.properties.putAll((Map<?, ?>)props);
        }
        catch (Exception e) {
            I18nLogManager.logError(CONTEXT, "ERR.003.002.0018", (Throwable)e, new Object[]{this.resourceDescriptor.getName()});
            throw new ResourcePoolException(e, "ERR.003.002.0018", CommonPlugin.Util.getString("ERR.003.002.0018", (Object)this.resourceDescriptor.getName()));
        }
    }

    private Properties updatePoolProperties(Properties props) {
        String extendPercentParm;
        String extendModeParm;
        String concurrentUsersValue;
        String waitTimeParm;
        String shrinkIncrementParm;
        String allowShrinkParm;
        String shrinkPeriodParm;
        String minimumSizeParm;
        Properties changes = new Properties();
        String maximumSizeParm = props.getProperty("pooling.resource.pool.maximum.size");
        if (maximumSizeParm != null && maximumSizeParm.length() > 0) {
            try {
                this.maximum_pool_size = Integer.parseInt(maximumSizeParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{maximumSizeParm, "pooling.resource.pool.maximum.size", "long"}));
            }
        }
        if ((minimumSizeParm = props.getProperty("pooling.resource.pool.minimum.size")) != null && minimumSizeParm.length() > 0) {
            try {
                this.minimum_pool_size = Integer.parseInt(minimumSizeParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{minimumSizeParm, "pooling.resource.pool.minimum.size", "long"}));
            }
        }
        if (this.minimum_pool_size > this.maximum_pool_size) {
            int tmp = this.maximum_pool_size;
            this.maximum_pool_size = this.minimum_pool_size;
            this.minimum_pool_size = tmp;
        }
        changes.setProperty("pooling.resource.pool.minimum.size", String.valueOf(this.minimum_pool_size));
        changes.setProperty("pooling.resource.pool.maximum.size", String.valueOf(this.maximum_pool_size));
        String liveAndUsedTimeParm = props.getProperty("pooling.resource.pool.liveandused.time");
        if (liveAndUsedTimeParm != null && liveAndUsedTimeParm.length() > 0) {
            try {
                this.liveAndUsedTime = Long.parseLong(liveAndUsedTimeParm);
                changes.setProperty("pooling.resource.pool.liveandused.time", liveAndUsedTimeParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{liveAndUsedTimeParm, "pooling.resource.pool.liveandused.time", "long"}));
            }
        }
        if ((shrinkPeriodParm = props.getProperty("pooling.resource.pool.shrink.period")) != null && shrinkPeriodParm.length() > 0) {
            try {
                this.shrinkPeriod = Long.parseLong(shrinkPeriodParm);
                this.cleanerThread.setSleepTime(this.shrinkPeriod);
                changes.setProperty("pooling.resource.pool.shrink.period", shrinkPeriodParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{shrinkPeriodParm, "pooling.resource.pool.shrink.period", "long"}));
            }
        }
        if ((allowShrinkParm = props.getProperty("pooling.resource.pool.allow.shrinking")) != null && allowShrinkParm.length() > 0) {
            try {
                this.allowsShrinking = Boolean.valueOf(allowShrinkParm);
                changes.setProperty("pooling.resource.pool.allow.shrinking", allowShrinkParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{allowShrinkParm, "pooling.resource.pool.allow.shrinking", "boolean"}));
            }
        }
        if ((shrinkIncrementParm = props.getProperty("pooling.resource.pool.shrink.increment")) != null && shrinkIncrementParm.length() > 0) {
            try {
                this.shrinkIncrement = Integer.parseInt(shrinkIncrementParm);
                changes.setProperty("pooling.resource.pool.shrink.increment", shrinkIncrementParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{shrinkIncrementParm, "pooling.resource.pool.shrink.increment", "integer"}));
            }
        }
        if ((waitTimeParm = props.getProperty("pooling.resource.pool.wait.time")) != null && waitTimeParm.length() > 0) {
            try {
                this.waitForResourceTime = Long.parseLong(waitTimeParm);
                changes.setProperty("pooling.resource.pool.wait.time", waitTimeParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{waitTimeParm, "pooling.resource.pool.wait.time", "long"}));
            }
        }
        if ((concurrentUsersValue = props.getProperty("pooling.resource.pool.concurrent.users")) != null && concurrentUsersValue.length() > 0) {
            try {
                this.num_concurrent_users_allowed = Integer.parseInt(concurrentUsersValue);
                changes.setProperty("pooling.resource.pool.concurrent.users", concurrentUsersValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{concurrentUsersValue, "pooling.resource.pool.concurrent.users", "integer"}));
            }
        }
        if ((extendModeParm = props.getProperty("pooling.resource.extend.maximum.pool.size.mode")) != null && extendModeParm.length() > 0) {
            try {
                this.extendMode = new Boolean(extendModeParm);
                changes.setProperty("pooling.resource.extend.maximum.pool.size.mode", extendModeParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{extendModeParm, "pooling.resource.extend.maximum.pool.size.mode", "boolean"}));
            }
        }
        if ((extendPercentParm = props.getProperty("pooling.resource.extend.maximum.pool.size.percent")) != null && extendPercentParm.length() > 0) {
            try {
                this.extendPercent = Double.parseDouble(extendPercentParm);
                changes.setProperty("pooling.resource.extend.maximum.pool.size.percent", extendPercentParm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{extendPercentParm, "pooling.resource.extend.maximum.pool.size.percent", "long"}));
            }
        }
        this.extend_maximum_pool_size = new Double((double)this.maximum_pool_size * this.extendPercent).intValue() + this.maximum_pool_size;
        return changes;
    }

    protected void finalize() {
        this.shutDown();
    }

    protected Resource checkResourceCache() {
        return null;
    }

    private final void initProperties() throws ResourcePoolException {
        Properties descriptorProperties = this.resourceDescriptor.getProperties();
        String resourceAdapterClassName = descriptorProperties.getProperty("pooling.resource.adapter.class.name");
        try {
            this.resourceAdapter = (ResourceAdapter)PoolingUtil.create(resourceAdapterClassName, null);
        }
        catch (ClassCastException e) {
            throw new ResourcePoolException(e, "ERR.003.002.0038", CommonPlugin.Util.getString("ERR.003.002.0038", new Object[]{resourceAdapterClassName, (class$com$metamatrix$common$pooling$api$ResourceAdapter == null ? (class$com$metamatrix$common$pooling$api$ResourceAdapter = BasicResourcePool.class$("com.metamatrix.common.pooling.api.ResourceAdapter")) : class$com$metamatrix$common$pooling$api$ResourceAdapter).getName()}));
        }
        this.setupPoolProperties(descriptorProperties);
    }

    private void setupPoolProperties(Properties descriptorProperties) {
        this.properties = PropertiesUtils.clone(descriptorProperties, false);
        String maximumSizeParm = this.properties.getProperty("pooling.resource.pool.maximum.size");
        if (maximumSizeParm == null) {
            maximumSizeParm = "5";
        }
        try {
            this.maximum_pool_size = Integer.parseInt(maximumSizeParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{maximumSizeParm, "pooling.resource.pool.maximum.size", "long"}));
        }
        String minimumSizeParm = this.properties.getProperty("pooling.resource.pool.minimum.size");
        if (minimumSizeParm == null) {
            minimumSizeParm = "1";
        }
        try {
            this.minimum_pool_size = Integer.parseInt(minimumSizeParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{minimumSizeParm, "pooling.resource.pool.minimum.size", "long"}));
        }
        if (this.minimum_pool_size > this.maximum_pool_size) {
            this.maximum_pool_size = this.minimum_pool_size;
        }
        this.properties.setProperty("pooling.resource.pool.minimum.size", minimumSizeParm);
        this.properties.setProperty("pooling.resource.pool.maximum.size", String.valueOf(this.maximum_pool_size));
        String liveAndUsedTimeParm = this.properties.getProperty("pooling.resource.pool.liveandused.time");
        if (liveAndUsedTimeParm == null) {
            liveAndUsedTimeParm = "600000";
        }
        try {
            this.liveAndUsedTime = Long.parseLong(liveAndUsedTimeParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{liveAndUsedTimeParm, "pooling.resource.pool.liveandused.time", "long"}));
        }
        this.properties.setProperty("pooling.resource.pool.liveandused.time", liveAndUsedTimeParm);
        String shrinkPeriodParm = this.properties.getProperty("pooling.resource.pool.shrink.period");
        if (shrinkPeriodParm == null) {
            shrinkPeriodParm = "300000";
        }
        try {
            this.shrinkPeriod = Long.parseLong(shrinkPeriodParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{shrinkPeriodParm, "pooling.resource.pool.shrink.period", "long"}));
        }
        this.properties.setProperty("pooling.resource.pool.shrink.period", shrinkPeriodParm);
        String allowShrinkParm = this.properties.getProperty("pooling.resource.pool.allow.shrinking");
        if (allowShrinkParm == null) {
            allowShrinkParm = "true";
        }
        try {
            this.allowsShrinking = Boolean.valueOf(allowShrinkParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{allowShrinkParm, "pooling.resource.pool.allow.shrinking", "boolean"}));
        }
        this.properties.setProperty("pooling.resource.pool.allow.shrinking", allowShrinkParm);
        String shrinkIncrementParm = this.properties.getProperty("pooling.resource.pool.shrink.increment");
        if (shrinkIncrementParm == null) {
            shrinkIncrementParm = "0";
        }
        try {
            this.shrinkIncrement = Integer.parseInt(shrinkIncrementParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{shrinkIncrementParm, "pooling.resource.pool.shrink.increment", "integer"}));
        }
        this.properties.setProperty("pooling.resource.pool.shrink.increment", shrinkIncrementParm);
        String waitTimeParm = this.properties.getProperty("pooling.resource.pool.wait.time");
        if (waitTimeParm == null) {
            waitTimeParm = "30000";
        }
        try {
            this.waitForResourceTime = Long.parseLong(waitTimeParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{waitTimeParm, "pooling.resource.pool.wait.time", "long"}));
        }
        this.properties.setProperty("pooling.resource.pool.wait.time", waitTimeParm);
        String concurrentUsersValue = this.properties.getProperty("pooling.resource.pool.concurrent.users");
        if (concurrentUsersValue == null) {
            concurrentUsersValue = "1";
        }
        try {
            this.num_concurrent_users_allowed = Integer.parseInt(concurrentUsersValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{concurrentUsersValue, "pooling.resource.pool.concurrent.users", "integer"}));
        }
        this.properties.setProperty("pooling.resource.pool.concurrent.users", concurrentUsersValue);
        String extendModeParm = this.properties.getProperty("pooling.resource.extend.maximum.pool.size.mode");
        if (extendModeParm == null) {
            extendModeParm = "false";
        }
        try {
            this.extendMode = new Boolean(extendModeParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{extendModeParm, "pooling.resource.extend.maximum.pool.size.mode", "boolean"}));
        }
        this.properties.setProperty("pooling.resource.extend.maximum.pool.size.mode", extendModeParm);
        String extendPercentParm = this.properties.getProperty("pooling.resource.extend.maximum.pool.size.percent");
        if (extendPercentParm == null) {
            extendPercentParm = "1.000";
        }
        try {
            this.extendPercent = Double.parseDouble(extendPercentParm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.002.0019", new Object[]{extendPercentParm, "pooling.resource.extend.maximum.pool.size.percent", "long"}));
        }
        this.properties.setProperty("pooling.resource.extend.maximum.pool.size.percent", extendPercentParm);
        this.extend_maximum_pool_size = new Double((double)this.maximum_pool_size * this.extendPercent).intValue() + this.maximum_pool_size;
    }

    private void initStatistics() {
        this.poolStatistics = new BasicResourcePoolStatistics(this);
        BasicPoolStatistic ps = null;
        ps = new CounterStat("resourcesRequested", ResourcePoolStatisticNames.getDisplayName("resourcesRequested"), ResourcePoolStatisticNames.getDescription("resourcesRequested"), 2);
        this.poolStatistics.addStatistic(ps);
        ps = new CounterStat("successfulRequests", ResourcePoolStatisticNames.getDisplayName("successfulRequests"), ResourcePoolStatisticNames.getDescription("successfulRequests"), 2);
        this.poolStatistics.addStatistic(ps);
        ps = new CounterStat("unsuccessfulRequests", ResourcePoolStatisticNames.getDisplayName("unsuccessfulRequests"), ResourcePoolStatisticNames.getDescription("unsuccessfulRequests"), 2);
        this.poolStatistics.addStatistic(ps);
        ps = new CounterStat("totalPhysicalResourcesUsed", ResourcePoolStatisticNames.getDisplayName("totalPhysicalResourcesUsed"), ResourcePoolStatisticNames.getDescription("totalPhysicalResourcesUsed"), 2);
        this.poolStatistics.addStatistic(ps);
        ps = new CounterStat("numOfTimeouts", ResourcePoolStatisticNames.getDisplayName("numOfTimeouts"), ResourcePoolStatisticNames.getDescription("numOfTimeouts"), 2);
        this.poolStatistics.addStatistic(ps);
        ps = new HighestValueStat("maxNumInPool", ResourcePoolStatisticNames.getDisplayName("maxNumInPool"), ResourcePoolStatisticNames.getDescription("maxNumInPool"), 4);
        this.poolStatistics.addStatistic(ps);
        ps = new CounterStat("numInPool", ResourcePoolStatisticNames.getDisplayName("numInPool"), ResourcePoolStatisticNames.getDescription("numInPool"), 4);
        this.poolStatistics.addStatistic(ps);
    }

    protected void initResources() throws ResourcePoolException {
        if (this.minimum_pool_size == 0) {
            return;
        }
        for (int i = 0; i < this.minimum_pool_size; ++i) {
            this.createResourceContainer();
        }
    }

    public Resource checkOut(String userName) throws ResourcePoolException {
        if (this.shutdownRequested) {
            throw new ResourcePoolException("ERR.003.002.0026", CommonPlugin.Util.getString("ERR.003.002.0026", new Object[]{userName}));
        }
        LogManager.logTrace(CONTEXT, "Perform Checkout Resource " + this.resourceDescriptor.getName());
        this.poolStatistics.increment("resourcesRequested");
        ResourceContainer container = null;
        long startTime = System.currentTimeMillis();
        long timeWaited = 0L;
        int poolSize = 0;
        while (timeWaited < this.waitForResourceTime) {
            block25: {
                try {
                    this.lock.writeLock().acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    poolSize = this.getResourcePoolSize();
                    Iterator iter = this.resourcePool.iterator();
                    while (iter.hasNext()) {
                        Resource resource;
                        container = (ResourceContainer)iter.next();
                        if (!container.hasAvailableResource()) continue;
                        Resource resource2 = resource = this.checkOutFromPool(container, userName);
                        return resource2;
                    }
                    if (poolSize >= this.maximum_pool_size) break block25;
                    try {
                        container = this.createResourceContainer();
                        if (container != null) {
                            Resource resource;
                            Resource resource3 = resource = this.checkOutFromPool(container, userName);
                            return resource3;
                        }
                    }
                    catch (ResourcePoolException rpe) {
                        I18nLogManager.logCritical(CONTEXT, "ERR.003.002.0027", (Throwable)((Object)rpe), new Object[]{this.resourceDescriptor.getName(), userName});
                    }
                }
                catch (ResourcePoolException e) {
                    I18nLogManager.logCritical(CONTEXT, "ERR.003.002.0028", (Throwable)((Object)e), new Object[]{this.resourceDescriptor.getName(), userName});
                    this.poolStatistics.increment("unsuccessfulRequests");
                    throw e;
                }
                finally {
                    this.lock.writeLock().release();
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            timeWaited = System.currentTimeMillis() - startTime;
        }
        this.poolStatistics.increment("numOfTimeouts");
        if (this.extendMode && poolSize > 0 && poolSize < this.extend_maximum_pool_size) {
            LogManager.logDetail(CONTEXT, "Extended Mode create new Resource " + this.resourceDescriptor.getName());
            try {
                this.lock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                Resource resource;
                container = this.createResourceContainer();
                Resource resource4 = resource = this.checkOutFromPool(container, userName);
                return resource4;
            }
            catch (ResourcePoolException e) {
                I18nLogManager.logCritical(CONTEXT, "ERR.003.002.0029", (Throwable)((Object)e), new Object[]{this.resourceDescriptor.getName(), userName});
                this.poolStatistics.increment("unsuccessfulRequests");
                throw e;
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        this.poolStatistics.increment("unsuccessfulRequests");
        I18nLogManager.logCritical(CONTEXT, "ERR.003.002.0030", new Object[]{this.resourceDescriptor.getName(), userName, Long.toString(this.waitForResourceTime)});
        throw new ResourceWaitTimeOutException(CommonPlugin.Util.getString("ERR.003.002.0030", new Object[]{this.resourceDescriptor.getName(), userName, Long.toString(this.waitForResourceTime)}));
    }

    private Resource checkOutFromPool(ResourceContainer container, String userName) throws ResourcePoolException {
        Resource r = container.checkOut(userName);
        this.resourcePool.remove(container);
        this.inuseResourcePool.add(container);
        this.poolStatistics.increment("successfulRequests");
        return r;
    }

    private ResourceContainer createResourceContainer() throws ResourcePoolException {
        LogManager.logDetail(CONTEXT, "Creating New Resource in pool " + this.resourceDescriptor.getName());
        Object resource = this.resourceAdapter.createPhysicalResourceObject(this.resourceDescriptor);
        BasicResourceContainer container = new BasicResourceContainer(++this.containerCounter);
        container.init(this, resource, this.num_concurrent_users_allowed);
        this.resourcePool.add(container);
        this.poolStatistics.increment("totalPhysicalResourcesUsed");
        this.poolStatistics.increment("numInPool");
        this.poolStatistics.increment("maxNumInPool", this.getResourcePoolSize());
        LogManager.logTrace(CONTEXT, "Created Resource " + this.resourceDescriptor.getName() + " Max Pool Size " + this.maximum_pool_size + "  Pool Size: " + this.resourcePool.size());
        return container;
    }

    public void checkIn(ResourceContainer resourceContainer, String userName) throws ResourcePoolException {
        try {
            this.lock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.inuseResourcePool.remove(resourceContainer);
        this.resourcePool.add(resourceContainer);
        this.lock.writeLock().release();
        LogManager.logTrace(CONTEXT, "Checkin Resource " + this.getResourceDescriptor().getName() + " for user " + userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        ArrayList<ResourceContainer> connectionsToBeClosed;
        block15: {
            connectionsToBeClosed = null;
            Iterator iter = null;
            ResourceContainer container = null;
            try {
                this.lock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                if (this.shutdownRequested) {
                    connectionsToBeClosed = new ArrayList<ResourceContainer>(this.resourcePool.size());
                    iter = this.resourcePool.iterator();
                    while (iter.hasNext()) {
                        container = (ResourceContainer)iter.next();
                        iter.remove();
                        connectionsToBeClosed.add(container);
                    }
                    break block15;
                }
                long unusedPeriod = System.currentTimeMillis() + this.liveAndUsedTime;
                ResourceStatistics stats = null;
                int shrinkCnt = 0;
                int poolSize = this.resourcePool.size();
                connectionsToBeClosed = new ArrayList(poolSize);
                iter = this.resourcePool.iterator();
                while (iter.hasNext()) {
                    container = (ResourceContainer)iter.next();
                    boolean isAlive = false;
                    try {
                        isAlive = container.isAlive();
                    }
                    catch (ResourcePoolException rpe) {
                        // empty catch block
                    }
                    if (isAlive) continue;
                    connectionsToBeClosed.add(container);
                    iter.remove();
                    I18nLogManager.logCritical(CONTEXT, "ERR.003.002.0033", this.resourceDescriptor.getName());
                    ++shrinkCnt;
                }
                if (!this.allowsShrinking || poolSize - shrinkCnt <= this.minimum_pool_size && shrinkCnt >= this.shrinkIncrement) break block15;
                iter = this.resourcePool.iterator();
                while (iter.hasNext()) {
                    container = (ResourceContainer)iter.next();
                    stats = container.getStats();
                    if (poolSize - shrinkCnt <= this.minimum_pool_size) {
                        break;
                    }
                    if (stats.getLastUsed() >= unusedPeriod || this.shrinkIncrement != 0 && shrinkCnt >= this.shrinkIncrement) continue;
                    connectionsToBeClosed.add(container);
                    iter.remove();
                    ++shrinkCnt;
                }
            }
            catch (Exception e) {
                I18nLogManager.logCritical(CONTEXT, "ERR.003.002.0034", (Throwable)e, new Object[]{this.resourceDescriptor.getName()});
            }
            finally {
                this.lock.writeLock().release();
            }
        }
        if (connectionsToBeClosed != null && connectionsToBeClosed.size() > 0) {
            this.closeContainers(connectionsToBeClosed);
        }
    }

    private void closeContainers(Collection containers) {
        if (containers != null) {
            Iterator it = containers.iterator();
            while (it.hasNext()) {
                ResourceContainer container = (ResourceContainer)it.next();
                this.closeContainer(container);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeContainer(ResourceContainer container) {
        ResourceContainer resourceContainer = container;
        synchronized (resourceContainer) {
            try {
                LogManager.logDetail(CONTEXT, "Shutting down resource in pool " + this.resourceDescriptor.getName());
                container.shutDown();
                this.poolStatistics.decrement("numInPool");
            }
            catch (Exception e) {
                I18nLogManager.logWarning(CONTEXT, "ERR.003.002.0034", (Throwable)e, new Object[]{this.resourceDescriptor.getName()});
            }
        }
    }

    public String toString() {
        int size = this.getResourcePoolSize();
        StringBuffer sb = new StringBuffer();
        sb.append("Resource " + this.resourceDescriptor.getName() + "\n");
        sb.append("\tCurrent Pool Size: " + size + "\n");
        sb.append("\tMin Pool Size: " + this.minimum_pool_size + "\n");
        sb.append("\tMax Pool Size: " + this.maximum_pool_size + "\n");
        sb.append("\tAllow Shrinking: " + this.allowsShrinking + "\n");
        sb.append("\tShrink Increment: " + this.shrinkIncrement + "\n");
        sb.append("\tShrink Period: " + this.shrinkPeriod + "\n");
        sb.append("\tExtend Mode: " + this.extendMode + "\n");
        sb.append("\tExtend %: " + this.extendPercent + "\n");
        sb.append("\tExtend Max Pool Size: " + this.extend_maximum_pool_size + "\n");
        sb.append("\tWait for Resource Time: " + this.waitForResourceTime + "\n");
        sb.append("\tAlive And Used Time: " + this.liveAndUsedTime + "\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

