/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.jdbc;

import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.impl.BaseResource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class JDBCConnectionResource
extends BaseResource
implements Connection {
    public static final String DRIVER = "metamatrix.common.pooling.jdbc.Driver";
    public static final String PROTOCOL = "metamatrix.common.pooling.jdbc.Protocol";
    public static final String DATABASE = "metamatrix.common.pooling.jdbc.Database";
    public static final String USERNAME = "metamatrix.common.pooling.jdbc.User";
    public static final String PASSWORD = "metamatrix.common.pooling.jdbc.Password";
    public static final String AUTOCOMMIT = "metamatrix.common.pooling.jdbc.autocommit";
    private JDBCPlatform platform;
    private Long resource_ID;
    private Connection conn;

    public JDBCConnectionResource(Connection conn, JDBCPlatform jdbcPlatform, Long id) {
        this.conn = conn;
        this.platform = jdbcPlatform;
        this.resource_ID = id;
    }

    public JDBCPlatform getPlatform() {
        return this.platform;
    }

    public Long getResourceID() {
        return this.resource_ID;
    }

    public boolean validate() {
        try {
            this.conn.getMetaData();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void close() throws SQLException {
        try {
            this.closeResource();
        }
        catch (ResourcePoolException rpe) {
            throw new SQLException(rpe.getFullMessage());
        }
    }

    protected Connection getConnection() {
        return this.conn;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.conn.prepareCall(sql);
    }

    protected void performInit() throws ResourcePoolException {
    }

    protected boolean checkIsResourceAlive() {
        boolean result = true;
        try {
            if (this.platform.isClosed(this.conn)) {
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        try {
            this.conn.commit();
        }
        catch (Throwable sqle) {
            sqle.printStackTrace();
            return false;
        }
        return result;
    }

    public void setHoldability(int holdability) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 0;
    }

    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }
}

