/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.util;

import com.metamatrix.common.pooling.api.ResourcePoolPropertyNames;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ReflectionHelper;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class PoolingUtil {
    public static final Object create(String className, Collection ctorObjs) throws ResourcePoolException {
        try {
            return ReflectionHelper.create((String)className, (Collection)ctorObjs);
        }
        catch (MetaMatrixCoreException e) {
            throw new ResourcePoolException(e);
        }
    }

    public static Properties mapProperties(Properties propertyNames, Properties properties) {
        Properties props = new Properties();
        if (properties == null || properties.isEmpty()) {
            return props;
        }
        Enumeration<?> enumeration = propertyNames.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String mapName = propertyNames.getProperty(name);
            PoolingUtil.addProperty(properties, name, props, mapName);
        }
        return props;
    }

    protected static void addProperty(Properties source, String sourceName, Properties props, String propName) {
        String value = source.getProperty(sourceName);
        if (value != null) {
            props.setProperty(propName, value);
        }
    }

    public static Properties obtainResourcePoolProperties(Properties sourceProperties) {
        Properties resourcePoolProperties = new Properties();
        Collection poolPropNames = ResourcePoolPropertyNames.getNames();
        Iterator it = poolPropNames.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = sourceProperties.getProperty(name);
            if (value == null || value.length() <= 0) continue;
            resourcePoolProperties.setProperty(name, value);
        }
        return resourcePoolProperties;
    }
}

