/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.basic;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.Multiplicity;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.util.exception.AssertionException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.Assertion;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class BasicTreeNode
implements TreeNode,
Serializable {
    public static final char DELIMITER_CHAR = '.';
    public static final String DELIMITER = ".";
    private ObjectID globalUID;
    private ObjectDefinition type;
    private boolean exists = true;
    private String name;
    private List children;
    private List unmodifiableChildren;
    private BasicTreeNode parent;
    private boolean marked;
    private boolean modified;
    private Map properties;

    public BasicTreeNode(BasicTreeNode parent, String name, ObjectDefinition defn, ObjectID guid) {
        Assertion.isNotNull((Object)defn, (String)"The ObjectDefinition reference may not be null");
        Assertion.isNotNull((Object)guid, (String)"The ObjectID reference may not be null");
        this.type = defn;
        this.globalUID = guid;
        this.children = new ArrayList(5);
        this.unmodifiableChildren = Collections.unmodifiableList(this.children);
        this.properties = new HashMap();
        this.setNameOfNode(name);
        this.modified = true;
        if (parent != null) {
            parent.addChild(this, defn, -1);
            this.setExists(true);
        } else {
            this.ensureNameIsValid();
            this.setExists(true);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.addFullName(new StringBuffer(), DELIMITER).toString();
    }

    public String getFullName(String delimiter) {
        return this.addFullName(new StringBuffer(), delimiter).toString();
    }

    protected StringBuffer addFullName(StringBuffer sb, String delimiter) {
        if (delimiter == null || delimiter.length() == 0) {
            delimiter = DELIMITER;
        }
        StringBuffer result = sb;
        if (this.parent != null) {
            result = this.parent.addFullName(result, delimiter);
            result.append(delimiter);
        }
        result.append(this.name);
        return result;
    }

    public String getNamespace() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getFullName();
    }

    public ObjectDefinition getType() {
        return this.type;
    }

    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean value) {
        if (this.exists != value) {
            this.exists = value;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                BasicTreeNode child = (BasicTreeNode)iter.next();
                child.setExists(value);
            }
        }
    }

    public char getSeparatorChar() {
        return '.';
    }

    public String getSeparator() {
        return DELIMITER;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicTreeNode) {
            BasicTreeNode that = (BasicTreeNode)obj;
            return this.globalUID.equals(that.getGlobalUID());
        }
        return false;
    }

    public int compareTo(Object obj) {
        BasicTreeNode that = (BasicTreeNode)obj;
        Assertion.isNotNull((Object)obj, (String)"Attempt to compare null");
        if (obj == this) {
            return 0;
        }
        return this.globalUID.compareTo((Object)that.getGlobalUID());
    }

    public String toString() {
        return this.getName();
    }

    public ObjectID getGlobalUID() {
        return this.globalUID;
    }

    protected void setGlobalUID(ObjectID newID) {
        if (newID != null) {
            this.globalUID = newID;
        }
    }

    public Iterator iterator() {
        return this.unmodifiableChildren.iterator();
    }

    public List getChildren(String name, boolean ignoreCase) {
        Assertion.isNotNull((Object)name, (String)"The name reference may not be null");
        Assertion.isNotZeroLength((String)name, (String)"The name reference may not be zero-length");
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        Iterator iter = this.children.iterator();
        if (ignoreCase) {
            while (iter.hasNext()) {
                TreeNode obj = (TreeNode)iter.next();
                if (!obj.getName().equalsIgnoreCase(name)) continue;
                result.add(obj);
            }
        } else {
            while (iter.hasNext()) {
                TreeNode obj = (TreeNode)iter.next();
                if (!obj.getName().equals(name)) continue;
                result.add(obj);
            }
        }
        return result;
    }

    public TreeNode getChild(String name, ObjectDefinition defn, boolean ignoreCase) {
        Assertion.isNotNull((Object)name, (String)"The name reference may not be null");
        Assertion.isNotZeroLength((String)name, (String)"The name reference may not be zero-length");
        Assertion.isNotNull((Object)defn, (String)"The ObjectDefinition reference may not be null");
        Iterator iter = this.children.iterator();
        if (ignoreCase) {
            while (iter.hasNext()) {
                TreeNode obj = (TreeNode)iter.next();
                if (!((Object)defn).equals(obj.getType()) || !obj.getName().equalsIgnoreCase(name)) continue;
                return obj;
            }
        } else {
            while (iter.hasNext()) {
                TreeNode obj = (TreeNode)iter.next();
                if (!((Object)defn).equals(obj.getType()) || !obj.getName().equals(name)) continue;
                return obj;
            }
        }
        return null;
    }

    public int getIndexOfChild(TreeNode child) {
        BasicTreeNode nodesParent = this.assertBasicTreeNode((TreeNode)child).parent;
        Assertion.assertTrue((this == nodesParent ? 1 : 0) != 0, (String)"The referenced child is not contained in this entity");
        Iterator iter = this.children.iterator();
        int index = 0;
        while (iter.hasNext()) {
            if (iter.next() == child) {
                return index;
            }
            ++index;
        }
        throw new AssertionException("ERR.003.028.0022", CommonPlugin.Util.getString("ERR.003.028.0022"));
    }

    public List getChildren() {
        return this.unmodifiableChildren;
    }

    public boolean hasChildren() {
        return this.unmodifiableChildren.size() != 0;
    }

    public int getChildCount() {
        return this.unmodifiableChildren.size();
    }

    public boolean containsChildWithName(String name) {
        Assertion.isNotNull((Object)name, (String)"The name reference may not be null");
        if (name.length() == 0) {
            return false;
        }
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            BasicTreeNode child = (BasicTreeNode)iter.next();
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setName(String newName) {
        this.setNameOfNode(newName);
        this.ensureNameIsValid();
    }

    protected void setNameOfNode(String newName) {
        this.name = newName;
        PropertyDefinition nameDefn = this.getNamePropertyDefinition();
        if (nameDefn != null) {
            this.setPropertyValue(nameDefn, newName);
        }
    }

    protected BasicTreeNode assertBasicTreeNode(TreeNode obj) {
        Assertion.isNotNull((Object)obj, (String)"The TreeNode reference may not be null");
        Assertion.assertTrue((boolean)(obj instanceof BasicTreeNode), (String)"The referenced object is not an BasicTreeNode");
        return (BasicTreeNode)obj;
    }

    public BasicTreeNode getParent() {
        return this.parent;
    }

    public boolean isParentOf(TreeNode node) {
        BasicTreeNode nodesParent = this.assertBasicTreeNode((TreeNode)node).parent;
        return this == nodesParent;
    }

    public boolean isAncestorOf(TreeNode node) {
        BasicTreeNode ancestor = this.assertBasicTreeNode((TreeNode)node).parent;
        while (ancestor != null) {
            if (this == ancestor) {
                return true;
            }
            ancestor = this.assertBasicTreeNode((TreeNode)ancestor).parent;
        }
        return false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.setModified(modified, true);
    }

    public synchronized void setModified(boolean modified, boolean recursive) {
        this.modified = modified;
        if (recursive) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                BasicTreeNode child = (BasicTreeNode)iter.next();
                child.setModified(modified, true);
            }
        }
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.setMarked(marked, true);
    }

    public synchronized void setMarked(boolean marked, boolean recursive) {
        this.marked = marked;
        if (recursive) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                BasicTreeNode child = (BasicTreeNode)iter.next();
                child.setMarked(marked, true);
            }
        }
    }

    protected synchronized void addMarkedNodesToSet(Set result) {
        if (this.isMarked()) {
            result.add(this);
        }
        BasicTreeNode child = null;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            child = (BasicTreeNode)iter.next();
            child.addMarkedNodesToSet(result);
        }
    }

    public synchronized void findLeafNodes(Set leafNodes) {
        if (this.getChildCount() == 0) {
            leafNodes.add(this);
            return;
        }
        BasicTreeNode child = null;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            child = (BasicTreeNode)iter.next();
            child.findLeafNodes(leafNodes);
        }
    }

    public synchronized boolean findMarkedAndUnmarkedNodes(Set unmarkedNodes, Set markedLeafNodes) {
        if (this.isMarked()) {
            this.findLeafNodes(markedLeafNodes);
            return true;
        }
        unmarkedNodes.add(this);
        boolean childHasMarkedNodes = false;
        BasicTreeNode child = null;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            child = (BasicTreeNode)iter.next();
            if (!child.findMarkedAndUnmarkedNodes(unmarkedNodes, markedLeafNodes)) continue;
            childHasMarkedNodes = true;
        }
        if (childHasMarkedNodes) {
            unmarkedNodes.remove(this);
        }
        return childHasMarkedNodes;
    }

    public synchronized void findTopLevelMarkedNodes(Set markedTopLevelNodes) {
        if (this.isMarked()) {
            markedTopLevelNodes.add(this);
        }
        BasicTreeNode child = null;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            child = (BasicTreeNode)iter.next();
            child.findTopLevelMarkedNodes(markedTopLevelNodes);
        }
    }

    public Collection getDecendant(String pathWithName, String delimiter, boolean ignoreCase) {
        if (delimiter == null || delimiter.length() == 0) {
            delimiter = DELIMITER;
        }
        HashSet<BasicTreeNode> parents = new HashSet<BasicTreeNode>();
        HashSet decendents = new HashSet();
        parents.add(this);
        BasicTreeNode parent = this;
        StringTokenizer tokenizer = new StringTokenizer(pathWithName, delimiter);
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            decendents.clear();
            Iterator iter = parents.iterator();
            while (iter.hasNext()) {
                parent = (BasicTreeNode)iter.next();
                decendents.addAll(parent.getChildren(name, ignoreCase));
            }
            parents.clear();
            parents.addAll(decendents);
        }
        return decendents;
    }

    public Collection getDecendant(String pathWithName, boolean ignoreCase) {
        return this.getDecendant(pathWithName, DELIMITER, ignoreCase);
    }

    public synchronized void remove(BasicTreeNode child) {
        Assertion.assertTrue((child != this ? 1 : 0) != 0, (String)"The specified node may not be removed from itself");
        Assertion.isNotNull((Object)child, (String)"Unable to remove a null child reference");
        boolean found = this.children.remove(child);
        Assertion.assertTrue((boolean)found, (String)"The specified child was not found within this node");
        child.parent = null;
        child.setExists(false);
    }

    public synchronized void removeAll() {
        Iterator iter = this.children.iterator();
        BasicTreeNode child = null;
        while (iter.hasNext()) {
            child = (BasicTreeNode)iter.next();
            child.parent = null;
            child.setExists(false);
            iter.remove();
        }
    }

    public synchronized void remove(int index) {
        BasicTreeNode child = (BasicTreeNode)this.children.remove(index);
        child.parent = null;
        child.setExists(false);
    }

    public synchronized void moveChild(BasicTreeNode child, int newIndex) {
        Assertion.assertTrue((child != this ? 1 : 0) != 0, (String)"The specified node may not be removed from itself");
        Assertion.isNotNull((Object)child, (String)"Unable to remove a null child reference");
        int currentIndex = this.children.indexOf(child);
        if (currentIndex == newIndex) {
            return;
        }
        boolean found = this.children.remove(child);
        Assertion.assertTrue((boolean)found, (String)"The specified child was not found within this node");
        int correctIndex = newIndex;
        if (currentIndex < newIndex) {
            --correctIndex;
        }
        this.children.add(correctIndex, child);
    }

    public synchronized void insert(BasicTreeNode child, int index) {
        Assertion.isNotNull((Object)child, (String)"The child reference may not be null");
        Assertion.assertTrue((child != this ? 1 : 0) != 0, (String)"The specified node may not be added to itself");
        Assertion.assertTrue((child.getParent() != this ? 1 : 0) != 0, (String)"The specified node is already a child of this entity");
        this.children.add(index, child);
        if (child.parent != null) {
            child.parent.children.remove(child);
        }
        child.parent = this;
        child.setExists(true);
        this.ensureNameIsValid();
    }

    public synchronized void add(BasicTreeNode child) {
        Assertion.isNotNull((Object)child, (String)"The child reference may not be null");
        Assertion.assertTrue((child != this ? 1 : 0) != 0, (String)"The specified node may not be added to itself");
        Assertion.assertTrue((child.getParent() != this ? 1 : 0) != 0, (String)"The specified node is already a child of this entity");
        this.addChild(child, child.getType(), -1);
    }

    public synchronized void add(BasicTreeNode child, int index) {
        Assertion.isNotNull((Object)child, (String)"The child reference may not be null");
        Assertion.assertTrue((child != this ? 1 : 0) != 0, (String)"The specified node may not be added to itself");
        Assertion.assertTrue((child.getParent() != this ? 1 : 0) != 0, (String)"The specified node is already a child of this entity");
        this.addChild(child, child.getType(), index);
    }

    protected synchronized void addChild(BasicTreeNode child, ObjectDefinition childType, int index) {
        if (this.addChildIsValid(child)) {
            if (index == -1) {
                this.children.add(child);
            } else {
                this.children.add(index, child);
            }
            if (child.parent != null) {
                child.parent.children.remove(child);
            }
            child.parent = this;
            child.setExists(true);
            child.ensureNameIsValid();
        }
    }

    public Object getPropertyValue(PropertyDefinition propertyDefn) {
        Object[] result = this.resolveTypeFromString(this.properties.get(propertyDefn), propertyDefn);
        if (result == null && propertyDefn.hasDefaultValue()) {
            result = propertyDefn.getDefaultValue();
        }
        if (result == null) {
            return result;
        }
        if (result instanceof Collection && propertyDefn.getPropertyType() != PropertyType.LIST) {
            throw new AssertionException("The property value is a Collection but the PropertyType is a " + propertyDefn.getPropertyType().getDisplayName());
        }
        if (result instanceof Set && propertyDefn.getPropertyType() != PropertyType.SET) {
            throw new AssertionException("The property value is a Set but the PropertyType is a " + propertyDefn.getPropertyType().getDisplayName());
        }
        if (propertyDefn.getMultiplicity().getMaximum() > 1 && !(result instanceof Object[])) {
            result = new Object[]{result};
        }
        return result;
    }

    public Object setPropertyValue(PropertyDefinition propertyDefn, Object value) {
        Object previous = this.properties.put(propertyDefn, this.convertTypeToString(value, propertyDefn));
        if (previous != null && !previous.equals(value) || value != null && !value.equals(previous)) {
            this.setModified(true, false);
        }
        return previous;
    }

    protected Object resolveTypeFromString(Object value, PropertyDefinition def) {
        Object result = value;
        if (PropertyType.BOOLEAN.equals(def.getPropertyType()) && value instanceof String) {
            result = Boolean.TRUE.toString().equalsIgnoreCase((String)value) ? Boolean.TRUE : Boolean.FALSE;
        }
        return result;
    }

    protected Object convertTypeToString(Object value, PropertyDefinition def) {
        Object result = value;
        if (PropertyType.BOOLEAN.equals(def.getPropertyType())) {
            if (value instanceof Boolean) {
                result = value.toString();
            }
        } else if (PropertyType.MULTIPLICITY.equals(def.getPropertyType()) && value instanceof Multiplicity) {
            result = value.toString();
        }
        return result;
    }

    public Object removePropertyValue(PropertyDefinition propertyDefn) {
        return this.properties.remove(propertyDefn);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void print(PrintStream stream) {
        Assertion.isNotNull((Object)stream, (String)"The stream reference may not be null");
        this.printInfo(stream);
        BasicTreeNode child = null;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            child = (BasicTreeNode)iter.next();
            child.printInfo(stream);
        }
    }

    protected String getEntityForm() {
        return "BasicTreeNode";
    }

    protected void printInfo(PrintStream stream) {
        stream.println("                   \"" + this.getFullName() + "\" <" + this.getEntityForm() + "> (Type=" + this.getType() + ")");
    }

    protected TreeNode find(ObjectID globalUID) {
        Assertion.isNotNull((Object)globalUID, (String)"The ObjectID reference may not be null");
        if (this.globalUID.equals(globalUID)) {
            return this;
        }
        TreeNode result = null;
        BasicTreeNode child = null;
        Iterator iter = this.iterator();
        while (iter.hasNext() && (result = (child = (BasicTreeNode)iter.next()).find(globalUID)) == null) {
        }
        return result;
    }

    protected List getPropertyDefinitions() {
        return Collections.EMPTY_LIST;
    }

    protected PropertyDefinition getNamePropertyDefinition() {
        return null;
    }

    protected PropertyDefinition getDescriptionPropertyDefinition() {
        return null;
    }

    protected boolean areDuplicateChildNamesAllowed() {
        return true;
    }

    protected String getDefaultName() {
        return this.type.getName();
    }

    protected boolean isValidNewName(String newName) {
        if (newName == null || newName.length() == 0) {
            return false;
        }
        if (newName.equals(this.name)) {
            return true;
        }
        if (this.parent != null) {
            if (this.areDuplicateChildNamesAllowed()) {
                return true;
            }
            if (this.parent.containsChildWithName(newName)) {
                return false;
            }
        }
        return true;
    }

    protected boolean addChildIsValid(BasicTreeNode child) {
        return true;
    }

    protected void ensureNameIsValid() {
        if (this.name.length() == 0) {
            this.setNameOfNode(this.getDefaultName());
        }
        if (this.areDuplicateChildNamesAllowed()) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        List siblings = this.parent.getChildren();
        if (siblings.size() == 1) {
            return;
        }
        boolean rename = false;
        Iterator iter = siblings.iterator();
        BasicTreeNode sibling = null;
        while (iter.hasNext()) {
            sibling = (BasicTreeNode)iter.next();
            if (sibling == this || !sibling.getName().equals(this.name)) continue;
            rename = true;
            break;
        }
        if (!rename) {
            return;
        }
        String newName = null;
        int suffix = 1;
        while (newName == null) {
            String potentialName = this.name + suffix;
            iter = siblings.iterator();
            while (iter.hasNext()) {
                sibling = (BasicTreeNode)iter.next();
                if (sibling == this || !sibling.getName().equals(potentialName)) continue;
                potentialName = null;
                break;
            }
            if (potentialName != null) {
                newName = potentialName;
            }
            ++suffix;
        }
        this.setNameOfNode(newName);
    }
}

