/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.log;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.CommonXAPlugin;
import com.metamatrix.common.xa.log.TransactionLogMessage;
import com.metamatrix.common.xa.log.TransactionLogWriter;
import java.util.Map;
import java.util.Properties;

public final class TransactionLogManager {
    public static final String SYSTEM_TXN_STORE_TXN = "metamatrix.transaction.log.storeTXN";
    public static final String SYSTEM_TXN_STORE_MMCMD = "metamatrix.transaction.log.storeMMCMD";
    public static final String SYSTEM_TXN_STORE_SRCCMD = "metamatrix.transaction.log.storeSRCCMD";
    public static final String SYSTEM_LOG_MAX_THREADS = "metamatrix.transaction.log.maxThreads";
    public static final String SYSTEM_LOG_THREAD_TTL = "metamatrix.transaction.log.threadTTL";
    protected static final String DEFAULT_LOG_MAX_THREADS = "1";
    protected static final String DEFAULT_LOG_THREAD_TTL = "600000";
    private static TransactionLogManager INSTANCE = new TransactionLogManager();
    private boolean storeTXN;
    private boolean storeMMCMD;
    private boolean storeSRCCMD;
    private LinkedQueue queue;
    private WorkerPool workerPool;
    private boolean isInitialized = false;
    private boolean isStopped = false;
    private LogQueueWorkerFactory workerFactory = new LogQueueWorkerFactory();
    private TransactionLogWriter dbLogger;

    protected void finalize() {
        if (this.isManagerStopped()) {
            TransactionLogManager.stop();
        }
    }

    private TransactionLogManager() {
        this.queue = new LinkedQueue();
    }

    private void init() {
        Properties currentConfigProperties = new Properties();
        try {
            Properties globalProperties = CurrentConfiguration.getProperties();
            currentConfigProperties.putAll((Map<?, ?>)globalProperties);
            currentConfigProperties.putAll((Map<?, ?>)CurrentConfiguration.getResourceProperties((String)"TransactionLogging"));
        }
        catch (ConfigurationException e) {
            LogManager.logWarning((String)"TXN_LOG", (Throwable)e, (String)CommonXAPlugin.Util.getString("ERR.003.001.0027"));
            currentConfigProperties.putAll((Map<?, ?>)System.getProperties());
        }
        String propvalue = currentConfigProperties.getProperty(SYSTEM_TXN_STORE_TXN);
        if (propvalue != null) {
            this.storeTXN = Boolean.valueOf(propvalue);
        }
        if ((propvalue = currentConfigProperties.getProperty(SYSTEM_TXN_STORE_MMCMD)) != null) {
            this.storeMMCMD = Boolean.valueOf(propvalue);
        }
        if ((propvalue = currentConfigProperties.getProperty(SYSTEM_TXN_STORE_SRCCMD)) != null) {
            this.storeSRCCMD = Boolean.valueOf(propvalue);
        }
        if (!(this.storeTXN || this.storeMMCMD || this.storeSRCCMD)) {
            this.isInitialized = true;
            return;
        }
        this.initializeLogWriter(currentConfigProperties);
        this.initializeQueueWorkers();
        this.isInitialized = true;
    }

    private void initializeLogWriter(Properties systemProps) {
        this.dbLogger = new TransactionLogWriter();
        try {
            this.dbLogger.initialize(systemProps);
            LogManager.logInfo((String)"TXN_LOG", (String)CommonXAPlugin.Util.getString("MSG.003.001.0003"));
        }
        catch (Exception e) {
            LogManager.logInfo((String)"TXN_LOG", (String)CommonXAPlugin.Util.getString("ERR.003.001.0028", (Object)e.getMessage()));
        }
    }

    private void initializeQueueWorkers() {
        try {
            String maxThreadsString = System.getProperty(SYSTEM_LOG_MAX_THREADS, DEFAULT_LOG_MAX_THREADS);
            String threadTTLString = System.getProperty(SYSTEM_LOG_THREAD_TTL, DEFAULT_LOG_THREAD_TTL);
            this.workerPool = new WorkerPool("TransactionLog", (Channel)this.queue, (QueueWorkerFactory)this.workerFactory, Integer.parseInt(maxThreadsString), (long)Integer.parseInt(threadTTLString));
        }
        catch (Exception e) {
            LogManager.logError((String)"TXN_LOG", (Throwable)e, (String)CommonXAPlugin.Util.getString("ERR.003.001.0029"));
        }
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    protected static synchronized TransactionLogManager getInstance() {
        if (!INSTANCE.isInitialized()) {
            INSTANCE.init();
        }
        return INSTANCE;
    }

    public static void stop() {
        TransactionLogManager manager = TransactionLogManager.getInstance();
        LogManager.logCritical((String)"TXN_LOG", (String)CommonXAPlugin.Util.getString("MSG.003.031.0006"));
        try {
            manager.workerPool.suspend();
            while (manager.workerPool.hasWork()) {
                Thread.sleep(100L);
            }
            if (manager.workerPool != null) {
                manager.workerPool.shutdown();
            }
            Thread.sleep(1000L);
            manager.dbLogger.shutdown();
        }
        catch (Exception e) {
            LogManager.logCritical((String)"TXN_LOG", (String)CommonXAPlugin.Util.getString("ERR.003.001.0031"));
        }
        manager.isStopped = manager.workerPool.isStopped();
    }

    public static boolean isStopped() {
        return TransactionLogManager.getInstance().isManagerStopped();
    }

    protected boolean isManagerStopped() {
        return this.isStopped;
    }

    private void addMessageToQueue(TransactionLogMessage msg) throws QueueSuspendedException {
        block4: {
            if (this.workerPool == null) {
                while (true) {
                    try {
                        this.queue.put((Object)msg);
                        break block4;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            this.workerPool.addWork((Object)msg);
        }
    }

    public static void log(String txnUid, short txnPoint, short status, String sessionUid, String principal, String vdbName, String vdbVersion) {
        if (!TransactionLogManager.getInstance().storeTXN) {
            return;
        }
        TransactionLogMessage logMsg = new TransactionLogMessage(txnUid, txnPoint, status, sessionUid, principal, vdbName, vdbVersion);
        try {
            TransactionLogManager.getInstance().addMessageToQueue(logMsg);
        }
        catch (Exception e) {
            LogManager.logWarning((String)"TXN_LOG", (String)e.getMessage());
        }
    }

    public static void log(String requestId, String txnUid, short cmdPoint, short status, String sessionUid, String applicationName, String principal, String vdbName, String vdbVersion, Object command, int rowCount) {
        if (!TransactionLogManager.getInstance().storeMMCMD) {
            return;
        }
        String sqlString = null;
        if (command != null) {
            sqlString = command.toString();
        }
        TransactionLogMessage logMsg = new TransactionLogMessage(requestId, txnUid, cmdPoint, status, sessionUid, applicationName, principal, vdbName, vdbVersion, sqlString, rowCount);
        try {
            TransactionLogManager.getInstance().addMessageToQueue(logMsg);
        }
        catch (Exception e) {
            LogManager.logWarning((String)"TXN_LOG", (String)e.getMessage());
        }
    }

    public static void log(String requestId, long nodeID, String subTxnUid, short status, String modelName, String cbName, short cmdPoint, String sessionUid, String principal, Object sql, int rowCount) {
        if (!TransactionLogManager.getInstance().storeSRCCMD) {
            return;
        }
        String sqlString = null;
        if (sql != null) {
            sqlString = sql.toString();
        }
        TransactionLogMessage logMsg = new TransactionLogMessage(requestId, nodeID, subTxnUid, status, modelName, cbName, cmdPoint, sessionUid, principal, sqlString, rowCount);
        try {
            TransactionLogManager.getInstance().addMessageToQueue(logMsg);
        }
        catch (Exception e) {
            LogManager.logWarning((String)"TXN_LOG", (String)e.getMessage());
        }
    }

    public static boolean isTxnLogged() {
        return TransactionLogManager.getInstance().storeTXN;
    }

    public static boolean isMMCmdLogged() {
        return TransactionLogManager.getInstance().storeMMCMD;
    }

    public static boolean isSrcCmdLogged() {
        return TransactionLogManager.getInstance().storeSRCCMD;
    }

    protected class LogQueueWorkerFactory
    implements QueueWorkerFactory {
        public QueueWorker createWorker() {
            return new LogQueueWorker();
        }
    }

    protected class LogQueueWorker
    extends QueueWorker {
        public void initialize() throws QueueWorkerException {
        }

        public void cleanup() throws QueueWorkerException {
        }

        public void process(Object o) throws QueueWorkerException {
            if (!(o instanceof TransactionLogMessage)) {
                throw new QueueWorkerException(CommonXAPlugin.Util.getString("ERR.003.001.0030", o));
            }
            TransactionLogManager.this.dbLogger.print((TransactionLogMessage)o);
        }
    }
}

