/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.license.LicenseDescriptor;
import com.metamatrix.license.LicenseManager;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.exception.InvalidLicenseException;
import com.metamatrix.license.exception.LicenseException;
import com.metamatrix.license.exception.LicenseVerificationException;
import com.metamatrix.license.exception.UnlicensedProductException;
import com.metamatrix.license.exception.UnverifiedLicenseException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.eclipse.core.runtime.Platform;

public final class AppLicenseChecker {
    static final String LICENSE_FILE = "MetaMatrixLicense.xml";
    static final String CERT_FILE = "metamatrix.cert";
    public static final Notifier DEFAULT_GUI_NOTIFIER = AppLicenseChecker.getGUINotifier();
    public static final Notifier DEFAULT_NONGUI_NOTIFIER = AppLicenseChecker.getNonGUINotifier();
    static String licenseFile = "MetaMatrixLicense.xml";
    static String certFile = "metamatrix.cert";
    private static boolean licenseLoaded = false;
    private static final LicenseManager licenseManager = new LicenseManager();
    private static Notifier notifier = DEFAULT_GUI_NOTIFIER;
    private static boolean appExitOnFailure = true;
    static /* synthetic */ Class class$com$metamatrix$license$AppLicenseChecker;

    private AppLicenseChecker() {
    }

    public static boolean isLicenseLoaded() {
        return licenseLoaded;
    }

    public static synchronized void init(ClassLoader classLoader) {
        AppLicenseChecker.loadLicense(classLoader);
    }

    public static synchronized void init(ClassLoader classLoader, boolean exitOnFailure) {
        AppLicenseChecker.loadLicense(classLoader);
        appExitOnFailure = exitOnFailure;
    }

    public static synchronized void init(ClassLoader classLoader, Notifier notifier, boolean exitOnFailure) {
        AppLicenseChecker.setNotifier(notifier);
        AppLicenseChecker.loadLicense(classLoader);
        appExitOnFailure = exitOnFailure;
    }

    public static synchronized void init(Class appClass) {
        AppLicenseChecker.loadLicense(appClass.getClassLoader());
    }

    public static synchronized void init(Class appClass, boolean exitOnFailure) {
        AppLicenseChecker.loadLicense(appClass.getClassLoader());
        appExitOnFailure = exitOnFailure;
    }

    public static synchronized void init(Class appClass, Notifier notifier, boolean exitOnFailure) {
        AppLicenseChecker.setNotifier(notifier);
        AppLicenseChecker.loadLicense(appClass.getClassLoader());
        appExitOnFailure = exitOnFailure;
    }

    public static synchronized boolean checkLicense(String productName, String version) {
        boolean valid;
        if (!licenseLoaded) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0001"));
        }
        if (!(valid = AppLicenseChecker.checkProductLicense(productName, version)) && appExitOnFailure) {
            System.exit(-1);
        }
        return valid;
    }

    public static synchronized boolean checkLicense(String productName, String version, int nUnits) {
        boolean valid;
        if (!licenseLoaded) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0001"));
        }
        if (!(valid = AppLicenseChecker.checkProductLicense(productName, version, nUnits)) && appExitOnFailure) {
            System.exit(-1);
        }
        return valid;
    }

    public static synchronized boolean checkLicense(String productName, String version, boolean checkIP) {
        boolean valid;
        if (!licenseLoaded) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0001"));
        }
        if (!(valid = AppLicenseChecker.checkProductLicense(productName, version, checkIP)) && appExitOnFailure) {
            System.exit(-1);
        }
        return valid;
    }

    public static synchronized boolean checkLicense(ClassLoader classLoader, String productName, String version) {
        AppLicenseChecker.loadLicense(classLoader);
        return AppLicenseChecker.checkLicense(productName, version);
    }

    public static boolean hasValidProductLicense(String productName, String version, boolean checkIP) throws UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        if (!licenseLoaded) {
            AppLicenseChecker.init(Thread.currentThread().getContextClassLoader(), DEFAULT_NONGUI_NOTIFIER, false);
        }
        try {
            String message = licenseManager.isLicenseValid(productName, version, checkIP);
            if (message != null && message.length() > 0) {
                AppLicenseChecker.displayLicenseInfo(message);
            }
            return true;
        }
        catch (UnverifiedLicenseException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
            throw e;
        }
        catch (UnlicensedProductException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
            throw e;
        }
        catch (InvalidLicenseException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
            throw e;
        }
    }

    public static synchronized LicenseDescriptor getLicenseDescriptor(String productName, String version) {
        try {
            return licenseManager.getLicenseDescriptor(productName, version);
        }
        catch (LicenseException e) {
            AppLicenseChecker.abortApplication(e.getMessage());
        }
        catch (Exception e) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0002", (Object)e.getMessage()));
        }
        return null;
    }

    public static synchronized LicenseDescriptor getLicenseDescriptor(String productName, String version, String type, String ipAddress) {
        try {
            return licenseManager.getLicenseDescriptor(productName, version, type, ipAddress);
        }
        catch (LicenseException e) {
            AppLicenseChecker.abortApplication(e.getMessage());
        }
        catch (Exception e) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0002", (Object)e.getMessage()));
        }
        return null;
    }

    private static void loadLicense(ClassLoader classLoader) {
        try {
            InputStream certStream;
            if (classLoader == null) {
                if (Thread.currentThread().getContextClassLoader() != null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                classLoader = (class$com$metamatrix$license$AppLicenseChecker == null ? (class$com$metamatrix$license$AppLicenseChecker = AppLicenseChecker.class$("com.metamatrix.license.AppLicenseChecker")) : class$com$metamatrix$license$AppLicenseChecker).getClassLoader();
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            Assertion.isNotNull((Object)classLoader);
            InputStream licenseStream = AppLicenseChecker.getResourceStream(classLoader, licenseFile);
            if (licenseStream == null) {
                AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0003", (Object)licenseFile));
            }
            if ((certStream = AppLicenseChecker.getResourceStream(classLoader, certFile)) == null) {
                AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0003", (Object)certFile));
            }
            licenseManager.setLicenseStream(licenseStream);
            licenseManager.setCertificateStream(certStream);
            licenseManager.loadLicense();
            licenseLoaded = true;
        }
        catch (LicenseVerificationException e) {
            String msg = e.getMessage() != null ? e.getMessage() : StringUtil.getStackTrace((Throwable)((Object)e));
            AppLicenseChecker.abortApplication(msg);
        }
        catch (Exception e) {
            String msg = e.getMessage() != null ? e.getMessage() : StringUtil.getStackTrace((Throwable)e);
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0005", (Object)msg));
        }
    }

    private static boolean checkProductLicense(String productName, String version) {
        boolean valid = false;
        try {
            String message = licenseManager.isLicenseValid(productName, version);
            if (message != null && message.length() > 0) {
                AppLicenseChecker.displayLicenseInfo(message);
            }
            valid = true;
        }
        catch (UnverifiedLicenseException e) {
            AppLicenseChecker.abortApplication(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
        }
        catch (Exception e) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0006", (Object)e.getMessage()));
        }
        return valid;
    }

    private static boolean checkProductLicense(String productName, String version, int nUnits) {
        boolean valid = false;
        try {
            String message = licenseManager.isLicenseValid(productName, version, nUnits);
            if (message != null && message.length() > 0) {
                AppLicenseChecker.displayLicenseInfo(message);
            }
            valid = true;
        }
        catch (UnverifiedLicenseException e) {
            AppLicenseChecker.abortApplication(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
        }
        catch (Exception e) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0006", (Object)e.getMessage()));
        }
        return valid;
    }

    private static boolean checkProductLicense(String productName, String version, boolean checkIP) {
        boolean valid = false;
        try {
            String message = licenseManager.isLicenseValid(productName, version, checkIP);
            if (message != null && message.length() > 0) {
                AppLicenseChecker.displayLicenseInfo(message);
            }
            valid = true;
        }
        catch (UnverifiedLicenseException e) {
            AppLicenseChecker.abortApplication(e.getMessage());
        }
        catch (UnlicensedProductException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
        }
        catch (InvalidLicenseException e) {
            AppLicenseChecker.notifyOfFailure(e.getMessage());
        }
        catch (Exception e) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0006", (Object)e.getMessage()));
        }
        return valid;
    }

    public static synchronized boolean checkLicenseNoFailure(String productName, String version) {
        boolean valid;
        if (!licenseLoaded) {
            AppLicenseChecker.abortApplication(LicensePlugin.Util.getString("ERR.003.016.0001"));
        }
        if (!(valid = AppLicenseChecker.checkProductLicenseNoFailure(productName, version)) && appExitOnFailure) {
            System.exit(-1);
        }
        return valid;
    }

    private static boolean checkProductLicenseNoFailure(String productName, String version) {
        boolean valid = false;
        try {
            licenseManager.isLicenseValid(productName, version);
            valid = true;
        }
        catch (UnverifiedLicenseException e) {
        }
        catch (UnlicensedProductException e) {
        }
        catch (InvalidLicenseException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    private static InputStream getResourceStream(ClassLoader classLoader, String filename) {
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream(filename);
        }
        catch (Exception e) {
            LicensePlugin.Util.log((Throwable)e);
            String msg = e.getMessage() != null ? e.getMessage() : StringUtil.getStackTrace((Throwable)e);
            throw new RuntimeException(msg);
        }
        return inputStream;
    }

    private static void setNotifier(Notifier n) {
        notifier = n;
    }

    private static void abortApplication(String message) {
        AppLicenseChecker.notifyOfFailure(message);
        try {
            Platform.endSplash();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(-1);
    }

    private static void notifyOfFailure(String message) {
        notifier.showFailureMessage(message);
    }

    private static void displayLicenseInfo(String message) {
        notifier.showInfoMessage(message);
    }

    static Notifier getGUINotifier() {
        return new Notifier(){

            public void showFailureMessage(String message) {
                System.out.println(message);
                JOptionPane.showMessageDialog(null, message, LicensePlugin.Util.getString("AppLicenseChecker.License_Error"), 0);
            }

            public void showInfoMessage(String message) {
                System.out.println(message);
                JOptionPane.showMessageDialog(null, message, LicensePlugin.Util.getString("AppLicenseChecker.License_Nearing_Expiration"), 1);
            }
        };
    }

    static Notifier getNonGUINotifier() {
        return new Notifier(){

            public void showFailureMessage(String message) {
                System.out.println(message);
            }

            public void showInfoMessage(String message) {
                System.out.println(message);
            }
        };
    }

    public static void main(String[] args) throws Exception {
        TestClass.main(new String[]{"MetaMatrix Server", "2.0"});
        TestClass.main(new String[]{"MetaMatrix Server", "2.0"});
        TestClass.main(new String[]{"MetaBase Modeler", "2.0"});
        TestClass.main(new String[]{"MetaBase Modeler", "2.0"});
        TestClass.main(new String[]{"MetaBase Server", "2.0"});
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TestClass {
        String productName;
        String version;

        public TestClass(String p, String v) {
            this.productName = p;
            this.version = v;
        }

        public static void main(String[] args) {
            TestClass test = new TestClass(args[0], args[1]);
            System.out.println("\nStarting application " + test.productName + " " + test.version + "...");
            AppLicenseChecker.init(test.getClass(), false);
            boolean ok = AppLicenseChecker.checkLicense(test.productName, test.version, true);
            if (ok) {
                System.out.println("Whew, made it past license check!");
            } else {
                System.out.println("License check failed!");
            }
        }
    }

    public static interface Notifier {
        public void showFailureMessage(String var1);

        public void showInfoMessage(String var1);
    }
}

