/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license;

import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.License;
import com.metamatrix.license.domain.ProductLicense;
import com.metamatrix.license.exception.InvalidLicenseException;
import com.metamatrix.license.exception.UnlicensedProductException;
import java.util.Set;

public class LicenseDescriptor {
    private License license;
    private ProductLicense productLicense;

    public LicenseDescriptor(License license) {
        this.license = license;
    }

    public LicenseDescriptor(License license, ProductLicense plicense) {
        this.license = license;
        this.productLicense = plicense;
    }

    public LicenseDescriptor(License license, String productName, String version) throws UnlicensedProductException, InvalidLicenseException {
        this(license);
        this.setProduct(productName, version);
    }

    public void setProduct(String productName, String version) throws UnlicensedProductException, InvalidLicenseException {
        this.productLicense = this.license.getProductLicense(productName, version);
    }

    public String getLicenseType() {
        this.checkLicense();
        return this.license.getLicenseInfo().getLicenseType();
    }

    public String getCreatedBy() {
        this.checkLicense();
        return this.license.getLicenseInfo().getCreatedBy();
    }

    public String getCreated() {
        this.checkLicense();
        return License.dateToString(this.license.getLicenseInfo().getCreated());
    }

    public String getLastUpdatedBy() {
        this.checkLicense();
        return this.license.getLicenseInfo().getLastUpdatedBy();
    }

    public String getLastUpdated() {
        this.checkLicense();
        return License.dateToString(this.license.getLicenseInfo().getLastUpdated());
    }

    public String getSignature() {
        this.checkLicense();
        return this.license.getLicenseInfo().getSignature();
    }

    public String getOrganization() {
        this.checkLicense();
        return this.license.getCustomer().getOrganization();
    }

    public String getOrganizationalUnit() {
        this.checkLicense();
        return this.license.getCustomer().getOrganizationalUnit();
    }

    public String getIssuanceDate() {
        this.checkProductLicense();
        return License.dateToString(this.productLicense.getIssuanceDate());
    }

    public String getEffectiveDate() {
        this.checkProductLicense();
        return License.dateToString(this.productLicense.getEffectiveDate());
    }

    public String getExpirationDate() {
        this.checkProductLicense();
        return License.dateToString(this.productLicense.getExpirationDate());
    }

    public int getNumberOfUnits() {
        this.checkProductLicense();
        return this.productLicense.getNumberOfUnits();
    }

    public Set getIPAddresses() {
        this.checkProductLicense();
        return this.productLicense.getIPSet().getFullSet();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("MetaMatrix License");
        buffer.append("\n");
        buffer.append("\nLicense Type " + this.getLicenseType());
        buffer.append("\n");
        buffer.append("\nIssued    : " + this.getIssuanceDate());
        buffer.append("\nEffective : " + this.getEffectiveDate());
        buffer.append("\nExpiration: " + this.getExpirationDate());
        buffer.append("\n");
        buffer.append("\nNumber of units: " + this.getNumberOfUnits());
        buffer.append("\nIP addresses: " + this.getIPAddresses());
        return buffer.toString();
    }

    private void checkLicense() throws IllegalStateException {
        if (this.license == null) {
            throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0007"));
        }
    }

    private void checkProductLicense() throws IllegalStateException {
        if (this.productLicense == null) {
            throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0008"));
        }
    }

    public static LicenseDescriptor example(int key) {
        License lic = License.example(key);
        ProductLicense pl = (ProductLicense)lic.getProductLicenses().iterator().next();
        LicenseDescriptor info = new LicenseDescriptor(lic, pl);
        return info;
    }

    public static void main(String[] args) {
        LicenseDescriptor info = LicenseDescriptor.example(0);
        System.out.println(info);
    }
}

