/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.LicenseDescriptor;
import com.metamatrix.license.LicenseListener;
import com.metamatrix.license.exception.LicenseVerificationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class LicensePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.metamatrix.license";
    public static final int LICENSE_INFO_CODE = 100;
    public static final int LICENSE_FAILURE_CODE = 101;
    public static final int LICENSE_MISSING_CODE = 102;
    public static final int LICENSE_CERT_MISSING_CODE = 103;
    private static final String BUNDLE_NAME = "com.metamatrix.license.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.license", "com.metamatrix.license.i18n", ResourceBundle.getBundle("com.metamatrix.license.i18n"));
    public static boolean DEBUG = false;
    public static final String DELIMITER = ".";
    private static LicensePlugin INSTANCE;
    private boolean initialized;
    private String initializedFailureMessage;
    private List notifiers;
    private final Object notifierLock = new Object();
    private File licenseDirLocation = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    protected void initialize() throws CoreException {
        String msg;
        Status status;
        Object[] params;
        URL resolvedFileUrl;
        if (this.initialized) {
            return;
        }
        LicenseNotifier notifier = new LicenseNotifier();
        ArrayList<URL> urls = new ArrayList<URL>(2);
        URL installUrl = null;
        URL licenseDirUrl = null;
        boolean bUsePluginDir = false;
        boolean bUseLicenseDir = false;
        File licenseDir = null;
        try {
            installUrl = Platform.resolve((URL)this.getBundle().getEntry("/"));
            licenseDirUrl = new URL(installUrl.toString() + "../../../license/");
            licenseDirUrl = Platform.resolve((URL)licenseDirUrl);
            licenseDir = this.getFile(licenseDirUrl);
            if (licenseDir.exists()) {
                urls.add(licenseDirUrl);
                bUsePluginDir = false;
                bUseLicenseDir = true;
            } else {
                bUsePluginDir = true;
                bUseLicenseDir = false;
            }
        }
        catch (FileNotFoundException e) {
            bUsePluginDir = true;
            bUseLicenseDir = false;
        }
        catch (Throwable e) {
            Util.log(e);
            bUsePluginDir = true;
            bUseLicenseDir = false;
        }
        if (bUsePluginDir) {
            urls.add(installUrl);
        }
        try {
            resolvedFileUrl = Platform.resolve((URL)installUrl);
            boolean licenseExists = false;
            if (bUsePluginDir) {
                URL licenseUrl = new URL(resolvedFileUrl.toString() + "MetaMatrixLicense.xml");
                File licenseFile = this.getFile(licenseUrl);
                licenseExists = licenseFile.exists();
                this.licenseDirLocation = this.getFile(resolvedFileUrl);
            }
            if (bUseLicenseDir && !licenseExists && licenseDirUrl != null) {
                URL license2Url = new URL(licenseDirUrl.toString() + "MetaMatrixLicense.xml");
                File license2File = this.getFile(license2Url);
                licenseExists = license2File.exists();
                this.licenseDirLocation = this.getFile(licenseDirUrl);
            }
            if (!licenseExists) {
                String sPath = "";
                if (bUseLicenseDir) {
                    sPath = licenseDir.getCanonicalPath();
                    this.licenseDirLocation = licenseDir;
                } else {
                    URL resolvedInstallUrl = Platform.resolve((URL)installUrl);
                    File installDir = this.getFile(resolvedInstallUrl);
                    sPath = installDir.getCanonicalPath();
                    this.licenseDirLocation = installDir;
                }
                params = null;
                String aMsg = null;
                if (Platform.getProduct() == null) {
                    params = new Object[]{sPath};
                    aMsg = Util.getString("LicensePlugin.Unable_to_file_license_file", params);
                } else {
                    params = new Object[]{Platform.getProduct().getProperty("ownerName"), sPath};
                    aMsg = Util.getString("LicensePlugin.missingProductLicenseFile", params);
                }
                this.initializedFailureMessage = aMsg;
                status = new Status(4, PLUGIN_ID, 102, aMsg, null);
                this.fireMessage((IStatus)status);
            }
        }
        catch (Throwable e1) {
            this.initializedFailureMessage = e1.getLocalizedMessage();
            Util.log(e1);
        }
        if (this.initializedFailureMessage == null) {
            try {
                resolvedFileUrl = Platform.resolve((URL)installUrl);
                boolean certFileExists = false;
                String path = "";
                if (bUsePluginDir) {
                    URL certUrl = new URL(resolvedFileUrl.toString() + "metamatrix.cert");
                    File certFile = this.getFile(certUrl);
                    certFileExists = certFile.exists();
                    path = certFile.getParent();
                }
                if (bUseLicenseDir && !certFileExists && licenseDirUrl != null) {
                    URL cert2Url = new URL(licenseDirUrl.toString() + "metamatrix.cert");
                    File cert2File = this.getFile(cert2Url);
                    certFileExists = cert2File.exists();
                    path = cert2File.getParent();
                }
                if (!certFileExists) {
                    params = null;
                    msg = null;
                    if (Platform.getProduct() == null) {
                        params = new Object[]{path, "metamatrix.cert"};
                        msg = Util.getString("LicensePlugin.Unable_to_file_cert_file", params);
                    } else {
                        String company = Platform.getProduct().getProperty("ownerName");
                        params = new Object[]{company, path, "metamatrix.cert"};
                        msg = Util.getString("LicensePlugin.missingProductCertFile", params);
                    }
                    this.initializedFailureMessage = msg;
                    status = new Status(4, PLUGIN_ID, 103, msg, null);
                    this.fireMessage((IStatus)status);
                }
            }
            catch (Throwable e1) {
                this.initializedFailureMessage = e1.getLocalizedMessage();
                Util.log(e1);
            }
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        URLClassLoader classLoader = new URLClassLoader(urlArray, ((Object)((Object)this)).getClass().getClassLoader());
        if (this.initializedFailureMessage != null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 101, this.initializedFailureMessage, null));
        }
        try {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            LicenseChecker.registerNotifier(notifier);
            LicenseChecker.loadLicense(classLoader);
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        catch (LicenseVerificationException lve) {
        }
        catch (Throwable e) {
            params = new Object[]{e.getLocalizedMessage()};
            this.initializedFailureMessage = msg = Util.getString("LicensePlugin.Error_while_initializing_license_utility", params);
            status = new Status(4, PLUGIN_ID, 101, msg, e);
            Util.log((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        this.initialized = true;
    }

    protected File getFile(URL url) {
        String path = url.getPath();
        File result = new File(path);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fireMessage(final IStatus msg) {
        Object object = this.notifierLock;
        synchronized (object) {
            if (this.notifiers == null) {
                this.notifiers = new ArrayList();
                String id = "com.metamatrix.license.licenseListener";
                IExtension[] extensions = PluginUtilities.getExtensions((String)"com.metamatrix.license.licenseListener");
                for (int i = 0; i < extensions.length; ++i) {
                    IExtension extension = extensions[i];
                    String element = "class";
                    String attribute = "name";
                    try {
                        Object instance = PluginUtilities.createExecutableExtension((IExtension)extension, (String)"class", (String)"name");
                        if (instance instanceof LicenseListener) {
                            this.notifiers.add(instance);
                            continue;
                        }
                        Object[] params = new Object[]{extension.getUniqueIdentifier()};
                        String message = Util.getString("LicensePlugin.Extension_class_not_instanceof_LicenseNotifier", params);
                        Util.log((Object)message);
                        continue;
                    }
                    catch (CoreException e) {
                        Util.log((Throwable)e);
                    }
                }
            }
            Util.log(msg);
            Iterator iter = this.notifiers.iterator();
            while (iter.hasNext()) {
                final LicenseListener notifier = (LicenseListener)iter.next();
                try {
                    ISafeRunnable runnable = new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            String msg2 = Util.getString("LicensePlugin.Error_while_handling_message");
                            Util.log(4, exception, msg2);
                        }

                        public void run() throws Exception {
                            notifier.handleMessage(msg);
                        }
                    };
                    Platform.run((ISafeRunnable)runnable);
                }
                catch (Throwable e) {
                    Util.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        Object object = this.notifierLock;
        synchronized (object) {
            if (this.notifiers != null) {
                Iterator iter = this.notifiers.iterator();
                while (iter.hasNext()) {
                    LicenseListener notifier = (LicenseListener)iter.next();
                    notifier.shutdown();
                    iter.remove();
                }
            }
        }
    }

    public static void checkLicense(String productName, String version) throws CoreException {
        INSTANCE.initialize();
        boolean validLicense = LicenseChecker.hasValidProductLicense(productName, version);
        if (!validLicense) {
            Object[] params = new Object[]{productName, version};
            String msg = Util.getString("LicensePlugin.checkLicenseFailure", params);
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 101, msg, null));
        }
    }

    public static void checkLicense(String productName, String version, int nUnits) throws CoreException {
        INSTANCE.initialize();
        boolean validLicense = LicenseChecker.hasValidProductLicense(productName, version, nUnits);
        if (!validLicense) {
            Object[] params = new Object[]{productName, version};
            String msg = Util.getString("LicensePlugin.checkLicenseFailure", params);
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 101, msg, null));
        }
    }

    public static void checkLicense(String productName, String version, boolean checkIP) throws CoreException {
        INSTANCE.initialize();
        boolean validLicense = LicenseChecker.hasValidProductLicense(productName, version, checkIP);
        if (!validLicense) {
            Object[] params = new Object[]{productName, version};
            String msg = Util.getString("LicensePlugin.checkLicenseFailure", params);
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 101, msg, null));
        }
    }

    public static LicenseDescriptor getLicenseDescriptor(String productName, String version) {
        return LicenseChecker.getLicenseDescriptor(productName, version);
    }

    public static LicenseDescriptor getLicenseDescriptor(String productName, String version, String type, String ipAddress) {
        return LicenseChecker.getLicenseDescriptor(productName, version, type, ipAddress);
    }

    protected static void fireFailureMessage(String msg) {
        Status status = new Status(4, PLUGIN_ID, 101, msg, null);
        INSTANCE.fireMessage((IStatus)status);
    }

    protected static void fireInfoMessage(String msg) {
        Status status = new Status(1, PLUGIN_ID, 100, msg, null);
        INSTANCE.fireMessage((IStatus)status);
    }

    public static boolean isCapabilityLicensed(String theProductName, String theCapabilityName, String theVersion) {
        boolean result = LicensePlugin.isProductLicensed(theProductName, theVersion);
        if (result) {
            result = LicenseChecker.hasValidProductLicense(theCapabilityName, theVersion);
        }
        return result;
    }

    public static boolean isProductLicensed(String theProductName, String theVersion) {
        return LicenseChecker.hasValidProductLicense(theProductName, theVersion);
    }

    public static LicensePlugin getInstance() {
        try {
            if (!LicensePlugin.INSTANCE.initialized) {
                INSTANCE.initialize();
            }
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
        }
        return INSTANCE;
    }

    public File getLicenseDir() {
        if (!this.initialized) {
            try {
                URL installUrl = Platform.resolve((URL)this.getBundle().getEntry("/"));
                URL licenseDirUrl = new URL(installUrl.toString() + "/license/");
                licenseDirUrl = Platform.resolve((URL)licenseDirUrl);
                this.licenseDirLocation = this.getFile(licenseDirUrl);
            }
            catch (MalformedURLException err) {
                Util.log((Throwable)err);
            }
            catch (IOException err) {
                Util.log((Throwable)err);
            }
        }
        return this.licenseDirLocation;
    }

    protected class LicenseNotifier
    implements LicenseChecker.Notifier {
        protected LicenseNotifier() {
        }

        public void showFailureMessage(String message) {
            LicensePlugin.fireFailureMessage(message);
        }

        public void showInfoMessage(String message) {
            LicensePlugin.fireInfoMessage(message);
        }
    }

    public static class EXTENSION_POINT {

        public static class LICENSE_NOTIFIER {
            public static final String ID = "licenseListener";
            public static final String UNIQUE_ID = "com.metamatrix.license.licenseListener";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }
    }
}

