/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.domain;

import com.metamatrix.license.LicensePlugin;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class RangeSet
extends TreeSet {
    private Range range;
    private Incrementer incrementer;

    public RangeSet() {
    }

    public RangeSet(Comparator comparator) {
        super(comparator);
    }

    public RangeSet(Incrementer incr) {
        this();
        this.setIncrementer(incr);
    }

    public Object getFirst() {
        return this.range.getFirst();
    }

    public Object getLast() {
        return this.range.getLast();
    }

    public void setRange(Object first, Object last) {
        this.setRange(new Range(first, last));
    }

    public void setRange(Range range) {
        this.clear();
        this.range = range;
        this.setRange(range.getFirst(), range.getLast(), this.incrementer);
    }

    public boolean add(Object range) {
        if (!(range instanceof Range)) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0039"));
        }
        boolean wasThere = this.contains(range);
        this.setRange((Range)range);
        return wasThere;
    }

    public Incrementer getIncrementer() {
        return this.incrementer;
    }

    public void setIncrementer(Incrementer incr) {
        this.incrementer = incr;
    }

    public String toString() {
        return "(" + this.getFirst() + "," + this.getLast() + ")";
    }

    private void setRange(Object first, Object last, Incrementer incrementer) throws IllegalArgumentException {
        if (!first.getClass().equals(last.getClass())) {
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0040"));
        }
        if (incrementer == null) {
            if (first instanceof Integer) {
                incrementer = RangeSet.getIntegerIncrementer();
            } else {
                throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0041"));
            }
        }
        incrementer.setRange(first, last);
        Object obj = first;
        super.add(obj);
        try {
            while ((obj = incrementer.increment(obj)) != null) {
                super.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Incrementer getIntegerIncrementer() {
        Incrementer incrementer = new Incrementer(){
            Integer low;
            Integer high;

            public void setRange(Object lo, Object hi) throws IllegalArgumentException {
                if (lo == null || hi == null) {
                    throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0042", new Object[]{lo, hi}));
                }
                this.low = (Integer)lo;
                this.high = (Integer)hi;
            }

            public Object increment(Object in) throws Exception {
                if (in == null) {
                    throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0043", (Object)this.low, (Object)this.high));
                }
                Integer i = (Integer)in;
                if (i >= this.high) {
                    return null;
                }
                return new Integer(i + 1);
            }
        };
        return incrementer;
    }

    public static Incrementer getDottedStringIncrementer() {
        Incrementer incrementer = new Incrementer(){
            String low;
            String high;
            int highDigit;
            String base;

            public void setRange(Object lo, Object hi) throws IllegalArgumentException {
                String base2;
                String base1;
                this.low = (String)lo;
                this.high = (String)hi;
                try {
                    base1 = this.low;
                    int period = base1.lastIndexOf(46);
                    Integer.parseInt(base1.substring(period + 1));
                    base1 = base1.substring(0, period);
                    base2 = this.high;
                    period = base2.lastIndexOf(46);
                    this.highDigit = Integer.parseInt(base2.substring(period + 1));
                    base2 = base2.substring(0, period);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                if (!base1.equals(base2)) {
                    throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0044", (Object)base1, (Object)base2));
                }
                this.base = base1;
            }

            public Object increment(Object in) throws Exception {
                String addr = (String)in;
                int value = Integer.parseInt(addr.substring(addr.lastIndexOf(46) + 1));
                if (value >= this.highDigit) {
                    return null;
                }
                return this.base + "." + ++value;
            }
        };
        return incrementer;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Set 1...");
        RangeSet rs1 = new RangeSet(RangeSet.getIntegerIncrementer());
        rs1.setRange(new Integer(0), new Integer(10));
        System.out.println("Range set: " + rs1);
        Iterator iter1 = rs1.iterator();
        while (iter1.hasNext()) {
            System.out.println("  Element " + iter1.next());
        }
        System.out.println("Set 2...");
        InetAddress addr1 = InetAddress.getByName("192.168.10.9");
        InetAddress addr2 = InetAddress.getByName("192.168.10.12");
        RangeSet rs2 = new RangeSet(RangeSet.getDottedStringIncrementer());
        rs2.setRange(addr1.getHostAddress(), addr2.getHostAddress());
        System.out.println("Range set: " + rs2);
        Iterator iter2 = rs2.iterator();
        while (iter2.hasNext()) {
            System.out.println("  Element " + iter2.next());
        }
        System.out.println("Set 3...");
        String saddr1 = "192.168.10.20";
        String saddr2 = "192.168.10.25";
        RangeSet rs3 = new RangeSet(RangeSet.getDottedStringIncrementer());
        rs3.setRange(saddr1, saddr2);
        Iterator iter3 = rs3.iterator();
        while (iter3.hasNext()) {
            System.out.println("  Element " + iter3.next());
        }
    }

    public static interface Incrementer {
        public void setRange(Object var1, Object var2) throws IllegalArgumentException;

        public Object increment(Object var1) throws Exception;
    }

    public static class Range {
        public Object first;
        public Object last;

        public Range() {
        }

        public Range(Object first, Object last) {
            this.setFirst(first);
            this.setLast(last);
        }

        public Object getFirst() {
            return this.first;
        }

        public void setFirst(Object first) {
            this.first = first;
        }

        public Object getLast() {
            return this.last;
        }

        public void setLast(Object last) {
            this.last = last;
        }

        public boolean equals(Object other) {
            return this.first.equals(((Range)other).first) && this.last.equals(((Range)other).last);
        }

        public int hashCode() {
            return this.first.hashCode() ^ this.last.hashCode();
        }

        public String toString() {
            return "(" + this.first + "," + this.last + ")";
        }
    }
}

