/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.xml;

import com.metamatrix.internal.core.xml.JdomHelper;
import com.metamatrix.internal.core.xml.SAXBuilderHelper;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.Customer;
import com.metamatrix.license.domain.IPSet;
import com.metamatrix.license.domain.IPSets;
import com.metamatrix.license.domain.License;
import com.metamatrix.license.domain.LicenseInfo;
import com.metamatrix.license.domain.ProductLicense;
import com.metamatrix.license.domain.ProductLicenses;
import com.metamatrix.license.xml.BasicLicenseObjectFactory;
import com.metamatrix.license.xml.LicenseObjectFactory;
import com.metamatrix.license.xml.LicenseXMLTags;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class LicenseReader
implements LicenseXMLTags {
    private LicenseObjectFactory factory;
    private String licenseFile;
    private InputStream licenseStream;
    private Document xmlDoc;
    private License license;
    static /* synthetic */ Class class$com$metamatrix$license$xml$LicenseReader;

    public LicenseReader(String fileName) {
        this.factory = new BasicLicenseObjectFactory();
        this.licenseFile = fileName;
    }

    public LicenseReader(InputStream stream) {
        this.factory = new BasicLicenseObjectFactory();
        this.licenseStream = stream;
    }

    public LicenseReader(InputStream stream, LicenseObjectFactory factory) {
        this.licenseStream = stream;
        this.factory = factory;
    }

    public Document getXMLDocument() {
        return this.xmlDoc;
    }

    public License getLicense() {
        return this.license;
    }

    public void init() throws IOException, JDOMException {
        if (this.licenseFile != null) {
            this.xmlDoc = LicenseReader.loadDocument(this.licenseFile);
        } else if (this.licenseStream != null) {
            this.xmlDoc = LicenseReader.loadDocument(this.licenseStream);
        } else {
            throw new IllegalStateException(LicensePlugin.Util.getString("ERR.003.016.0048"));
        }
    }

    public License loadLicense() throws Exception {
        Document doc = this.xmlDoc;
        Element root = doc.getRootElement();
        Namespace ns = root.getNamespace();
        this.license = this.factory.createLicense();
        this.license.setVersion(root.getAttributeValue("version"));
        this.loadLicenseInfo(root, ns);
        this.loadCustomer(root, ns);
        this.loadIPSets(root, ns);
        this.loadProductLicenses(root, ns);
        return this.license;
    }

    private LicenseInfo loadLicenseInfo(Element startElement, Namespace ns) throws Exception {
        LicenseInfo obj = this.factory.createLicenseInfo();
        this.license.setLicenseInfo(obj);
        Element start = startElement.getChild("licenseInfo", ns);
        obj.setLicenseType(start.getChild("licenseType", ns).getTextTrim());
        obj.setCreatedBy(start.getChild("createdBy", ns).getTextTrim());
        obj.setCreated(License.stringToDate(start.getChild("created", ns).getTextTrim()));
        obj.setLastUpdatedBy(start.getChild("lastUpdatedBy", ns).getTextTrim());
        obj.setLastUpdated(License.stringToDate(start.getChild("lastUpdated", ns).getTextTrim()));
        obj.setSignature(start.getChild("signature", ns).getTextTrim());
        return obj;
    }

    private Customer loadCustomer(Element startElement, Namespace ns) throws Exception {
        Customer obj = this.factory.createCustomer();
        this.license.setCustomer(obj);
        Element start = startElement.getChild("customer", ns);
        obj.setOrganization(start.getChild("organization", ns).getTextTrim());
        obj.setOrganizationalUnit(start.getChild("organizationalUnit", ns).getTextTrim());
        obj.setStreetAddress(start.getChild("streetAddress", ns).getTextTrim());
        obj.setCity(start.getChild("city", ns).getTextTrim());
        obj.setState(start.getChild("state", ns).getTextTrim());
        obj.setCountryCode(start.getChild("countryCode", ns).getTextTrim());
        obj.setPostalCode(start.getChild("postalCode", ns).getTextTrim());
        obj.setContactName(start.getChild("contactName", ns).getTextTrim());
        obj.setContactPhone(start.getChild("contactPhone", ns).getTextTrim());
        obj.setContactEmail(start.getChild("contactEmail", ns).getTextTrim());
        return obj;
    }

    private IPSets loadIPSets(Element startElement, Namespace ns) throws Exception {
        IPSets obj = this.factory.createIPSets();
        this.license.setIPSets(obj);
        Element setRoot = startElement.getChild("ipSets", ns);
        if (setRoot == null) {
            return obj;
        }
        List sets = setRoot.getChildren();
        Iterator iter = sets.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            IPSet ipSet = this.loadIPSet(element, ns);
            obj.addIPSet(ipSet);
        }
        return obj;
    }

    private ProductLicenses loadProductLicenses(Element startElement, Namespace ns) throws Exception {
        ProductLicenses obj = this.factory.createProductLicenses();
        this.license.setProductLicenses(obj);
        Element localRoot = startElement.getChild("productLicenses", ns);
        if (localRoot == null) {
            return obj;
        }
        List products = localRoot.getChildren();
        Iterator iter = products.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            String productName = element.getAttributeValue("name");
            String versionSpec = element.getAttributeValue("version");
            List licenses = element.getChildren();
            Iterator iter2 = licenses.iterator();
            while (iter2.hasNext()) {
                Element licenseElement = (Element)iter2.next();
                ProductLicense plicense = this.loadProductLicense(licenseElement, ns);
                plicense.setProductName(productName);
                plicense.setVersionSpec(versionSpec);
                obj.addLicense(plicense);
            }
        }
        return obj;
    }

    private ProductLicense loadProductLicense(Element start, Namespace ns) throws Exception {
        ProductLicense obj = this.factory.createProductLicense();
        String uuid = start.getAttributeValue("uuid");
        obj.setUUID(uuid);
        String type = start.getAttributeValue("type");
        obj.setType(type);
        obj.setIssuanceDate(License.stringToDate(start.getChild("issuanceDate", ns).getTextTrim()));
        obj.setEffectiveDate(License.stringToDate(start.getChild("effectiveDate", ns).getTextTrim()));
        obj.setExpirationDate(License.stringToDate(start.getChild("expirationDate", ns).getTextTrim()));
        String unitsValue = start.getChild("numberOfUnits", ns).getTextTrim();
        if (unitsValue.equals("Unlimited")) {
            obj.setNumberOfUnits(Integer.MAX_VALUE);
        } else {
            obj.setNumberOfUnits(Integer.parseInt(unitsValue));
        }
        Element ipElement = start.getChild("ipSet", ns);
        if (ipElement != null) {
            IPSet ipSet = this.loadIPSet(ipElement, ns);
            obj.setIPSet(ipSet);
        } else {
            obj.setIPSet(IPSet.UNDEFINED);
        }
        return obj;
    }

    private IPSet loadIPSet(Element startElement, Namespace ns) throws Exception {
        if (startElement.getTextTrim().equals(IPSet.UNDEFINED)) {
            return IPSet.UNDEFINED;
        }
        IPSet obj = this.factory.createIPSet();
        String elemName = startElement.getName();
        if (!elemName.equals("ipSet")) {
            throw new RuntimeException(LicensePlugin.Util.getString("ERR.003.016.0049", (Object)elemName));
        }
        String attrName = startElement.getAttributeValue("name");
        obj.setName(attrName);
        List children = startElement.getChildren();
        Iterator iter2 = children.iterator();
        while (iter2.hasNext()) {
            Element element = (Element)iter2.next();
            String elementName = element.getName();
            if (elementName.equals("ipAddress")) {
                String addr = element.getAttributeValue("address");
                obj.addAddress(addr);
                continue;
            }
            if (elementName.equals("ipRange")) {
                String addr1 = element.getAttributeValue("startAddress");
                String addr2 = element.getAttributeValue("endAddress");
                obj.addRange(addr1, addr2);
                continue;
            }
            if (elementName.equals("ipSetRef")) {
                String ref = element.getAttributeValue("name");
                if (this.license.getIPSets().contains(ref)) {
                    IPSet includeSet = this.license.getIPSets().getIPSet(ref);
                    obj.addIncludeSet(includeSet);
                    continue;
                }
                throw new RuntimeException(LicensePlugin.Util.getString("ERR.003.016.0050", (Object)ref));
            }
            throw new RuntimeException("Bad ...");
        }
        return obj;
    }

    public static Document loadDocument(String filename) throws IOException, JDOMException {
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder((boolean)false);
        return builder.build(new File(filename));
    }

    public static Document loadDocument(InputStream istream) throws IOException, JDOMException {
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder((boolean)false);
        return builder.build(istream);
    }

    public static void main(String[] args) throws Exception {
        String fileName = args[0];
        PrintWriter pw = new PrintWriter(System.out, true);
        pw.println("\nTest from file...\n");
        try {
            LicenseReader.testFromFile(fileName, pw);
        }
        catch (Exception e) {
            System.out.println("Error reading from file: " + e.getMessage());
        }
        pw.println("\nTest from stream...\n");
        try {
            LicenseReader.testFromStream(fileName, pw);
        }
        catch (Exception e) {
            System.out.println("Error reading from stream: " + e.getMessage());
        }
    }

    private static void testFromFile(String filename, PrintWriter pw) throws IOException {
        LicenseReader reader = new LicenseReader(filename);
        LicenseReader.testRead(reader, pw);
    }

    private static void testFromStream(String filename, PrintWriter pw) throws IOException {
        InputStream istream = LicenseReader.getResourceStream(class$com$metamatrix$license$xml$LicenseReader == null ? (class$com$metamatrix$license$xml$LicenseReader = LicenseReader.class$("com.metamatrix.license.xml.LicenseReader")) : class$com$metamatrix$license$xml$LicenseReader, filename);
        if (istream == null) {
            throw new IllegalStateException("File " + filename + " is not in the application's classpath.");
        }
        LicenseReader reader = new LicenseReader(istream);
        LicenseReader.testRead(reader, pw);
    }

    private static void testRead(LicenseReader reader, PrintWriter pw) throws IOException {
        try {
            reader.init();
            reader.loadLicense();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.println("\nDocument structure");
        JdomHelper.print((PrintStream)System.out, (Document)reader.getXMLDocument());
        pw.println("\nDocument output");
        Format format = JdomHelper.getFormat((String)"    ", (boolean)true);
        format.setTextMode(Format.TextMode.NORMALIZE);
        XMLOutputter outputter = new XMLOutputter(format);
        outputter.output(reader.getXMLDocument(), (Writer)pw);
    }

    private static InputStream getResourceStream(Class appClass, String filename) {
        InputStream inputStream = null;
        try {
            inputStream = appClass.getClassLoader().getResourceAsStream(filename);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return inputStream;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

