/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.commandshell;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.commandshell.ArgumentConversionException;
import com.metamatrix.core.commandshell.CommandLineParser;
import com.metamatrix.core.commandshell.WrongNumberOfArgumentsException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.StringUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class Command {
    private static final String COMMAND_COMMENT = "//";
    private Object target;
    private Class targetClass;
    private String commandName;
    private String[] args;
    private Method method;
    private String defaultFilePath = "";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$metamatrix$core$commandshell$CommandTarget;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$com$metamatrix$core$id$ObjectID;

    public Command(Object target, String[] commandLine) {
        this.init(target, commandLine);
    }

    private void init(Object target, String[] commandLine) {
        this.target = target;
        this.targetClass = target.getClass();
        if (commandLine.length == 0) {
            this.commandName = null;
        } else {
            this.commandName = commandLine[0];
            if (this.commandName.trim().startsWith(COMMAND_COMMENT)) {
                this.commandName = null;
            } else {
                this.args = new String[commandLine.length - 1];
                for (int i = 1; i < commandLine.length; ++i) {
                    this.args[i - 1] = commandLine[i];
                }
            }
        }
    }

    public Command(Object target, String commandLine) {
        this.init(target, new CommandLineParser().parse(commandLine));
    }

    public Command(Object target, String commandName, String[] args) {
        this.target = target;
        this.targetClass = target.getClass();
        this.commandName = commandName;
        this.args = args;
    }

    public void setDefaultFilePath(String defaultFilePath) {
        this.defaultFilePath = defaultFilePath;
    }

    private Method getMethod(Set methodsToIgnore) throws NoSuchMethodException {
        if (!Command.shouldIgnoreMethod(this.commandName, methodsToIgnore)) {
            this.getMethodDirect();
        }
        if (this.method == null) {
            Object[] params = new Object[]{this.targetClass.getName(), this.commandName};
            String message = CorePlugin.Util.getString("Command.Could_not_find_method", params);
            throw new NoSuchMethodException(message);
        }
        return this.method;
    }

    static boolean shouldIgnoreMethod(String currentMethodName, Set methodsToIgnore) {
        Iterator i = methodsToIgnore.iterator();
        while (i.hasNext()) {
            String methodName = (String)i.next();
            if (!methodName.toLowerCase().equals(currentMethodName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void getMethodDirect() {
        Method[] methods = this.targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (this.shouldSkipMethod(methods, i) || !methods[i].getName().toLowerCase().equals(this.commandName.toLowerCase())) continue;
            this.method = methods[i];
            break;
        }
    }

    private boolean shouldSkipMethod(Method[] methods, int i) {
        boolean skipMethod = false;
        if (methods[i].getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = Command.class$("java.lang.Object")) : class$java$lang$Object)) {
            skipMethod = true;
        }
        if (methods[i].getDeclaringClass().equals(class$com$metamatrix$core$commandshell$CommandTarget == null ? (class$com$metamatrix$core$commandshell$CommandTarget = Command.class$("com.metamatrix.core.commandshell.CommandTarget")) : class$com$metamatrix$core$commandshell$CommandTarget) && !this.commandName.toLowerCase().equals("help") && !this.commandName.toLowerCase().equals("quit") && !this.commandName.toLowerCase().equals("exit")) {
            skipMethod = true;
        }
        return skipMethod;
    }

    private Object[] getConvertedArgs() throws WrongNumberOfArgumentsException, ArgumentConversionException {
        String message;
        Object[] params;
        Class<?> lastArgType;
        String[] stringArray;
        Class<?>[] neededTypes = this.method.getParameterTypes();
        if (neededTypes.length == 1 && neededTypes[0] == (stringArray = new String[0]).getClass()) {
            return new Object[]{this.args};
        }
        boolean skipLast = false;
        Object lastArg = null;
        if (neededTypes.length > 0 && (lastArgType = neededTypes[neededTypes.length - 1]).isArray()) {
            Object[] tempLastArg = new Object[this.args.length - (neededTypes.length - 1)];
            for (int i = neededTypes.length - 1; i < this.args.length; ++i) {
                tempLastArg[i - (neededTypes.length - 1)] = this.convert(this.args[i], lastArgType.getComponentType());
            }
            skipLast = true;
            lastArg = this.convertArray(tempLastArg, lastArgType.getComponentType());
        }
        if (skipLast) {
            if (neededTypes.length > this.args.length) {
                params = new Object[]{new Integer(neededTypes.length), new Integer(this.args.length)};
                message = CorePlugin.Util.getString("Command.Argument_count_mis-match,_expected_{0}_but_received_{1}", params);
                throw new WrongNumberOfArgumentsException(message);
            }
        } else if (neededTypes.length != this.args.length) {
            params = new Object[]{new Integer(neededTypes.length), new Integer(this.args.length)};
            message = CorePlugin.Util.getString("Command.Argument_count_mis-match,_expected_{0}_but_received_{1}", params);
            throw new WrongNumberOfArgumentsException(message);
        }
        Object[] result = new Object[neededTypes.length];
        if (skipLast) {
            for (int i = 0; i < neededTypes.length - 1; ++i) {
                result[i] = this.convert(this.args[i], neededTypes[i]);
            }
            result[neededTypes.length - 1] = lastArg;
        } else {
            for (int i = 0; i < neededTypes.length; ++i) {
                result[i] = this.convert(this.args[i], neededTypes[i]);
            }
        }
        return result;
    }

    private Object convertArray(Object[] input, Class targetType) {
        Object result = Array.newInstance(targetType, input.length);
        for (int i = 0; i < input.length; ++i) {
            Array.set(result, i, input[i]);
        }
        return result;
    }

    private void handleFileException(String target, Throwable exception) throws ArgumentConversionException {
        String message = CorePlugin.Util.getString("Command.Error_processing_file", target);
        throw new ArgumentConversionException(exception, message);
    }

    private Object convert(String target, Class neededType) throws ArgumentConversionException {
        if (neededType.equals(class$java$lang$String == null ? (class$java$lang$String = Command.class$("java.lang.String")) : class$java$lang$String)) {
            return target;
        }
        byte[] x = new byte[0];
        if (neededType.equals(x.getClass())) {
            String fileName = this.defaultFilePath + target;
            FileUtil file = new FileUtil(fileName);
            try {
                return file.readBytesSafe();
            }
            catch (FileNotFoundException e) {
                this.handleFileException(target, e);
            }
            catch (IOException e) {
                this.handleFileException(target, e);
            }
        }
        if (neededType.equals(class$java$util$Date == null ? (class$java$util$Date = Command.class$("java.util.Date")) : class$java$util$Date)) {
            try {
                return DateUtil.convertStringToDate(target);
            }
            catch (ParseException e) {
                throw new ArgumentConversionException((Throwable)e, e.getMessage());
            }
        }
        if (neededType.equals(Integer.TYPE)) {
            return new Integer(target);
        }
        if (neededType.equals(Boolean.TYPE)) {
            return new Boolean(target);
        }
        if (neededType.equals(class$java$util$Properties == null ? (class$java$util$Properties = Command.class$("java.util.Properties")) : class$java$util$Properties)) {
            Properties result = new Properties();
            String[] subStrings = StringUtil.split(target, ",=").toArray(new String[0]);
            for (int i = 0; i < subStrings.length; i += 2) {
                result.put(subStrings[i], subStrings[i + 1]);
            }
            return result;
        }
        if (neededType.equals(class$com$metamatrix$core$id$ObjectID == null ? (class$com$metamatrix$core$id$ObjectID = Command.class$("com.metamatrix.core.id.ObjectID")) : class$com$metamatrix$core$id$ObjectID)) {
            if (target != null) {
                try {
                    if (target.equals("null")) {
                        return null;
                    }
                    return IDGenerator.getInstance().stringToObject(target);
                }
                catch (InvalidIDException e) {
                    throw new ArgumentConversionException((Throwable)((Object)e), e.getMessage());
                }
            }
            return null;
        }
        char[] charArray = new char[0];
        if (neededType.equals(charArray.getClass())) {
            String fileName = this.defaultFilePath + target;
            FileUtil file = new FileUtil(fileName);
            try {
                return file.readSafe().toCharArray();
            }
            catch (FileNotFoundException e) {
                this.handleFileException(target, e);
            }
        }
        String message = CorePlugin.Util.getString("Command.Cannot_convert_to", neededType);
        throw new MetaMatrixRuntimeException(message);
    }

    public Object execute() throws NoSuchMethodException, WrongNumberOfArgumentsException, ArgumentConversionException {
        return this.execute(Collections.EMPTY_SET);
    }

    public Object execute(Set methodsToIgnore) throws NoSuchMethodException, WrongNumberOfArgumentsException, ArgumentConversionException {
        if (this.commandName == null) {
            return null;
        }
        this.getMethod(methodsToIgnore);
        try {
            return this.method.invoke(this.target, this.getConvertedArgs());
        }
        catch (IllegalArgumentException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof MetaMatrixRuntimeException) {
                throw (MetaMatrixRuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new MetaMatrixRuntimeException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

