/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.Debugger;
import com.metamatrix.core.util.DebuggerImpl;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.internal.core.log.EclipsePlatformLogListener;
import com.metamatrix.internal.core.log.PlatformLog;
import com.metamatrix.internal.core.log.PluginLogger;
import com.metamatrix.internal.core.text.MessageFormat;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class PluginUtilImpl
implements PluginUtil {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(class$com$metamatrix$core$util$PluginUtilImpl == null ? (class$com$metamatrix$core$util$PluginUtilImpl = PluginUtilImpl.class$("com.metamatrix.core.util.PluginUtilImpl")) : class$com$metamatrix$core$util$PluginUtilImpl);
    private static final String JAVA_VERSION = "java.version";
    private static final String VERSION_DELIMITERS = "._- ";
    public static final String RESOURCE_FILE_ROOT = "i18n";
    private static final String INVALID_JAVA_VERSION_MESSAGE_ID = "invalidJavaVersionMessage";
    private DefaultRunner runner = new DefaultRunner();
    private final String bundleName;
    private final ResourceBundle bundle;
    private final PluginLogger logger;
    private final Debugger debugger;
    private final String pluginId;
    static /* synthetic */ Class class$com$metamatrix$core$util$PluginUtilImpl;

    public PluginUtilImpl(String pluginId) {
        this(pluginId, pluginId + ".i18n", ResourceBundle.getBundle(pluginId + ".i18n"));
    }

    public PluginUtilImpl(String pluginID, ResourceBundle bundle) {
        this(pluginID, "i18n.i18n", bundle);
    }

    public PluginUtilImpl(String pluginId, String bundleName, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.bundleName = bundleName;
        this.bundle = bundle;
        this.logger = new PluginLogger(pluginId, PlatformLog.getInstance());
        this.debugger = new DebuggerImpl(pluginId);
    }

    public void initializePlatformLogger(Plugin plugin) {
        EclipsePlatformLogListener newListener = new EclipsePlatformLogListener(plugin);
        PlatformLog.getInstance().addListener(newListener);
        this.runner = new PlatformRunner();
    }

    public void checkJre(String version) throws CoreException {
        String ver = System.getProperty(JAVA_VERSION);
        StringTokenizer verIter = new StringTokenizer(ver, VERSION_DELIMITERS);
        boolean invalid = false;
        StringTokenizer minVerIter = new StringTokenizer(version, VERSION_DELIMITERS);
        while (minVerIter.hasMoreTokens()) {
            int minLvl;
            if (!verIter.hasMoreTokens()) {
                invalid = true;
                break;
            }
            int lvl = Integer.parseInt(verIter.nextToken());
            if (lvl > (minLvl = Integer.parseInt(minVerIter.nextToken()))) {
                return;
            }
            if (lvl >= minLvl) continue;
            invalid = true;
            break;
        }
        if (invalid) {
            String plugin = Platform.getBundle((String)this.pluginId).getSymbolicName();
            String msg = CorePlugin.Util.getString(I18N_PREFIX + INVALID_JAVA_VERSION_MESSAGE_ID, plugin, version, ver);
            Status status = new Status(4, "com.metamatrix.core", 0, msg, null);
            throw new CoreException((IStatus)status);
        }
    }

    public void debug(String context, String message) {
        this.debugger.debug(context, message);
    }

    public String getDebugContextProperty(String property) {
        return this.debugger.getDebugContextProperty(property);
    }

    public String getString(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (Exception err) {
            String msg = err instanceof NullPointerException ? "<No message available>" : (err instanceof MissingResourceException ? "<Missing message for key \"" + key + "\" in: " + this.bundleName + '>' : err.getLocalizedMessage());
            return msg;
        }
    }

    public String getString(String key, List parameters) {
        if (parameters == null) {
            return this.getString(key);
        }
        return this.getString(key, parameters.toArray());
    }

    public String getString(String key, boolean parameter) {
        return this.getString(key, new Boolean(parameter));
    }

    public String getString(String key, byte parameter) {
        return this.getString(key, new Byte(parameter));
    }

    public String getString(String key, char parameter) {
        return this.getString(key, new Character(parameter));
    }

    public String getString(String key, double parameter) {
        return this.getString(key, new Double(parameter));
    }

    public String getString(String key, float parameter) {
        return this.getString(key, new Float(parameter));
    }

    public String getString(String key, int parameter) {
        return this.getString(key, new Integer(parameter));
    }

    public String getString(String key, long parameter) {
        return this.getString(key, new Long(parameter));
    }

    public String getString(String key, Object parameter) {
        if (parameter != null) {
            if (parameter.getClass().isArray()) {
                return this.getString(key, (Object[])parameter);
            }
            if (parameter instanceof List) {
                return this.getString(key, (List)parameter);
            }
        }
        return this.getString(key, new Object[]{parameter});
    }

    public String getString(String key, Object parameter1, Object parameter2) {
        return this.getString(key, new Object[]{parameter1, parameter2});
    }

    public String getString(String key, Object parameter1, Object parameter2, Object parameter3) {
        return this.getString(key, new Object[]{parameter1, parameter2, parameter3});
    }

    public String getString(String key, Object[] parameters) {
        String text = this.getString(key);
        if (text == null) {
            return '<' + key + '>';
        }
        if (parameters == null || parameters.length == 0) {
            return text;
        }
        return MessageFormat.format(text, parameters);
    }

    public String getString(String key, short parameter) {
        return this.getString(key, new Short(parameter));
    }

    public String getStringOrKey(String key) {
        ArgCheck.isNotNull(key);
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException err) {
            return key;
        }
    }

    public String getTraceContextProperty(String property) {
        return this.debugger.getTraceContextProperty(property);
    }

    public boolean isDebugEnabled(String context) {
        return this.debugger.isDebugEnabled(context);
    }

    public boolean isTraceEnabled(String context) {
        return this.debugger.isTraceEnabled(context);
    }

    public boolean isTraceEnabled(Class clazz) {
        return this.debugger.isTraceEnabled(clazz);
    }

    public boolean isTraceEnabled(Object object) {
        return this.debugger.isTraceEnabled(object);
    }

    public boolean keyExists(String key) {
        try {
            return this.bundle.getString(key) != null;
        }
        catch (Exception err) {
            return false;
        }
    }

    public void log(IStatus status) {
        this.logger.log(status);
    }

    public void log(int severity, String message) {
        this.logger.log(severity, message);
    }

    public void log(int severity, Throwable t, String message) {
        this.logger.log(severity, t, message);
    }

    public void log(Object obj) {
        this.logger.log(obj);
    }

    public void log(Throwable throwable) {
        this.logger.log(throwable);
    }

    public void print(String context, String message) {
        this.debugger.print(context, message);
    }

    public void print(Class clazz, String message) {
        this.debugger.print(clazz, message);
    }

    public void print(Object object, String message) {
        this.debugger.print(object, message);
    }

    public void printEntered(String context, String message) {
        this.debugger.printEntered(context, message);
    }

    public void printEntered(Class clazz, String message) {
        this.debugger.printEntered(clazz, message);
    }

    public void printEntered(Object object, String message) {
        this.debugger.printEntered(object, message);
    }

    public void printExited(String context, String message) {
        this.debugger.printExited(context, message);
    }

    public void printExited(Class clazz, String message) {
        this.debugger.printExited(clazz, message);
    }

    public void printExited(Object object, String message) {
        this.debugger.printExited(object, message);
    }

    public void run(ISafeRunnable runnable) {
        this.runner.run(runnable);
    }

    public void start(String theTimerId) {
        this.debugger.start(theTimerId);
    }

    public void start(String theTimerId, String theContextId) {
        this.debugger.start(theTimerId, theContextId);
    }

    public void start(String theTimerId, String theContextId, Object[] theInfo) {
        this.debugger.start(theTimerId, theContextId, theInfo);
    }

    public void stop(String theTimerId) {
        this.debugger.stop(theTimerId);
    }

    public void stop(String theTimerId, String theContextId) {
        this.debugger.stop(theTimerId, theContextId);
    }

    public void stop(String theTimerId, String theContextId, Object[] theInfo) {
        this.debugger.stop(theTimerId, theContextId, theInfo);
    }

    public void trace(String context, String message) {
        this.debugger.trace(context, message);
    }

    public void trace(Class clazz, String message) {
        this.debugger.trace(clazz, message);
    }

    public void trace(Object object, String message) {
        this.debugger.trace(object, message);
    }

    public void traceEntered(String context, String message) {
        this.debugger.traceEntered(context, message);
    }

    public void traceEntered(Class clazz, String message) {
        this.debugger.traceEntered(clazz, message);
    }

    public void traceEntered(Object object, String message) {
        this.debugger.traceEntered(object, message);
    }

    public void traceExited(String context, String message) {
        this.debugger.traceExited(context, message);
    }

    public void traceExited(Class clazz, String message) {
        this.debugger.traceExited(clazz, message);
    }

    public void traceExited(Object object, String message) {
        this.debugger.traceExited(object, message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PlatformRunner
    extends DefaultRunner {
        protected PlatformRunner() {
        }

        public void run(ISafeRunnable code) {
            ISafeRunnable wrapper = new ISafeRunnable(this, code){
                private final /* synthetic */ ISafeRunnable val$code;
                private final /* synthetic */ PlatformRunner this$1;
                {
                    this.this$1 = this$1;
                    this.val$code = val$code;
                }

                public void handleException(Throwable exception) {
                    String message = PlatformRunner.access$100(this.this$1).getString("PluginUtilImpl.Error_while_running", PluginUtilImpl.access$000(PlatformRunner.access$100(this.this$1)));
                    PlatformRunner.access$100(this.this$1).log(4, message);
                    this.val$code.handleException(exception);
                }

                public void run() throws Exception {
                    Platform.run((ISafeRunnable)this.val$code);
                }
            };
            Platform.run((ISafeRunnable)wrapper);
        }

        static /* synthetic */ PluginUtilImpl access$100(PlatformRunner x0) {
            return x0.PluginUtilImpl.this;
        }
    }

    protected class DefaultRunner {
        protected DefaultRunner() {
        }

        public void run(ISafeRunnable code) {
            Assertion.isNotNull(code);
            try {
                code.run();
            }
            catch (Exception e) {
                this.handleException(code, e);
            }
            catch (LinkageError e) {
                this.handleException(code, e);
            }
        }

        private void handleException(ISafeRunnable code, Throwable e) {
            if (!(e instanceof OperationCanceledException)) {
                String pluginId = PluginUtilImpl.this.pluginId;
                String message = PluginUtilImpl.this.getString("PluginUtilImpl.Error_while_running", pluginId);
                MultiStatus status = null;
                if (e instanceof CoreException) {
                    status = new MultiStatus(pluginId, 2, message, e);
                    status.merge(((CoreException)e).getStatus());
                } else {
                    status = new Status(4, pluginId, 2, message, e);
                }
                PluginUtilImpl.this.log((IStatus)status);
            }
            code.handleException(e);
        }
    }
}

