/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.service;

import com.metamatrix.soap.service.ConnectionPoolFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicConnectionPoolFactory
implements ConnectionPoolFactory {
    private static final Properties defaultProperties = new Properties();
    public static final String MMPOOL_PROPERTIES_FILENAME = "/mmpool.properties";
    static /* synthetic */ Class class$com$metamatrix$soap$service$BasicConnectionPoolFactory;

    public DataSource createConnectionPool(Properties poolProperties) {
        if (poolProperties == null) {
            return null;
        }
        Properties mergedProperties = BasicConnectionPoolFactory.createMergedProperties(poolProperties);
        BasicDataSource pool = new BasicDataSource();
        pool.setDriverClassName(mergedProperties.getProperty("DriverClass"));
        pool.setUsername(mergedProperties.getProperty("Username"));
        pool.setPassword(mergedProperties.getProperty("Password"));
        pool.setUrl(mergedProperties.getProperty("ServerURL"));
        pool.setInitialSize(Integer.parseInt(mergedProperties.getProperty("com.metamatrix.soap.service.initpoolsize")));
        pool.setMaxActive(Integer.parseInt(mergedProperties.getProperty("com.metamatrix.soap.service.maxactiveconnections")));
        pool.setMaxIdle(Integer.parseInt(mergedProperties.getProperty("com.metamatrix.soap.service.maxidleconnections")));
        pool.setMaxWait((long)Integer.parseInt(mergedProperties.getProperty("com.metamatrix.soap.service.maxwait")));
        pool.setMinIdle(Integer.parseInt(mergedProperties.getProperty("com.metamatrix.soap.service.minidlecount")));
        pool.setTimeBetweenEvictionRunsMillis((long)Integer.parseInt(mergedProperties.getProperty("com.metamatrix.soap.service.timebetweenevictionthreadruns")));
        pool.setMinEvictableIdleTimeMillis((long)Integer.parseInt(mergedProperties.getProperty("com.metamatrix.soap.service.minevictableidletime")));
        pool.setTestWhileIdle(true);
        return pool;
    }

    protected static Properties createMergedProperties(Properties poolProperties) {
        Properties mergedProperties = new Properties(defaultProperties);
        mergedProperties.putAll((Map<?, ?>)BasicConnectionPoolFactory.getMMPoolProperties());
        mergedProperties.putAll((Map<?, ?>)System.getProperties());
        mergedProperties.putAll((Map<?, ?>)poolProperties);
        return mergedProperties;
    }

    protected static Properties getMMPoolProperties() {
        Properties p = new Properties();
        InputStream is = (class$com$metamatrix$soap$service$BasicConnectionPoolFactory == null ? (class$com$metamatrix$soap$service$BasicConnectionPoolFactory = BasicConnectionPoolFactory.class$("com.metamatrix.soap.service.BasicConnectionPoolFactory")) : class$com$metamatrix$soap$service$BasicConnectionPoolFactory).getClassLoader().getResourceAsStream(MMPOOL_PROPERTIES_FILENAME);
        if (is != null) {
            try {
                p.load(is);
            }
            catch (IOException ioe) {
                return new Properties();
            }
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultProperties.setProperty("com.metamatrix.soap.service.initpoolsize", String.valueOf(1));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxactiveconnections", String.valueOf(25));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxidleconnections", String.valueOf(10));
        defaultProperties.setProperty("com.metamatrix.soap.service.maxwait", String.valueOf(30000));
        defaultProperties.setProperty("com.metamatrix.soap.service.minidlecount", String.valueOf(0));
        defaultProperties.setProperty("com.metamatrix.soap.service.minevictableidletime", String.valueOf(600000));
        defaultProperties.setProperty("com.metamatrix.soap.service.timebetweenevictionthreadruns", String.valueOf(60000));
        defaultProperties.setProperty("DriverClass", "com.metamatrix.jdbc.MMDriver");
    }
}

