/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.service;

import com.metamatrix.jdbc.MMClob;
import com.metamatrix.jdbc.api.DatabaseMetaData;
import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.helper.SOAPAuthentication;
import com.metamatrix.soap.helper.SOAPColumn;
import com.metamatrix.soap.helper.SOAPConfiguration;
import com.metamatrix.soap.helper.SOAPConnection;
import com.metamatrix.soap.helper.SOAPDataValueWrapper;
import com.metamatrix.soap.helper.SOAPException;
import com.metamatrix.soap.helper.SOAPResultSet;
import com.metamatrix.soap.helper.SOAPRow;
import com.metamatrix.soap.helper.SOAPStoredProcedureResult;
import com.metamatrix.soap.license.LicenseInfo;
import com.metamatrix.soap.log.MMSOAPlatformLog;
import com.metamatrix.soap.service.MMSoapConnectionController;
import com.metamatrix.soap.util.XMLTranslator;
import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;

public class MetaMatrixServerAPI {
    private static final String VDB_NAME = "VirtualDatabaseName";
    private static final String VDB_VERSION = "VirtualDatabaseVersion";
    private static final String SERVER_URL = "serverURL";
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private static final String CREDENTIALS = "credentials";
    private static final boolean isLicensed = LicenseInfo.getInstance().isSOAPAPILicensed();
    private static final SOAPConfiguration CONFIG = new SOAPConfiguration();
    private XMLTranslator translator = new XMLTranslator();
    private static final int METADATA_CROSS_REFERENCES = 1;
    private static final int METADATA_DATA_TYPES = 2;
    private static final int METADATA_ELEMENTS = 3;
    private static final int METADATA_EXPORTED_KEYS = 4;
    private static final int METADATA_FOREIGN_KEYS = 5;
    private static final int METADATA_GROUPS = 6;
    private static final int METADATA_IMPORTED_KEYS = 7;
    private static final int METADATA_MODELS = 8;
    private static final int METADATA_PRIMARY_KEYS = 9;
    private static final int METADATA_PROCEDURE_PARAMETERS = 10;
    private static final int METADATA_PROCEDURES = 11;
    private static final int METADATA_USER_DEFINED_DATA_TYPES = 12;
    private static final int METADATA_VIRTUAL_DATABASES = 13;

    public SOAPResultSet getCrossReferences(SOAPAuthentication authentication, String primaryGroupNameCriteriaPattern, String foreignGroupNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 1, fullMetadata, primaryGroupNameCriteriaPattern, foreignGroupNameCriteriaPattern);
    }

    public SOAPResultSet getDataTypes(SOAPAuthentication authentication, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 2, fullMetadata, null, null);
    }

    public SOAPResultSet getElements(SOAPAuthentication authentication, String elementNameCriteriaPattern, String groupNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 3, fullMetadata, elementNameCriteriaPattern, groupNameCriteriaPattern);
    }

    public SOAPResultSet getExportedKeys(SOAPAuthentication authentication, String groupNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 4, fullMetadata, groupNameCriteriaPattern, null);
    }

    public SOAPResultSet getForeignKeys(SOAPAuthentication authentication, String groupNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 5, fullMetadata, groupNameCriteriaPattern, null);
    }

    public SOAPResultSet getGroups(SOAPAuthentication authentication, String groupNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 6, fullMetadata, groupNameCriteriaPattern, null);
    }

    public SOAPResultSet getImportedKeys(SOAPAuthentication authentication, String groupNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 7, fullMetadata, groupNameCriteriaPattern, null);
    }

    public SOAPResultSet getModels(SOAPAuthentication authentication, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 8, fullMetadata, null, null);
    }

    public SOAPResultSet getPrimaryKeys(SOAPAuthentication authentication, String groupNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 9, fullMetadata, groupNameCriteriaPattern, null);
    }

    public SOAPResultSet getProcedureParameters(SOAPAuthentication authentication, String procedureNameCriteriaPattern, String parameterNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 10, fullMetadata, procedureNameCriteriaPattern, parameterNameCriteriaPattern);
    }

    public SOAPResultSet getProcedures(SOAPAuthentication authentication, String procedureNameCriteriaPattern, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 11, fullMetadata, procedureNameCriteriaPattern, null);
    }

    public SOAPResultSet getUserDefinedDataTypes(SOAPAuthentication authentication, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 12, fullMetadata, null, null);
    }

    public SOAPResultSet getVirtualDatabases(SOAPAuthentication authentication, boolean fullMetadata) throws SOAPException {
        return this.getMetadata(authentication, 13, fullMetadata, null, null);
    }

    /*
     * Loose catch block
     */
    private SOAPResultSet getMetadata(SOAPAuthentication authentication, int metadataType, boolean fullMetadata, String nameCriteria1, String nameCriteria2) throws SOAPException {
        SOAPResultSet soapResultSet;
        block11: {
            ResultSet rs;
            block10: {
                if (!isLicensed) {
                    MMSOAPlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
                    throw new SOAPException(LicenseInfo.getErrorMessage());
                }
                soapResultSet = null;
                rs = null;
                SOAPConnection connection = this.getConnection(authentication);
                java.sql.DatabaseMetaData metadata = connection.getConnection().getMetaData();
                rs = this.queryMetadataType(metadataType, metadata, nameCriteria1, nameCriteria2);
                if (rs == null) break block10;
                this.checkResult(rs);
                soapResultSet = this.translateResultSet(rs, fullMetadata);
            }
            Object var12_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                break block11;
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                MMSOAPlatformLog.getInstance().getLogFile().log(2, (Throwable)sqle, SOAPPlugin.Util.getString("MMSoapQueryService.Exception_when_attempting_to_close_the_ResultSet_2"));
            }
            break block11;
            {
                catch (Exception e) {
                    Object[] params = new Object[]{e};
                    String msg = SOAPPlugin.Util.getString("ERR.018.002.0005", params);
                    MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
                    throw new SOAPException("Server.QueryExecution: " + msg);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                    MMSOAPlatformLog.getInstance().getLogFile().log(2, (Throwable)sqle, SOAPPlugin.Util.getString("MMSoapQueryService.Exception_when_attempting_to_close_the_ResultSet_2"));
                }
                throw throwable;
            }
        }
        return soapResultSet;
    }

    private ResultSet queryMetadataType(int metadataType, java.sql.DatabaseMetaData metadata, String nameCriteria1, String nameCriteria2) throws SQLException {
        ResultSet rs = null;
        switch (metadataType) {
            case 1: {
                rs = metadata.getCrossReference(null, null, nameCriteria1, null, null, nameCriteria2);
                break;
            }
            case 2: {
                rs = metadata.getTypeInfo();
                break;
            }
            case 3: {
                rs = metadata.getColumns(null, null, nameCriteria2, nameCriteria1);
                break;
            }
            case 4: {
                rs = metadata.getExportedKeys(null, null, nameCriteria1);
                break;
            }
            case 5: {
                rs = metadata.getExportedKeys(null, null, nameCriteria1);
                break;
            }
            case 6: {
                rs = metadata.getTables(null, null, nameCriteria1, null);
                break;
            }
            case 7: {
                rs = metadata.getImportedKeys(null, null, nameCriteria1);
                break;
            }
            case 8: {
                rs = ((DatabaseMetaData)metadata).getModels(null, null, nameCriteria1);
                break;
            }
            case 9: {
                rs = metadata.getPrimaryKeys(null, null, nameCriteria1);
                break;
            }
            case 10: {
                rs = metadata.getProcedureColumns(null, null, nameCriteria1, nameCriteria2);
                break;
            }
            case 11: {
                rs = metadata.getProcedures(null, null, nameCriteria1);
                break;
            }
            case 12: {
                rs = metadata.getUDTs(null, null, "%", null);
                break;
            }
            case 13: {
                rs = metadata.getSchemas();
            }
        }
        return rs;
    }

    private void logOffMetaMatrixServer(SOAPConnection connection, boolean error) throws SQLException, SOAPException {
        MMSoapConnectionController controller = MMSoapConnectionController.instance();
        if (connection.isAnonymous()) {
            boolean badConnection = false;
            if (error) {
                badConnection = !controller.testQuery(connection.getConnection(), "Select 1");
            }
            controller.releaseAnonymousConnection(connection, badConnection);
        } else if (connection.getSessionID() == null) {
            connection.logoff();
        } else {
            controller.updateAccessTime(connection.getSessionID());
        }
    }

    private void checkResult(ResultSet rs) throws SQLException {
        SQLWarning w = rs.getWarnings();
        if (w != null) {
            throw w;
        }
    }

    public String logon(SOAPAuthentication authorization) throws SOAPException {
        if (!isLicensed) {
            MMSOAPlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            throw new SOAPException(LicenseInfo.getErrorMessage());
        }
        MMSoapConnectionController controller = MMSoapConnectionController.instance();
        SOAPConnection connection = null;
        try {
            connection = this.getConnection(authorization);
        }
        catch (SQLException e) {
            Object[] params = new Object[]{e};
            String msg = SOAPPlugin.Util.getString("ERR.018.002.0006", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
            throw new SOAPException("Server.Connection: " + msg);
        }
        if (connection.isAnonymous()) {
            throw new SOAPException("Client: " + SOAPPlugin.Util.getString("ERR.018.002.0007"));
        }
        controller.logon(connection);
        return connection.getSessionID();
    }

    public void logoff(String sessionID) throws SOAPException {
        MMSoapConnectionController controller;
        if (!isLicensed) {
            MMSOAPlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            throw new SOAPException(LicenseInfo.getErrorMessage());
        }
        try {
            controller = MMSoapConnectionController.instance();
        }
        catch (Exception e) {
            Object[] params = new Object[]{e};
            String msg = SOAPPlugin.Util.getString("ERR.018.002.0008", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
            throw new SOAPException("Server.Connection: " + msg);
        }
        try {
            controller.logoff(sessionID);
        }
        catch (Exception e) {
            Object[] params = new Object[]{e};
            String msg = SOAPPlugin.Util.getString("ERR.018.002.0009", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
            throw new SOAPException("Server.Connection: " + msg);
        }
    }

    public SOAPResultSet submitQuery(SOAPAuthentication authentication, int fetchsize, int timeout, boolean partialResults, boolean fullMetadata, String sql) throws SOAPException {
        boolean error = false;
        if (!isLicensed) {
            MMSOAPlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            throw new SOAPException(LicenseInfo.getErrorMessage());
        }
        SOAPConnection connection = null;
        Statement query = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(authentication);
            query = connection.getConnection().createStatement();
            query.setFetchSize(fetchsize);
            query.setQueryTimeout(timeout);
            resultSet = query.executeQuery(sql);
            this.checkResult(resultSet);
            SOAPResultSet sOAPResultSet = this.translateResultSet(resultSet, fullMetadata);
            this.close(resultSet, query, connection, error);
            return sOAPResultSet;
        }
        catch (Exception e) {
            try {
                error = true;
                Object[] params = new Object[]{e};
                String msg = SOAPPlugin.Util.getString("ERR.018.011.0022", params);
                MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
                throw new SOAPException("Server.QueryExecution: " + msg);
            }
            catch (Throwable throwable) {
                this.close(resultSet, query, connection, error);
                throw throwable;
            }
        }
    }

    private void close(ResultSet rs, Statement stmt, SOAPConnection conn, boolean error) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                MMSOAPlatformLog.getInstance().getLogFile().log(2, (Throwable)e, SOAPPlugin.Util.getString("MMSoapQueryService.Exception_when_attempting_to_close_the_ResultSet_2"));
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                MMSOAPlatformLog.getInstance().getLogFile().log(2, (Throwable)e, SOAPPlugin.Util.getString("MMSoapQueryService.Exception_when_attempting_to_close_the_statement._1"));
            }
        }
        if (conn != null) {
            try {
                this.logOffMetaMatrixServer(conn, error);
            }
            catch (Exception e) {
                MMSOAPlatformLog.getInstance().getLogFile().log(2, (Throwable)e, SOAPPlugin.Util.getString("MMSoapQueryService.Exception_when_attempting_to_close_the_connection._2"));
            }
        }
    }

    public int submitUpdate(SOAPAuthentication authentication, String sql) throws SOAPException {
        boolean error = false;
        if (!isLicensed) {
            MMSOAPlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            throw new SOAPException(LicenseInfo.getErrorMessage());
        }
        SOAPConnection connection = null;
        Statement stmt = null;
        try {
            int rowsAffected;
            connection = this.getConnection(authentication);
            stmt = connection.getConnection().createStatement();
            int n = rowsAffected = stmt.executeUpdate(sql);
            return n;
        }
        catch (Exception e) {
            error = true;
            Object[] params = new Object[]{e};
            String msg = SOAPPlugin.Util.getString("ERR.018.011.0023", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
            throw new SOAPException("Server.UpdateExecution: " + msg);
        }
        finally {
            this.close(null, stmt, connection, error);
        }
    }

    public String submitXMLSchemaRequest(SOAPAuthentication authentication, String schemaName, String documentName) throws SOAPException {
        boolean error = false;
        if (!isLicensed) {
            MMSOAPlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            throw new SOAPException(LicenseInfo.getErrorMessage());
        }
        String resultsString = null;
        SOAPConnection connection = null;
        Element resultsElement = null;
        java.sql.DatabaseMetaData metadata = null;
        List schemas = null;
        try {
            connection = this.getConnection(authentication);
            metadata = connection.getConnection().getMetaData();
            if (documentName == null) {
                throw new SOAPException("Client.QueryExecution: " + SOAPPlugin.Util.getString("MMSoapQueryService.document_name_cannot_be_null_2"));
            }
            schemas = ((DatabaseMetaData)metadata).getXMLSchemas(documentName);
        }
        catch (Exception e) {
            error = true;
            Object[] params = new Object[]{e};
            String msg = SOAPPlugin.Util.getString("MMSoapQueryService.Unable_to_get_metadata_data_types___{0}_4", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
            throw new SOAPException("Server.QueryExecution: " + msg);
        }
        try {
            if (schemas != null) {
                resultsElement = this.translator.translateXMLSchemas(null, schemas);
                resultsString = this.translator.translateElementToString(resultsElement);
            }
        }
        catch (Exception ste) {
            Object[] params = new Object[]{ste};
            String msg = SOAPPlugin.Util.getString("MetaMatrixServerAPI.Unable_to_get_xml_schemas___{0}", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)ste, msg);
            throw new SOAPException("Server.Translation: " + msg);
        }
        finally {
            this.close(null, null, connection, error);
        }
        return resultsString;
    }

    public SOAPStoredProcedureResult submitStoredProcedure(SOAPAuthentication authentication, String sql, Object[] parameters, int timeout, boolean fullMetadata) throws SOAPException {
        boolean error = false;
        if (!isLicensed) {
            MMSOAPlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            throw new SOAPException(LicenseInfo.getErrorMessage());
        }
        if (sql == null) {
            throw new SOAPException("Client.StoredProcedureExecution: " + SOAPPlugin.Util.getString("ERR.018.002.0010"));
        }
        SOAPConnection connection = null;
        ResultSet resultSet = null;
        CallableStatement sp = null;
        SOAPStoredProcedureResult result = new SOAPStoredProcedureResult();
        try {
            connection = this.getConnection(authentication);
            sp = connection.getConnection().prepareCall(sql, 1004, 1007);
            if (parameters != null) {
                for (int param = 0; param < parameters.length; ++param) {
                    try {
                        sp.setObject(param + 1, parameters[param]);
                        continue;
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            sp.setQueryTimeout(timeout);
            sp.execute();
            resultSet = sp.getResultSet();
            if (resultSet != null) {
                this.checkResult(resultSet);
                result.setResultSet(this.translateResultSet(resultSet, fullMetadata));
            }
            ArrayList<Object> resultParams = null;
            if (parameters == null) {
                resultParams = new ArrayList<Object>(1);
                try {
                    resultParams.add(sp.getObject(1));
                }
                catch (Exception e) {}
            } else {
                int paramResults = parameters.length + 1;
                resultParams = new ArrayList(paramResults);
                for (int param = 1; param <= paramResults; ++param) {
                    try {
                        resultParams.add(sp.getObject(param));
                        continue;
                    }
                    catch (Exception e) {
                        resultParams.add(null);
                    }
                }
            }
            result.setParams(resultParams.toArray(new Object[resultParams.size()]));
            SOAPStoredProcedureResult paramResults = result;
            this.close(resultSet, sp, connection, error);
            return paramResults;
        }
        catch (Exception e) {
            try {
                error = true;
                Object[] params = new Object[]{e};
                String msg = SOAPPlugin.Util.getString("ERR.018.011.0021", params);
                MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
                throw new SOAPException("Server.StoredProcedureExecution" + msg);
            }
            catch (Throwable throwable) {
                this.close(resultSet, sp, connection, error);
                throw throwable;
            }
        }
    }

    private synchronized SOAPConnection getConnection(SOAPAuthentication userToken) throws SQLException, SOAPException {
        MMSoapConnectionController controller = MMSoapConnectionController.instance();
        SOAPConnection soapConnection = null;
        if (userToken.isAnonymous()) {
            soapConnection = controller.acquireAnonymousConnection();
            if (soapConnection == null) {
                userToken.setIsEncrypted(CONFIG.getIsEncrypted());
                userToken.setPassword(CONFIG.getAnonymousPassword());
                userToken.setServerURL(CONFIG.getAnonymousServerURL());
                userToken.setUserName(CONFIG.getAnonymousUserName());
                userToken.setVDB(CONFIG.getAnonymousVDB());
                userToken.setVdbVersion(CONFIG.getAnonymousVDBVersion());
                soapConnection = controller.acquireNewAnonymousConnection(this.establishConnection(userToken));
            }
        } else if (userToken.getSessionID() != null) {
            String sessionID = userToken.getSessionID();
            soapConnection = controller.acquireSOAPConnection(sessionID);
            if (soapConnection == null) {
                throw new SOAPException("Client.Authentication: " + SOAPPlugin.Util.getString("ERR.018.002.0016"));
            }
        } else {
            Connection connection = this.establishConnection(userToken);
            soapConnection = new SOAPConnection(connection, false);
            controller.logon(soapConnection);
        }
        return soapConnection;
    }

    private Connection establishConnection(SOAPAuthentication userToken) throws SOAPException {
        Connection connection = null;
        try {
            Class.forName("com.metamatrix.jdbc.MMDriver");
        }
        catch (ClassNotFoundException err) {
            err.printStackTrace();
        }
        try {
            MetaMatrixServerAPI.addApplicationNameProperty(userToken);
            connection = DriverManager.getConnection(userToken.getServerURL(), MetaMatrixServerAPI.getAuthenticationProperties(userToken));
        }
        catch (Exception e) {
            Object[] params = new Object[]{e};
            String msg = SOAPPlugin.Util.getString("ERR.018.002.0019", params);
            MMSOAPlatformLog.getInstance().getLogFile().log(4, (Throwable)e, msg);
            throw new SOAPException("Server.Authentication: " + msg);
        }
        return connection;
    }

    private static Properties getAuthenticationProperties(SOAPAuthentication auth) {
        Properties props = new Properties();
        if (auth.getServerURL() != null) {
            props.setProperty(SERVER_URL, auth.getServerURL());
        }
        if (auth.getUserName() != null) {
            props.setProperty(USER_NAME, auth.getUserName());
        }
        if (auth.getPassword() != null) {
            props.setProperty(PASSWORD, auth.getPassword());
        }
        if (auth.getTrustedString() != null) {
            props.setProperty(CREDENTIALS, auth.getTrustedString());
        }
        if (auth.getVDB() != null) {
            props.setProperty(VDB_NAME, auth.getVDB());
        }
        if (auth.getVdbVersion() != null) {
            props.setProperty(VDB_VERSION, auth.getVdbVersion());
        }
        return props;
    }

    private SOAPRow[] createSOAPRowsArray(ResultSet set) throws SOAPException {
        ArrayList<SOAPRow> rows = new ArrayList<SOAPRow>(100);
        try {
            int colCount = set.getMetaData().getColumnCount();
            while (set.next()) {
                SOAPRow row = new SOAPRow();
                SOAPDataValueWrapper[] cells = new SOAPDataValueWrapper[colCount];
                for (int i = 1; i <= colCount; ++i) {
                    SOAPDataValueWrapper soapDataValue;
                    Object value = set.getObject(i);
                    cells[i - 1] = value instanceof Character ? (soapDataValue = new SOAPDataValueWrapper(value.toString())) : (value instanceof MMClob ? (soapDataValue = new SOAPDataValueWrapper(this.clobToString(value))) : (soapDataValue = new SOAPDataValueWrapper(value)));
                }
                row.setCell(cells);
                rows.add(row);
            }
        }
        catch (Exception e) {
            throw new SOAPException(SOAPPlugin.Util.getString("ERR.018.002.0014") + e.getMessage());
        }
        return rows.toArray(new SOAPRow[rows.size()]);
    }

    private String clobToString(Object value) throws SOAPException {
        StringBuffer buf = new StringBuffer();
        try {
            Reader reader = ((MMClob)value).getCharacterStream();
            int count = 0;
            while (true) {
                ++count;
                int c = reader.read();
                if (c != -1) {
                    buf.append((char)c);
                    continue;
                }
                break;
            }
        }
        catch (SQLException err) {
            Object[] params = new Object[]{err};
            throw new SOAPException(SOAPPlugin.Util.getString("MetaMatrixServerAPI.0", params) + err.getMessage());
        }
        catch (IOException err) {
            Object[] params = new Object[]{err};
            throw new SOAPException(SOAPPlugin.Util.getString("MetaMatrixServerAPI.1", params) + err.getMessage());
        }
        return buf.toString();
    }

    private SOAPColumn[] createSOAPColumnsArray(ResultSet rs, boolean fullMetadata) throws SOAPException {
        SOAPColumn[] columns;
        try {
            ResultSetMetaData metadata = rs.getMetaData();
            int count = metadata.getColumnCount();
            columns = new SOAPColumn[count];
            for (int i = 1; i <= count; ++i) {
                SOAPColumn column = new SOAPColumn();
                column.setDataType(metadata.getColumnTypeName(i));
                column.setName(metadata.getColumnName(i));
                if (fullMetadata) {
                    column.setAutoIncrementing(metadata.isAutoIncrement(i));
                    column.setCaseSensitive(metadata.isCaseSensitive(i));
                    column.setCurrency(metadata.isCurrency(i));
                    column.setGroupName(metadata.getCatalogName(i));
                    column.setNullable(metadata.isNullable(i));
                    column.setPrecision(metadata.getPrecision(i));
                    column.setRadix(10);
                    column.setScale(metadata.getScale(i));
                    column.setSearchable(metadata.isSearchable(i));
                    column.setSigned(metadata.isSigned(i));
                    column.setVdbName(((com.metamatrix.jdbc.api.ResultSetMetaData)metadata).getVirtualDatabaseName(i));
                    column.setVdbVersion(((com.metamatrix.jdbc.api.ResultSetMetaData)metadata).getVirtualDatabaseVersion(i));
                }
                columns[i - 1] = column;
            }
        }
        catch (SQLException e) {
            throw new SOAPException(SOAPPlugin.Util.getString("ERR.018.002.0015") + e.getMessage());
        }
        return columns;
    }

    private SOAPResultSet translateResultSet(ResultSet set, boolean fullMetadata) throws SOAPException {
        SOAPResultSet results = new SOAPResultSet();
        results.setMetadata(this.createSOAPColumnsArray(set, fullMetadata));
        results.setData(this.createSOAPRowsArray(set));
        return results;
    }

    public static void addApplicationNameProperty(SOAPAuthentication auth) {
        String serverURL = auth.getServerURL();
        if (serverURL == null || serverURL.indexOf("ApplicationName=") >= 0) {
            return;
        }
        String newURL = serverURL;
        if (!newURL.endsWith(";")) {
            newURL = newURL + ";";
        }
        String applicationName = null;
        applicationName = auth.isAnonymous() ? SOAPPlugin.Util.getString("MetaMatrixServerAPI.Application_Name_Anonymous") : SOAPPlugin.Util.getString("MetaMatrixServerAPI.Application_Name");
        newURL = newURL + "ApplicationName" + "=" + applicationName;
        auth.setServerURL(newURL);
    }
}

