/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.servlet;

import com.metamatrix.common.util.WSDLServletUtil;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.CryptoKeyManager;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.keymanage.AsymKeyStoreManager;
import com.metamatrix.core.log.FileLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.license.LicenseInfo;
import com.metamatrix.soap.servlet.MMGetVDBResourcePlatformLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MMGetVDBResourceServlet
extends HttpServlet {
    private static final String procString = "{?=call System.getUpdatedCharacterVDBResource(?,?,?)}";
    private static final String DATASERVICE = "/metamatrix-soap/DataService";
    private static final String[] TOKEN_ARRAY = new String[]{"http://vdb.metamatrix.com", "?vdbToken=true", "http://vdb.dataservice.metamatrix.com"};
    public static final String WSDL_ERROR = "wsdlerror";
    private String[] value_Array = new String[3];
    private static final boolean isLicensed = LicenseInfo.getInstance().isSOAPAPILicensed();
    private static CryptoKeyManager keyManager = null;
    private String wsdlUser = "";
    private String wsdlPassword = "";
    private String decryptedPassword = "";
    public LogListener newListener = null;
    public FileLogWriter logWriter = null;
    MMGetVDBResourcePlatformLog platformLog = MMGetVDBResourcePlatformLog.getInstance();
    private Connection connection = null;

    public MMGetVDBResourceServlet() {
        CryptoUtil.initJCEProvider();
    }

    public synchronized void init(ServletConfig config) throws ServletException {
        super.init(config);
        String logFile = this.getServletContext().getInitParameter("logfile");
        this.wsdlUser = this.getServletContext().getInitParameter("wsdlUser");
        this.wsdlPassword = this.getServletContext().getInitParameter("wsdlPassword");
        this.decryptedPassword = this.decrypt(this.wsdlPassword);
        File log = new File(logFile);
        this.logWriter = new FileLogWriter(log);
        this.platformLog.getPlatformLog().addListener((LogListener)this.logWriter);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block15: {
            if (!isLicensed) {
                String message = LicenseInfo.getErrorMessage() + SOAPPlugin.Util.getString("LicenseInfo.ErrorMessage");
                resp.addHeader(WSDL_ERROR, message);
                MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
                resp.getOutputStream().println(message);
                return;
            }
            resp.setContentType("text/html");
            resp.setHeader(WSDL_ERROR, WSDL_ERROR);
            String serverURL = req.getParameter("ServerURL");
            String vdbName = req.getParameter("VDBName");
            String vdbVersion = req.getParameter("VDBVersion");
            String addProps = req.getParameter("AdditionalProperties");
            String resourcePath = req.getPathInfo();
            String httpTypeString = req.getParameter("httptype");
            try {
                MMGetVDBResourceServlet.checkFormValue(serverURL, "ServerURL");
                MMGetVDBResourceServlet.checkFormValue(vdbName, "VDBName");
                MMGetVDBResourceServlet.checkFormValue(vdbVersion, "VDBVersion");
                serverURL = serverURL + ";ApplicationName=" + SOAPPlugin.Util.getString("MMGetVDBResourceServlet.Application_Name");
            }
            catch (Exception e) {
                MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e, e.getMessage());
                resp.getOutputStream().println(e.getMessage());
                return;
            }
            try {
                this.getConnection(this.wsdlUser, this.decryptedPassword, vdbName, vdbVersion, serverURL, addProps);
            }
            catch (Exception e) {
                String message = SOAPPlugin.Util.getString("ERR.018.002.0006");
                MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e, message);
                resp.getOutputStream().println(message);
                return;
            }
            String suffix = this.buildEndpointSuffixString(req.getParameterMap());
            String urlPrefix = this.buildUrlPrefix(req, httpTypeString);
            String servletPath = urlPrefix + "/" + "metamatrix-soap/servlet/ArtifactDocumentService";
            String result = this.escapeAttributeEntities(suffix);
            result = "?" + result;
            String endPointURL = null;
            endPointURL = urlPrefix + DATASERVICE + result;
            this.getResource(resp, procString, resourcePath, servletPath, result, endPointURL);
            Object var16_18 = null;
            try {
                this.connection.close();
            }
            catch (SQLException e2) {
                MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e2, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.0"));
                resp.setHeader(WSDL_ERROR, WSDL_ERROR);
                resp.getOutputStream().println(e2.getMessage());
            }
            break block15;
            {
                catch (SQLException se) {
                    resp.getOutputStream().println(se.getMessage());
                    MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)se, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.7"));
                    Object var16_19 = null;
                    try {
                        this.connection.close();
                    }
                    catch (SQLException e2) {
                        MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e2, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.0"));
                        resp.setHeader(WSDL_ERROR, WSDL_ERROR);
                        resp.getOutputStream().println(e2.getMessage());
                    }
                    break block15;
                }
                catch (Exception e) {
                    MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.8"));
                    resp.getOutputStream().println(e.getMessage());
                    Object var16_20 = null;
                    try {
                        this.connection.close();
                    }
                    catch (SQLException e2) {
                        MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e2, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.0"));
                        resp.setHeader(WSDL_ERROR, WSDL_ERROR);
                        resp.getOutputStream().println(e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                try {
                    this.connection.close();
                }
                catch (SQLException e2) {
                    MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e2, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.0"));
                    resp.setHeader(WSDL_ERROR, WSDL_ERROR);
                    resp.getOutputStream().println(e2.getMessage());
                }
                throw throwable;
            }
        }
    }

    private String buildUrlPrefix(HttpServletRequest req, String httpTypeString) {
        StringBuffer urlPrefix = new StringBuffer();
        boolean isHttp = "http".equals(httpTypeString);
        if (isHttp) {
            urlPrefix.append("http://").append(req.getServerName()).append(":").append(WSDLServletUtil.getHttpPort());
        } else {
            urlPrefix.append("https://").append(req.getServerName()).append(":").append(WSDLServletUtil.getHttpsPort());
        }
        return urlPrefix.toString();
    }

    public void getConnection(String userid, String password, String vdbName, String vdbVersion, String url, String addProps) throws SQLException {
        try {
            Class.forName("com.metamatrix.jdbc.MMDriver");
            if (addProps == null) {
                addProps = "";
            }
            if (addProps.indexOf(";") == 0) {
                addProps = addProps.substring(1, addProps.length());
            }
            addProps = addProps.equals("") || addProps == null ? "" : ";" + addProps;
            this.connection = DriverManager.getConnection("jdbc:metamatrix:" + vdbName + "@" + url + (vdbVersion == null ? "" : ";version=" + vdbVersion) + ";user=" + userid + ";password=" + password);
        }
        catch (ClassNotFoundException e) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.10"));
        }
    }

    public void getResource(HttpServletResponse resp, String procString, String resourcePath, String urlPrefix, String urlSuffix, String endPointURL) throws SQLException, IOException {
        int c;
        this.value_Array[0] = urlPrefix;
        this.value_Array[1] = urlSuffix;
        this.value_Array[2] = endPointURL;
        if (this.connection == null) {
            resp.getOutputStream().println("Connection is NULL");
            return;
        }
        CallableStatement statement = this.connection.prepareCall(procString);
        MMResultSet rs = null;
        Clob clob = null;
        statement.setString(1, resourcePath);
        statement.setObject(2, (Object)TOKEN_ARRAY);
        statement.setObject(3, (Object)this.value_Array);
        boolean rtn = statement.execute();
        if (!rtn) {
            String message = SOAPPlugin.Util.getString("MMGetVDBResourceServlet.12");
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, message);
            resp.getOutputStream().println(message);
            return;
        }
        rs = (MMResultSet)statement.getResultSet();
        if (!rs.next()) {
            String message = SOAPPlugin.Util.getString("MMGetVDBResourceServlet.14");
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, message);
            resp.getOutputStream().println(message);
            return;
        }
        clob = rs.getClob(1);
        Reader reader = clob.getCharacterStream();
        StringWriter sw = new StringWriter();
        while ((c = reader.read()) != -1) {
            sw.write(c);
        }
        resp.setHeader(WSDL_ERROR, null);
        resp.setContentType("text/xml");
        resp.getOutputStream().write(sw.getBuffer().toString().getBytes());
    }

    private static void checkFormValue(String parameter, String expectedParameterName) throws Exception {
        if (parameter == null || parameter.trim().length() == 0) {
            throw new Exception(SOAPPlugin.Util.getString("ERR.018.002.0004", (Object)expectedParameterName));
        }
    }

    protected String escapeAttributeEntities(String st) {
        int i;
        StringBuffer buff = new StringBuffer();
        char[] block = st.toCharArray();
        String stEntity = null;
        int last = 0;
        for (i = 0; i < block.length; ++i) {
            switch (block[i]) {
                case '<': {
                    stEntity = "&lt;";
                    break;
                }
                case '>': {
                    stEntity = "&gt;";
                    break;
                }
                case '\"': {
                    stEntity = "&quot;";
                    break;
                }
                case '&': {
                    stEntity = "&amp;";
                    break;
                }
            }
            if (stEntity == null) continue;
            buff.append(block, last, i - last);
            buff.append(stEntity);
            stEntity = null;
            last = i + 1;
        }
        if (last < block.length) {
            buff.append(block, last, i - last);
        }
        return buff.toString();
    }

    private String decrypt(String cryptPassword) {
        Key decryptKey = null;
        byte[] decryptPassword = null;
        try {
            keyManager = new AsymKeyStoreManager("metamatrixpki.keystore", CryptoFactory.deArgle((char[])"c3B1dG5pazEz".toCharArray()), "encrypt", true);
        }
        catch (FileNotFoundException err) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.13"));
        }
        catch (IOException err) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.1"));
        }
        catch (Exception err) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.2"));
        }
        try {
            decryptKey = keyManager.getDecryptKey();
        }
        catch (Exception err1) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err1, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.3"));
        }
        Cipher decrypt = null;
        try {
            decrypt = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        }
        catch (Exception e) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)e, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.4"));
        }
        try {
            decrypt.init(2, decryptKey);
        }
        catch (InvalidKeyException err2) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err2, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.5"));
        }
        byte[] pass = CryptoFactory.decodeBytes((char[])cryptPassword.toCharArray());
        try {
            decryptPassword = decrypt.doFinal(pass);
        }
        catch (IllegalStateException err) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.6"));
        }
        catch (IllegalBlockSizeException err) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.11"));
        }
        catch (BadPaddingException err) {
            MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.9"));
        }
        char[] dec_pass = new String(decryptPassword).toCharArray();
        return new String(dec_pass);
    }

    protected String buildEndpointSuffixString(Map parameterMap) {
        String suffixString = "";
        Set keySet = parameterMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (!(key instanceof String)) continue;
            String keyString = (String)key;
            if (!"".equals(suffixString)) {
                suffixString = suffixString + "&";
            }
            String parameterValue = "";
            String[] paramValueArray = (String[])parameterMap.get(keyString);
            if (paramValueArray.length > 0) {
                try {
                    parameterValue = URLEncoder.encode(((String[])parameterMap.get(keyString))[0], "UTF-8");
                }
                catch (UnsupportedEncodingException err) {
                    MMGetVDBResourcePlatformLog.getInstance().getLogFile().log(4, (Throwable)err, SOAPPlugin.Util.getString("MMGetVDBResourceServlet.15"));
                }
            }
            suffixString = suffixString + keyString + "=" + parameterValue;
        }
        return suffixString;
    }
}

