/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.sqlquerywebservice.service;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.platform.SocketConstants;
import com.metamatrix.common.comm.platform.client.ClientSideLogonFactory;
import com.metamatrix.common.comm.platform.client.ClientSideLogonFactoryImpl;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactory;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactoryImpl;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.proxy.ServiceProxyFactory;
import com.metamatrix.dqp.client.ConnectionInfo;
import com.metamatrix.dqp.client.PortableContext;
import com.metamatrix.dqp.client.Results;
import com.metamatrix.dqp.client.ResultsMetadata;
import com.metamatrix.dqp.client.ServerFacade;
import com.metamatrix.dqp.client.impl.ServerConnectionInfo;
import com.metamatrix.dqp.client.impl.ServerFacadeImpl;
import com.metamatrix.dqp.client.impl.ServerRequest;
import com.metamatrix.soap.sqlquerywebservice.SqlQueryWebServicePlugin;
import com.metamatrix.soap.sqlquerywebservice.helper.Cell;
import com.metamatrix.soap.sqlquerywebservice.helper.ColumnMetadata;
import com.metamatrix.soap.sqlquerywebservice.helper.Connection;
import com.metamatrix.soap.sqlquerywebservice.helper.ConnectionContextualRequest;
import com.metamatrix.soap.sqlquerywebservice.helper.ConnectionlessRequest;
import com.metamatrix.soap.sqlquerywebservice.helper.Data;
import com.metamatrix.soap.sqlquerywebservice.helper.LogInParameters;
import com.metamatrix.soap.sqlquerywebservice.helper.RequestId;
import com.metamatrix.soap.sqlquerywebservice.helper.RequestInfo;
import com.metamatrix.soap.sqlquerywebservice.helper.ResultsRequest;
import com.metamatrix.soap.sqlquerywebservice.helper.Row;
import com.metamatrix.soap.sqlquerywebservice.helper.SqlWarning;
import com.metamatrix.soap.sqlquerywebservice.license.LicenseInfo;
import com.metamatrix.soap.sqlquerywebservice.log.SqlQueryWebServicePlatformLog;
import com.metamatrix.soap.sqlquerywebservice.service.SerializablePortableContext;
import com.metamatrix.soap.sqlquerywebservice.service.SqlQueryWebServiceFault;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.idoox.security.jaas.NamePasswordCredential;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;

/*
 * Exception performing whole class analysis ignored.
 */
public class SqlQueryWebService {
    private static final boolean isLicensed = LicenseInfo.getInstance().isSOAPAPILicensed();
    private ServerFacade serverFacade = null;
    public static final String APP_NAME_PROP = "ApplicationName";
    public static final String APP_NAME = "SQL Query Web Service";
    public static final String OUT_PARAM = "OUT";
    public static final String INOUT_PARAM = "INOUT";
    static /* synthetic */ Class class$org$idoox$security$jaas$NamePasswordCredential;

    public RequestId execute(ConnectionContextualRequest request) throws SqlQueryWebServiceFault {
        if (!isLicensed) {
            SqlQueryWebServicePlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            this.throwFaultException((MetaMatrixException)new MetaMatrixComponentException(LicenseInfo.getErrorMessage()));
        }
        ServerFacade server = this.getServerFacade();
        RequestId requestId = new RequestId();
        try {
            com.metamatrix.dqp.client.RequestInfo info = this.getRequestInfo(request);
            PortableContext portableContext = this.getPortableContext(request);
            PortableContext requestContext = server.executeRequest(portableContext, info);
            requestId.setId(requestContext.getPortableString());
            requestId.setConnectionId(request.getConnection().getConnectionId());
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
        request.getRequestInfo().getRequestType();
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public com.metamatrix.soap.sqlquerywebservice.helper.Results executeBlocking(ConnectionlessRequest request) throws SqlQueryWebServiceFault {
        if (!isLicensed) {
            SqlQueryWebServicePlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            this.throwFaultException((MetaMatrixException)new MetaMatrixComponentException(LicenseInfo.getErrorMessage()));
        }
        ServerFacade server = this.getServerFacade();
        PortableContext connectionContext = null;
        com.metamatrix.soap.sqlquerywebservice.helper.Results results = null;
        connectionContext = server.createSession(this.getConnectionInfo(request.getParameters()));
        PortableContext requestContext = server.executeRequest(connectionContext, this.getRequestInfo(request));
        results = this.buildResults(connectionContext, requestContext, request, request.isIncludeMetadata());
        Object var7_7 = null;
        if (connectionContext == null) return results;
        try {
            server.closeSession(connectionContext);
            return results;
        }
        catch (MetaMatrixCoreException err2) {
            Object[] params = new String[]{connectionContext.getPortableString(), err2.getMessage()};
            SqlQueryWebServicePlatformLog.getInstance().getLogFile().log(2, SqlQueryWebServicePlugin.Util.getString("Unable_to_create_the_Detail_for_the_exception_due_to", params));
        }
        return results;
        {
            catch (MetaMatrixException err) {
                this.throwFaultException(err);
                Object var7_8 = null;
                if (connectionContext == null) return results;
                try {
                    server.closeSession(connectionContext);
                    return results;
                }
                catch (MetaMatrixCoreException err2) {
                    Object[] params = new String[]{connectionContext.getPortableString(), err2.getMessage()};
                    SqlQueryWebServicePlatformLog.getInstance().getLogFile().log(2, SqlQueryWebServicePlugin.Util.getString("Unable_to_create_the_Detail_for_the_exception_due_to", params));
                }
                return results;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (connectionContext == null) throw throwable;
            try {
                server.closeSession(connectionContext);
                throw throwable;
            }
            catch (MetaMatrixCoreException err2) {
                Object[] params = new String[]{connectionContext.getPortableString(), err2.getMessage()};
                SqlQueryWebServicePlatformLog.getInstance().getLogFile().log(2, SqlQueryWebServicePlugin.Util.getString("Unable_to_create_the_Detail_for_the_exception_due_to", params));
            }
            throw throwable;
        }
    }

    public com.metamatrix.soap.sqlquerywebservice.helper.Results getResults(ResultsRequest resultsRequest) throws SqlQueryWebServiceFault {
        Results results = null;
        PortableContext connectionContext = this.getPortableContext(resultsRequest.getRequestId().getConnectionId());
        PortableContext requestContext = this.getPortableContext(resultsRequest.getRequestId().getId());
        try {
            results = this.getServerFacade().getBatch(connectionContext, requestContext, resultsRequest.getStartRow() + 1, resultsRequest.getEndRow() + 1, resultsRequest.getTimeToWait());
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
        if (results != null && results.getException() != null) {
            this.throwFaultException((MetaMatrixException)((Object)results.getException()));
        }
        return results == null ? null : this.createSoapResults(connectionContext, requestContext, results, resultsRequest.isIncludeMetadata());
    }

    public Connection getConnection(LogInParameters params) throws SqlQueryWebServiceFault {
        if (!isLicensed) {
            SqlQueryWebServicePlatformLog.getInstance().getLogFile().log(4, LicenseInfo.getErrorMessage());
            this.throwFaultException((MetaMatrixException)new MetaMatrixComponentException(LicenseInfo.getErrorMessage()));
        }
        ServerFacade server = this.getServerFacade();
        ConnectionInfo info = this.getConnectionInfo(params);
        Connection connection = new Connection();
        try {
            PortableContext connectionContext = server.createSession(info);
            connection.setConnectionId(connectionContext.getPortableString());
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
        return connection;
    }

    public void closeConnection(Connection connection) throws SqlQueryWebServiceFault {
        ServerFacade server = this.getServerFacade();
        PortableContext connectionContext = this.getConnectionPortableContext(connection);
        try {
            server.closeSession(connectionContext);
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
    }

    public void terminateRequest(RequestId requestId) throws SqlQueryWebServiceFault {
        ServerFacade server = this.getServerFacade();
        PortableContext requestContext = this.getRequestPortableContext(requestId);
        PortableContext connectionContext = this.getConnectionPortableContext(requestId);
        try {
            server.cancelRequest(connectionContext, requestContext);
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
    }

    private ServerFacade getServerFacade() {
        if (this.serverFacade == null) {
            ClientSideLogonFactoryImpl clientSideLogonFactory = ClientSideLogonFactoryImpl.getInstance();
            ServiceProxyFactory serviceProxyFactory = new ServiceProxyFactory();
            ObjectSocketFactoryImpl objectSocketFactory = ObjectSocketFactoryImpl.getInstance();
            SocketServerConnectionFactory factory = new SocketServerConnectionFactory(SocketConstants.getMaxThreads(), SocketConstants.getTTL(), SocketConstants.getSynchronousTTL(), SocketConstants.getLog((String)this.getClass().getName()), this.getClass().getClassLoader(), SocketConstants.getInputBufferSize(), SocketConstants.getOutputBufferSize(), SocketConstants.getConserveBandwidth(), (ClientSideLogonFactory)clientSideLogonFactory, serviceProxyFactory, (ObjectSocketFactory)objectSocketFactory);
            this.serverFacade = new ServerFacadeImpl((ServerConnectionFactory)factory);
        }
        return this.serverFacade;
    }

    private PortableContext getPortableContext(ConnectionContextualRequest request) {
        return new SerializablePortableContext(request.getConnection().getConnectionId());
    }

    private PortableContext getPortableContext(String id) {
        return new SerializablePortableContext(id);
    }

    private PortableContext getConnectionPortableContext(Connection connection) {
        return new SerializablePortableContext(connection.getConnectionId());
    }

    private PortableContext getConnectionPortableContext(RequestId requestId) {
        return new SerializablePortableContext(requestId.getConnectionId());
    }

    private PortableContext getRequestPortableContext(RequestId requestid) {
        return new SerializablePortableContext(requestid.getId());
    }

    private com.metamatrix.dqp.client.RequestInfo getRequestInfo(ConnectionContextualRequest request) {
        RequestInfo info = request.getRequestInfo();
        return this.getRequestInfo(info);
    }

    private ConnectionInfo getConnectionInfo(LogInParameters params) throws SqlQueryWebServiceFault {
        ServerConnectionInfo connectionInfo = new ServerConnectionInfo();
        connectionInfo.setServerUrl(params.getMmServerUrl());
        connectionInfo.setVDBName(params.getVdbName());
        connectionInfo.setVDBVersion(params.getVdbVersion());
        connectionInfo.setTrustedPayload((Serializable)((Object)params.getConnectionPayload()));
        connectionInfo.setOptionalProperty("ApplicationName", (Object)"SQL Query Web Service");
        if (params.getOptionalProperties() != null) {
            for (int i = 0; i < params.getOptionalProperties().length; ++i) {
                String propName = params.getOptionalProperties()[i].getPropertyName();
                String propValue = params.getOptionalProperties()[i].getPropertyValue();
                connectionInfo.setOptionalProperty(propName, (Object)propValue);
            }
        }
        NamePasswordCredential creds = this.getCredentials();
        connectionInfo.setUser(creds.getName());
        connectionInfo.setPassword(creds.getPassword());
        return connectionInfo;
    }

    private com.metamatrix.dqp.client.RequestInfo getRequestInfo(ConnectionlessRequest request) {
        RequestInfo info = request.getRequestInfo();
        return this.getRequestInfo(info);
    }

    private com.metamatrix.dqp.client.RequestInfo getRequestInfo(RequestInfo info) {
        ServerRequest domainInfo = new ServerRequest();
        domainInfo.setBindParameters((Object[])info.getBindParameters());
        domainInfo.setCommandPayload((Serializable)((Object)info.getCommandPayload()));
        domainInfo.setCursorType(Integer.parseInt(info.getCursorType().getValue()));
        domainInfo.setFetchSize(info.getFetchSize());
        domainInfo.setPartialResults(info.isPartialResults());
        domainInfo.setRequestType(info.getRequestType().getDiscriminator());
        domainInfo.setSql(info.getSqlString());
        domainInfo.setTransactionAutoWrapMode(info.getTransactionAutoWrapMode().getDiscriminator());
        domainInfo.setUseResultSetCache(info.isUseResultSetCache());
        domainInfo.setXMLFormat(info.getXmlFormat());
        domainInfo.setXMLStyleSheet(info.getXmlStyleSheet());
        domainInfo.setXMLValidationMode(info.isXmlValidationMode());
        return domainInfo;
    }

    protected com.metamatrix.soap.sqlquerywebservice.helper.Results buildResults(PortableContext connectionContext, PortableContext requestContext, ConnectionlessRequest request, boolean includeMetadata) throws SqlQueryWebServiceFault {
        MetaMatrixException e;
        ArrayList<Results> resultsList = new ArrayList<Results>();
        Results results = null;
        try {
            results = this.getServerFacade().getBatch(connectionContext, requestContext, 1, request.getMaxRowsReturned(), request.getTimeToWait());
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
        if (results == null) {
            e = new MetaMatrixException(SqlQueryWebServicePlugin.Util.getString("The_time_to_wait_submitted_with_the_executeBlocking_request"));
            this.throwFaultException(e);
        }
        resultsList.add(results);
        while (!results.isLast() && results.getEndRow() != 0 && results.getEndRow() != request.getMaxRowsReturned()) {
            try {
                results = this.getServerFacade().getBatch(connectionContext, requestContext, results.getEndRow() + 1, request.getMaxRowsReturned(), request.getTimeToWait());
            }
            catch (MetaMatrixException err) {
                this.throwFaultException(err);
            }
            if (results == null) {
                e = new MetaMatrixException(SqlQueryWebServicePlugin.Util.getString("The_time_to_wait_submitted_with_the_executeBlocking_request"));
                this.throwFaultException(e);
            }
            resultsList.add(results);
        }
        return this.createBlockingSoapResults(connectionContext, requestContext, resultsList, includeMetadata);
    }

    private com.metamatrix.soap.sqlquerywebservice.helper.Results createSoapResults(PortableContext connectionContext, PortableContext requestContext, Results results, boolean includeMetadata) {
        com.metamatrix.soap.sqlquerywebservice.helper.Results soapResults = new com.metamatrix.soap.sqlquerywebservice.helper.Results();
        soapResults.setData(this.getData(connectionContext, requestContext, results, includeMetadata));
        soapResults.setBeginRow(new Integer(results.getBeginRow() - 1));
        soapResults.setEndRow(new Integer(results.getEndRow() - 1));
        soapResults.setHasData(this.hasData(results));
        try {
            if (results.isUpdate()) {
                soapResults.setUpdateCount(new Integer(results.getUpdateCount()));
            } else {
                soapResults.setUpdateCount(new Integer(-1));
            }
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
        soapResults.setSqlWarnings(this.getWarnings(results));
        try {
            soapResults.setOutputParameters(this.getOutputParameters(results));
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
        return soapResults;
    }

    private com.metamatrix.soap.sqlquerywebservice.helper.Results createBlockingSoapResults(PortableContext connectionContext, PortableContext requestContext, List resultsList, boolean includeMetadata) {
        com.metamatrix.soap.sqlquerywebservice.helper.Results soapResults = new com.metamatrix.soap.sqlquerywebservice.helper.Results();
        for (int i = 0; i < resultsList.size(); ++i) {
            Results results;
            block8: {
                results = (Results)resultsList.get(i);
                if (i == 0) {
                    soapResults.setData(this.getData(connectionContext, requestContext, results, includeMetadata));
                    soapResults.setBeginRow(new Integer(results.getBeginRow() - 1));
                    soapResults.setHasData(this.hasData(results));
                    soapResults.setSqlWarnings(this.getWarnings(results));
                    try {
                        if (results.isUpdate()) {
                            soapResults.setUpdateCount(new Integer(results.getUpdateCount()));
                            break block8;
                        }
                        soapResults.setUpdateCount(new Integer(-1));
                    }
                    catch (MetaMatrixException err) {
                        this.throwFaultException(err);
                    }
                } else {
                    soapResults.setData(this.appendData(soapResults.getData(), this.getData(connectionContext, requestContext, results, includeMetadata)));
                }
            }
            soapResults.setEndRow(new Integer(results.getEndRow() - 1));
            try {
                soapResults.setOutputParameters(this.getOutputParameters(results));
                continue;
            }
            catch (MetaMatrixException err) {
                this.throwFaultException(err);
            }
        }
        return soapResults;
    }

    private SqlWarning[] getWarnings(Results results) {
        Exception[] excArray = results.getWarnings();
        SqlWarning[] warnings = null;
        if (excArray.length > 0) {
            warnings = new SqlWarning[excArray.length];
            for (int j = 0; j < results.getWarnings().length; ++j) {
                Exception exc = excArray[j];
                SqlWarning warning = new SqlWarning();
                warning.setMessage(exc.getMessage());
                warnings[j] = warning;
            }
        }
        return warnings;
    }

    private Object[] getOutputParameters(Results results) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        Object[] outputParameters = null;
        if (results.isLast() && results.getParameterCount() > 0) {
            ArrayList<Object> outputParametersList = new ArrayList<Object>();
            for (int k = 1; k <= results.getParameterCount(); ++k) {
                int parameterType = results.getParameterType(k);
                if (parameterType != 1 && parameterType != 2) continue;
                outputParametersList.add(results.getOutputParameter(k));
            }
            outputParameters = new Object[outputParametersList.size()];
            for (int l = 0; l < outputParametersList.size(); ++l) {
                outputParameters[l] = outputParametersList.get(l);
            }
        }
        return outputParameters;
    }

    private Data getData(PortableContext connectionContext, PortableContext requestContext, Results results, boolean includeMetadata) {
        Data data = new Data();
        ResultsMetadata metadata = null;
        if (includeMetadata) {
            try {
                if (!results.isUpdate()) {
                    metadata = this.getServerFacade().getMetadata(connectionContext, requestContext);
                    data.setMetadataArray(this.getColumnMetaData(metadata));
                }
            }
            catch (MetaMatrixException err) {
                this.throwFaultException(err);
            }
        }
        data.setLast(results.isLast());
        Row[] rowArray = new Row[results.getRowCount()];
        int rowCounter = 0;
        try {
            for (int i = results.getBeginRow(); i <= results.getEndRow(); ++i) {
                Row row = new Row();
                Cell[] cellArray = new Cell[results.getColumnCount()];
                for (int j = 1; j <= results.getColumnCount(); ++j) {
                    Cell cell = new Cell();
                    cell.setValue(results.getValue(i, j));
                    cellArray[j - 1] = cell;
                }
                row.setCells(cellArray);
                rowArray[rowCounter++] = row;
            }
        }
        catch (MetaMatrixException err) {
            this.throwFaultException(err);
        }
        data.setRows(rowArray);
        return data;
    }

    private Data appendData(Data data, Data appendData) {
        Row[] appendArrayOfRow;
        Row[] arrayOfRow = data.getRows();
        if (arrayOfRow != null && (appendArrayOfRow = appendData.getRows()) != null) {
            Row[] newArray = new Row[arrayOfRow.length + appendArrayOfRow.length];
            System.arraycopy(arrayOfRow, 0, newArray, 0, arrayOfRow.length);
            System.arraycopy(appendArrayOfRow, 0, newArray, arrayOfRow.length, appendArrayOfRow.length);
            data.setRows(newArray);
        }
        return data;
    }

    private ColumnMetadata[] getColumnMetaData(ResultsMetadata metadata) {
        int columnCount = metadata.getColumnCount();
        ColumnMetadata[] metadataArray = new ColumnMetadata[columnCount];
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            ColumnMetadata columnMetadata = new ColumnMetadata();
            columnMetadata.setColumnName(metadata.getColumnName(i));
            columnMetadata.setColumnDataType(metadata.getColumnTypeName(i));
            columnMetadata.setColumnClassName(metadata.getColumnClassName(i));
            columnMetadata.setColumnDisplaySize(metadata.getColumnDisplaySize(i));
            columnMetadata.setCurrency(metadata.isCurrency(i));
            columnMetadata.setGetColumnLabel(metadata.getColumnLabel(i));
            columnMetadata.setNullable(metadata.isNullable(i));
            columnMetadata.setPrecision(metadata.getPrecision(i));
            columnMetadata.setReadOnly(metadata.isReadOnly(i));
            columnMetadata.setScale(metadata.getScale(i));
            columnMetadata.setSearchable(metadata.isSearchable(i));
            columnMetadata.setSigned(metadata.isSigned(i));
            columnMetadata.setTableName(metadata.getTableName(i));
            columnMetadata.setVirtualDatabaseName(metadata.getVirtualDatabaseName(i));
            columnMetadata.setVirtualDatabaseVersion(metadata.getVirtualDatabaseVersion(i));
            metadataArray[i - 1] = columnMetadata;
        }
        return metadataArray;
    }

    private NamePasswordCredential getCredentials() throws SqlQueryWebServiceFault {
        Set credSet;
        Current current = Current.getInstance();
        ReceivedCredentials creds = current.getReceivedCredentials();
        if (creds == null) {
            this.throwFaultException((MetaMatrixException)new MetaMatrixProcessingException(SqlQueryWebServicePlugin.Util.getString("SqlQueryWebService.0")));
        }
        NamePasswordCredential npc = null;
        Subject sub = creds.getSubject();
        if (sub == null) {
            this.throwFaultException((MetaMatrixException)new MetaMatrixProcessingException(SqlQueryWebServicePlugin.Util.getString("SqlQueryWebService.1")));
        }
        if ((credSet = sub.getPrivateCredentials(class$org$idoox$security$jaas$NamePasswordCredential == null ? (class$org$idoox$security$jaas$NamePasswordCredential = SqlQueryWebService.class$((String)"org.idoox.security.jaas.NamePasswordCredential")) : class$org$idoox$security$jaas$NamePasswordCredential)) != null && credSet.size() != 0) {
            npc = (NamePasswordCredential)credSet.iterator().next();
        } else {
            this.throwFaultException((MetaMatrixException)new MetaMatrixProcessingException(SqlQueryWebServicePlugin.Util.getString("SqlQueryWebService.2")));
        }
        if (npc == null) {
            this.throwFaultException((MetaMatrixException)new MetaMatrixProcessingException(SqlQueryWebServicePlugin.Util.getString("SqlQueryWebService.3")));
        }
        return npc;
    }

    private void throwFaultException(MetaMatrixException e) throws SqlQueryWebServiceFault {
        SqlQueryWebServiceFault fault = SqlQueryWebServiceFault.create((MetaMatrixException)e);
        SqlQueryWebServicePlatformLog.getInstance().getLogFile().log(4, (Throwable)e, e.getMessage());
        throw fault;
    }

    private boolean hasData(Results results) {
        boolean hasData = true;
        if (results.isUpdate() || results.getColumnCount() == 0) {
            hasData = false;
        }
        return hasData;
    }

    public void setServerFacade(ServerFacade serverFacade) {
        this.serverFacade = serverFacade;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

