/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class BaseParameter
extends BaseData {
    private static String footprint = "$Revision:   3.10.1.2  $";
    public static final int DIR_IN = 1;
    public static final int DIR_OUT = 2;
    public static final int DIR_INOUT = 4;
    public static final int TYPE_UNSPECIFIED = Integer.MAX_VALUE;
    public int sqlType = Integer.MAX_VALUE;
    public int scale = -1;
    public int nativeType;
    public String name;
    public Calendar cal;
    public UtilTransliterator transliterator;
    public String transliteratorCharSet;

    public BaseParameter(BaseConnection baseConnection) {
        super(baseConnection);
    }

    public BaseParameter(BaseParameter baseParameter, BaseConnection baseConnection) {
        super(baseConnection);
        this.copy(baseParameter, baseConnection);
    }

    public BaseParameter(int n, int n2, Object object, BaseConnection baseConnection) {
        super(n2, object, baseConnection);
        this.sqlType = n;
    }

    public BaseParameter(int n, int n2, Object object, int n3, BaseConnection baseConnection) {
        super(n2, object, baseConnection);
        this.sqlType = n;
        this.scale = n3;
    }

    public BaseParameter(int n, int n2, Object object, Calendar calendar, BaseConnection baseConnection) {
        super(n2, object, baseConnection);
        this.sqlType = n;
        this.cal = calendar;
    }

    public void copy(BaseParameter baseParameter, BaseConnection baseConnection) {
        super.populate(baseParameter);
        this.sqlType = baseParameter.sqlType;
        this.scale = baseParameter.scale;
        this.cal = baseParameter.cal;
        this.name = baseParameter.name;
    }

    public Time getTime(BaseExceptions baseExceptions) throws SQLException {
        if (!this.isNull()) {
            switch (this.getType()) {
                case 13: {
                    if (this.sqlType != 93 && this.sqlType != 92 && this.sqlType != 91) break;
                    BaseTimestamp baseTimestamp = (BaseTimestamp)this.data;
                    return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                }
                case 12: {
                    if (this.sqlType != 93 && this.sqlType != 92 && this.sqlType != 91) break;
                    Time time = (Time)this.data;
                    return new Time(time.getHours(), time.getMinutes(), time.getSeconds());
                }
            }
        }
        return super.getTime(baseExceptions);
    }

    public Date getDate(BaseExceptions baseExceptions) throws SQLException {
        if (!this.isNull()) {
            switch (this.getType()) {
                case 13: {
                    if (this.sqlType != 93 && this.sqlType != 92 && this.sqlType != 91) break;
                    BaseTimestamp baseTimestamp = (BaseTimestamp)this.data;
                    return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                }
                case 11: {
                    if (this.sqlType != 93 && this.sqlType != 92 && this.sqlType != 91) break;
                    Date date = (Date)this.data;
                    return new Date(date.getYear(), date.getMonth(), date.getDate());
                }
            }
        }
        return super.getDate(baseExceptions);
    }

    public BaseTimestamp getTimestamp(BaseExceptions baseExceptions) throws SQLException {
        if (!this.isNull()) {
            switch (this.getType()) {
                case 13: {
                    if (this.sqlType == 91) {
                        BaseTimestamp baseTimestamp = (BaseTimestamp)this.data;
                        return new BaseTimestamp(baseTimestamp.getYear(), baseTimestamp.getMonth(), baseTimestamp.getDate(), 0, 0, 0, 0, null);
                    }
                    if (this.sqlType != 92) break;
                    BaseTimestamp baseTimestamp = (BaseTimestamp)this.data;
                    if (this.connection.getDateTimeBehavior() == 2) {
                        Date date = new Date(System.currentTimeMillis());
                        return new BaseTimestamp(date.getYear() + 1900, date.getMonth(), date.getDate(), baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds(), baseTimestamp.getNanos(), null);
                    }
                    return new BaseTimestamp(1970, 0, 1, baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds(), baseTimestamp.getNanos(), null);
                }
                case 12: {
                    if (this.sqlType != 93 && this.sqlType != 92 && this.sqlType != 91) break;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Time)this.data);
                    if (this.connection.getDateTimeBehavior() == 2) {
                        Date date = new Date(System.currentTimeMillis());
                        calendar.set(1, date.getYear() + 1900);
                        calendar.set(2, date.getMonth());
                        calendar.set(5, date.getDate());
                    } else {
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                    }
                    return new BaseTimestamp(calendar, 0);
                }
                case 11: {
                    if (this.sqlType != 93 && this.sqlType != 92 && this.sqlType != 91) break;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)this.data);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    return new BaseTimestamp(calendar, 0);
                }
                case 10: {
                    return BaseTimestamp.valueOf((String)this.data, this.connection);
                }
            }
        }
        return super.getTimestamp(baseExceptions);
    }

    public UtilTransliterator getTransliterator() {
        UtilTransliterator utilTransliterator = null;
        if (this.transliterator != null) {
            utilTransliterator = this.transliterator;
        } else if (this.transliteratorCharSet != null) {
            try {
                utilTransliterator = UtilTransliterator.GetNewTransliterator((String)this.transliteratorCharSet);
            }
            catch (UtilException utilException) {
                // empty catch block
            }
        }
        return utilTransliterator;
    }
}

