/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyLogger;
import java.io.IOException;
import java.io.InputStream;

class SpyInputStream
extends InputStream {
    private InputStream realInputStream;
    private SpyLogger spyLogger;
    private int id;
    private static int Id = 0;

    SpyInputStream(InputStream inputStream, SpyLogger spyLogger) {
        this.realInputStream = inputStream;
        this.spyLogger = spyLogger;
        this.id = ++Id;
    }

    public final int available() throws IOException {
        int n;
        this.spyLogger.println("\n" + this + ".available()");
        this.spyLogger.enter();
        try {
            n = this.realInputStream.available();
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final void close() throws IOException {
        this.spyLogger.println("\n" + this + ".close()");
        this.spyLogger.enter();
        try {
            this.realInputStream.close();
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void mark(int n) {
        this.spyLogger.println("\n" + this + ".mark(int readlimit)");
        this.spyLogger.println("readlimit = " + n);
        this.spyLogger.enter();
        this.realInputStream.mark(n);
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean markSupported() {
        this.spyLogger.println("\n" + this + ".markSupported()");
        this.spyLogger.enter();
        boolean bl = this.realInputStream.markSupported();
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final int read() throws IOException {
        int n;
        if (this.spyLogger.logSingleRead) {
            this.spyLogger.println("\n" + this + ".read()");
        }
        this.spyLogger.enter();
        try {
            n = this.realInputStream.read();
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        if (this.spyLogger.logSingleRead) {
            this.spyLogger.println("OK (" + n + ")");
        }
        return n;
    }

    public final int read(byte[] byArray) throws IOException {
        int n;
        this.spyLogger.println("\n" + this + ".read(byte b[])");
        if (byArray != null) {
            this.spyLogger.println("b.length = " + byArray.length);
        } else {
            this.spyLogger.println("b = null");
        }
        this.spyLogger.enter();
        try {
            n = this.realInputStream.read(byArray);
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.spyLogger.println("\n" + this + ".read(byte b[], int off, int len)");
        if (byArray != null) {
            this.spyLogger.println("b.length = " + byArray.length);
        } else {
            this.spyLogger.println("b = null");
        }
        this.spyLogger.println("off = " + n);
        this.spyLogger.println("len = " + n2);
        this.spyLogger.enter();
        try {
            n3 = this.realInputStream.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n3 + ")");
        return n3;
    }

    public final synchronized void reset() throws IOException {
        this.spyLogger.println("\n" + this + ".reset()");
        this.spyLogger.enter();
        try {
            this.realInputStream.reset();
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final long skip(long l) throws IOException {
        long l2;
        this.spyLogger.println("\n" + this + ".skip(long n)");
        this.spyLogger.println("n = " + l);
        this.spyLogger.enter();
        try {
            l2 = this.realInputStream.skip(l);
        }
        catch (IOException iOException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + iOException.toString() + "***");
            iOException.fillInStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + runtimeException.toString() + "***");
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            this.spyLogger.leave();
            this.spyLogger.println("***" + error.toString() + "***");
            error.fillInStackTrace();
            throw error;
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            this.spyLogger.sqlException(throwable);
            throw new Error();
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l2 + ")");
        return l2;
    }

    public final String toString() {
        return "InputStream[" + this.id + "]";
    }
}

