/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.tns;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.oracle.tns.TnsDescriptionList;
import com.metamatrix.jdbc.oracle.tns.TnsValueInfo;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;

public class TnsFile {
    private static String footprint = "$Revision:   1.2.3.0  $";
    private DataInputStream m_tnsReader = null;
    private FileInputStream m_webStream = null;

    public static TnsDescriptionList CreateDescriptorList(String string, String string2, BaseExceptions baseExceptions) throws SQLException {
        try {
            final String string3 = string;
            final String string4 = string2;
            final BaseExceptions baseExceptions2 = baseExceptions;
            return (TnsDescriptionList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws SQLException {
                    TnsFile tnsFile = new TnsFile();
                    TnsDescriptionList tnsDescriptionList = null;
                    try {
                        tnsFile.open(string4, baseExceptions2);
                        String string = tnsFile.getServerSection(string4, string3, baseExceptions2);
                        tnsDescriptionList = TnsDescriptionList.Create(string3, string, baseExceptions2);
                    }
                    finally {
                        tnsFile.close();
                    }
                    return tnsDescriptionList;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getException();
        }
    }

    private void open(String string, BaseExceptions baseExceptions) throws SQLException {
        try {
            this.m_webStream = new FileInputStream(string);
            this.m_tnsReader = new DataInputStream(this.m_webStream);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            throw baseExceptions.getException(7022, stringArray, "08001");
        }
    }

    private void close() {
        try {
            if (this.m_tnsReader != null) {
                this.m_tnsReader.close();
                this.m_tnsReader = null;
            }
            if (this.m_webStream != null) {
                this.m_webStream.close();
                this.m_webStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getServerSection(String string, String string2, BaseExceptions baseExceptions) throws SQLException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            do {
                String string3;
                int n;
                String string4;
                if ((string4 = this.m_tnsReader.readLine()) == null) {
                    String[] stringArray = new String[]{string2};
                    throw baseExceptions.getException(7023, stringArray, "08001");
                }
                if (string4.length() == 0 || string4.charAt(0) == '#' || Character.isWhitespace(string4.charAt(0)) || (n = string4.indexOf(61)) == -1 || !string2.equalsIgnoreCase(string3 = string4.substring(0, n).trim())) continue;
                stringBuffer.append(string4.substring(n + 1));
                boolean bl2 = false;
                while ((string4 = this.m_tnsReader.readLine()) != null) {
                    if (string4.length() != 0 && string4.charAt(0) != '#') {
                        if (Character.isWhitespace(string4.charAt(0)) || string4.charAt(0) == '(') {
                            stringBuffer.append(string4);
                        } else {
                            bl2 = true;
                        }
                    }
                    if (!bl2) continue;
                }
                bl = true;
            } while (!bl);
        }
        catch (IOException iOException) {
            String[] stringArray = new String[]{string};
            baseExceptions.getException(7021, stringArray, "08001");
        }
        return TnsValueInfo.StripParens(stringBuffer.toString());
    }
}

