/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.informix.InformixEscapeTranslator;
import com.metamatrix.jdbc.informix.InformixImplConnection;
import com.metamatrix.jdbc.informix.InformixImplDatabaseMetaData;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import java.sql.SQLException;

public class InformixConnection
extends BaseConnection {
    private static String footprint = "$Revision:   3.5.1.1  $";
    InformixImplConnection implConnection = null;
    InformixImplDatabaseMetaData databaseMetaData = null;

    protected void getImplPropertyInfo(BaseDriverPropertyInfos baseDriverPropertyInfos) {
        baseDriverPropertyInfos.put("serverName", "Database Server Host Name", "", null, false);
        baseDriverPropertyInfos.put("portNumber", "Database Server Port Number", "", null, false);
        baseDriverPropertyInfos.put("user", "Login ID", "", null, true);
        baseDriverPropertyInfos.put("password", "Login Password", "", null, true);
        baseDriverPropertyInfos.put("informixServer", "Informix Server Name", "", null, true);
        baseDriverPropertyInfos.put("databaseName", "Database Name", "", null, false);
        baseDriverPropertyInfos.put("codePageOverride", "Code Page Override", "", null, false);
        String[] stringArray = new String[]{"", "DMY2", "DMY2-", "DMY2.", "DMY2/", "DMY4", "DMY4-", "DMY4.", "DMY4/", "MDY2", "MDY2-", "MDY2.", "MDY2/", "MDY4", "MDY4-", "MDY4.", "MDY4/", "Y4DM", "Y4DM-", "Y4DM.", "Y4DM/", "Y4MD", "Y4MD-", "Y4MD.", "Y4MD/", "Y2DM", "Y2DM-", "Y2DM.", "Y2DM/", "Y4MD", "Y4MD-", "Y4MD.", "Y4MD/"};
        baseDriverPropertyInfos.put("dbdate", "DBDATE Environment Variable", "Y4MD-", stringArray, false);
        baseDriverPropertyInfos.put("useDelimitedIdentifier", "Use Delimited Identifier", "true", null, false);
    }

    protected BaseImplConnection createImplConnection(BaseConnectionProperties baseConnectionProperties) {
        this.implConnection = new InformixImplConnection(this);
        return this.implConnection;
    }

    public BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        return this.databaseMetaData;
    }

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return new InformixEscapeTranslator(this.implConnection, this.databaseMetaData);
    }

    public InformixSQLICommunication getCommunication() {
        return this.implConnection.comm;
    }
}

