/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ssp;

import com.metamatrix.sequelink.ssp.CodecParams;
import com.metamatrix.sequelink.ssp.SspContext;
import com.metamatrix.sequelink.util.UnSyncVector;
import com.metamatrix.sequelink.variables.CursorVariables;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.SQLException;

public class CodecFetch
extends CodecParams {
    int rowsRequested;
    int rowCount;
    int fetchFlag;
    CursorVariables cursorVariables;

    CodecFetch(int n, CursorVariables cursorVariables, UnSyncVector unSyncVector, SspContext sspContext) {
        super(8, sspContext, null, unSyncVector);
        this.rowsRequested = n;
        this.cursorVariables = cursorVariables;
    }

    void encodeBody() throws IOException {
        this.sos.writeSSPRefNum(this.context.reference);
        this.sos.writeSSPInt32(this.rowsRequested);
    }

    void decodeBodyMinus() throws IOException, SQLException {
        this.rowCount = this.sis.readSSPRowCount(false);
        this.fetchFlag = this.sis.readSSPFullInt32();
    }

    void decodeBodyPlus() throws IOException, SQLException, UtilException {
        int n = this.rowCount;
        for (int i = 0; i < n; ++i) {
            this.cursorVariables.readNormalVariablesFromStream(this.sis);
        }
        this.readOutputParameters();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getFetchFlag() {
        return this.fetchFlag;
    }
}

