/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.oracle;

import com.metamatrix.jdbcx.base.BaseDataSource;
import com.metamatrix.jdbcx.base.BaseDataSourceFactory;
import com.metamatrix.jdbcx.oracle.OracleDataSource;
import javax.naming.RefAddr;
import javax.naming.Reference;

public class OracleDataSourceFactory
extends BaseDataSourceFactory {
    private static String footprint = "$Revision:   3.13.2.1  $";

    protected void implLoadProperties(Reference reference, BaseDataSource baseDataSource) {
        OracleDataSource oracleDataSource = (OracleDataSource)baseDataSource;
        try {
            RefAddr refAddr = reference.get("SID");
            if (refAddr != null) {
                oracleDataSource.SID = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("serviceName")) != null) {
                oracleDataSource.serviceName = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("serverType")) != null) {
                oracleDataSource.serverType = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("FetchTSWTZasTimestamp")) != null) {
                oracleDataSource.FetchTSWTZasTimestampString = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("TNSNamesFile")) != null) {
                oracleDataSource.tnsNamesFile = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("TNSServerName")) != null) {
                oracleDataSource.tnsServerName = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("CatalogOptions")) != null) {
                oracleDataSource.catalogOptions = Integer.parseInt((String)refAddr.getContent());
            } else {
                refAddr = reference.get("CatalogIncludesSynonyms");
                if (refAddr != null) {
                    oracleDataSource.catalogOptions = ((String)refAddr.getContent()).compareToIgnoreCase("FALSE") == 0 ? 0 : 2;
                }
            }
            refAddr = reference.get("codePageOverride");
            if (refAddr != null) {
                oracleDataSource.codePageOverride = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("enableCancelTimeout")) != null) {
                oracleDataSource.enableCancelTimeout = Boolean.getBoolean((String)refAddr.getContent());
            }
            if ((refAddr = reference.get("sendFloatParametersAsString")) != null) {
                oracleDataSource.sendFloatParametersAsString = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("authenticationMethod")) != null) {
                oracleDataSource.authenticationMethod = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("sysLoginRole")) != null) {
                oracleDataSource.sysLoginRole = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("supportLinks")) != null) {
                oracleDataSource.supportLinks = (String)refAddr.getContent();
            }
            if ((refAddr = reference.get("wireProtocolMode")) != null) {
                oracleDataSource.wireProtocolMode = Integer.parseInt((String)refAddr.getContent());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

