/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.sqlserver;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.sqlserver.SQLServerConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSDTCRequest;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.base.BaseXid;
import com.metamatrix.jdbcx.sqlserver.SQLServerDataSource;
import com.metamatrix.util.UtilDebug;
import java.net.Socket;
import java.net.SocketException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public final class SQLServerImplXAResource
extends BaseImplXAResource {
    private static String footprint = "$Revision:   3.15.1.1  $";
    static final short XA_OPEN = 0;
    static final short XA_CLOSE = 1;
    static final short XA_START = 2;
    static final short XA_END = 3;
    static final short XA_PREPARE = 4;
    static final short XA_COMMIT = 5;
    static final short XA_ROLLBACK = 6;
    static final short XA_FORGET = 7;
    static final short XA_RECOVER = 8;
    static final String[] XP_XA = new String[]{"exec ? = master..xp_jdbc_open2", "exec ? = master..xp_jdbc_close2", "exec ? = master..xp_jdbc_start2 ?, ?, ?, ?, ?", "exec ? = master..xp_jdbc_end2 ?, ?", "exec ? = master..xp_jdbc_prepare2 ?, ?", "exec ? = master..xp_jdbc_commit2 ?, ?", "exec ? = master..xp_jdbc_rollback2 ?, ?", "exec ? = master..xp_jdbc_forget2 ?, ?", "exec ? = master..xp_jdbc_recover2 ?, ?, ?"};
    CallableStatement[] callableStatements = new CallableStatement[XP_XA.length];
    BaseConnectionProperties connectProps;
    int timeout;
    SQLServerDataSource ds;
    SQLServerConnection txnConn;
    int nXids;
    byte[] xidBytes;
    byte[] cookie;
    boolean enlisted = false;
    boolean isServer7 = true;
    TDSDTCRequest request = null;
    SQLException sqlEx = null;
    boolean startedWithJoin = false;

    public SQLServerImplXAResource(SQLServerDataSource sQLServerDataSource, BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.connectProps = baseConnection.getConnectProperties();
        this.ds = sQLServerDataSource;
    }

    protected boolean recoverReturnsAllXidsAtOnce() {
        return false;
    }

    protected void open(int n) throws SQLException {
        Socket socket = null;
        int n2 = 0;
        this.requiredLocalAutoCommit = 1;
        this.txnConn = new SQLServerConnection();
        BaseConnectionProperties baseConnectionProperties = this.connectProps.copy();
        baseConnectionProperties.put("initializationString", "");
        baseConnectionProperties.put("sendStringParametersAsUnicode", "true");
        this.txnConn.open(baseConnectionProperties, new BaseExceptions(BaseClassUtility.getRootName((String)((Object)((Object)this)).toString(), (String)"ImplXAResource")), new UtilDebug());
        try {
            socket = this.txnConn.implConnection.getQueryTimeoutSocket();
            n2 = socket.getSoTimeout();
            socket.setSoTimeout(n * 1000);
            this.txnConn.setTransactionIsolation(2112);
            DatabaseMetaData databaseMetaData = this.txnConn.getMetaData();
            String string = databaseMetaData.getDatabaseProductVersion();
            this.isServer7 = false;
            if (string.startsWith("Microsoft SQL Server  7.00")) {
                this.isServer7 = true;
            }
            this.request = ((SQLServerConnection)this.connection).createTDSDTCRequest();
            for (int i = 0; i < XP_XA.length; ++i) {
                this.callableStatements[i] = this.txnConn.prepareCall(XP_XA[i]);
            }
            this.executeXaRpc((short)0);
        }
        catch (SocketException socketException) {
        }
        catch (XAException xAException) {
            String string = this.exceptions.getMessages().getMessage(6085, null, false);
            if (xAException.getMessage().equalsIgnoreCase(string)) {
                throw this.exceptions.getException(6049, "HYT00");
            }
            if (this.sqlEx != null) {
                throw this.sqlEx;
            }
            throw new SQLException(xAException.getMessage());
        }
        finally {
            try {
                if (socket != null) {
                    socket.setSoTimeout(n2);
                }
            }
            catch (SocketException socketException) {}
        }
    }

    protected void close() throws SQLException {
        try {
            this.executeXaRpc((short)1);
        }
        catch (XAException xAException) {
            if (this.sqlEx != null) {
                throw this.sqlEx;
            }
            throw new SQLException(xAException.getMessage());
        }
        finally {
            try {
                for (int i = 0; i < XP_XA.length; ++i) {
                    this.callableStatements[i].close();
                }
                this.request = null;
                this.txnConn.close();
                this.txnConn = null;
            }
            catch (Exception exception) {}
        }
    }

    protected void start(Xid xid, int n) throws XAException {
        if (this.enlisted && n == 0) {
            XAException xAException = new XAException(this.exceptions.getException(7018).getMessage());
            xAException.errorCode = -6;
            throw xAException;
        }
        this.startedWithJoin = (n & 0x200000) != 0;
        this.executeXaRpc((short)2, xid, n);
        this.enlist();
    }

    protected void end(Xid xid, int n) throws XAException {
        block3: {
            try {
                this.executeXaRpc((short)3, xid, n);
                if (!this.isServer7) {
                    this.unenlist();
                }
            }
            catch (XAException xAException) {
                if (this.startedWithJoin && xAException.errorCode == -3) break block3;
                throw xAException;
            }
        }
    }

    protected int prepare(Xid xid) throws XAException {
        int n = 0;
        int n2 = this.executeXaRpc((short)4, xid, n);
        return n2;
    }

    protected void commit(Xid xid, boolean bl) throws XAException {
        int n = 0;
        if (bl) {
            n = 0x40000000;
        }
        this.executeXaRpc((short)5, xid, n);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    protected void rollback(Xid xid) throws XAException {
        int n = 0;
        this.executeXaRpc((short)6, xid, n);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    protected void forget(Xid xid) throws XAException {
        int n = 0;
        this.executeXaRpc((short)7, xid, n);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    protected Xid[] recover(int n) throws XAException {
        this.executeXaRpc((short)8, null, n);
        int n2 = 0;
        BaseXid[] baseXidArray = new BaseXid[this.nXids];
        for (int i = 0; i < this.nXids; ++i) {
            int n3 = ((this.xidBytes[n2 + 0] & 0xFF) << 0) + ((this.xidBytes[n2 + 1] & 0xFF) << 8) + ((this.xidBytes[n2 + 2] & 0xFF) << 16) + ((this.xidBytes[n2 + 3] & 0xFF) << 24);
            byte by = this.xidBytes[n2 += 4];
            byte by2 = this.xidBytes[++n2];
            byte[] byArray = new byte[by];
            byte[] byArray2 = new byte[by2];
            System.arraycopy(this.xidBytes, ++n2, byArray, 0, by);
            System.arraycopy(this.xidBytes, n2 += by, byArray2, 0, by2);
            n2 += by2;
            baseXidArray[i] = new BaseXid(n3, byArray, byArray2);
        }
        return baseXidArray;
    }

    protected boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.timeout = n;
        return true;
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    protected String getRmIdentification() throws XAException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("databaseName");
        String string4 = string + "_" + string2 + "_" + string3;
        return string4;
    }

    private final int executeXaRpc(short s) throws XAException {
        return this.executeXaRpc(s, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final int executeXaRpc(short var1_1, Xid var2_2, int var3_3) throws XAException {
        var4_4 = 0;
        var5_5 = null;
        this.sqlEx = null;
        try {
            var5_5 = this.callableStatements[var1_1];
            var5_5.registerOutParameter(1, 4);
            switch (var1_1) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    var5_5.registerOutParameter(4, -2);
                    var5_5.setInt(5, this.timeout);
                    if (this.connectProps.get("xaTransactionGroup") == null) {
                        var5_5.setNull(6, 12);
                    } else {
                        var5_5.setString(6, this.connectProps.get("xaTransactionGroup"));
                    }
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    var6_6 = this.getXidBytes(var2_2);
                    var5_5.setBytes(2, (byte[])var6_6);
                    var5_5.setInt(3, var3_3);
                    break;
                }
                case 8: {
                    var5_5.setInt(2, var3_3);
                    var5_5.registerOutParameter(3, -2);
                    if (this.connectProps.get("xaTransactionGroup") == null) {
                        var5_5.setNull(4, 12);
                        break;
                    }
                    var5_5.setString(4, this.connectProps.get("xaTransactionGroup"));
                }
            }
            var5_5.executeUpdate();
            var4_4 = var5_5.getInt(1);
            switch (var1_1) {
                case 2: {
                    this.cookie = var5_5.getBytes(4);
                    break;
                }
                case 8: {
                    this.nXids = var4_4;
                    this.xidBytes = var5_5.getBytes(3);
                }
            }
            ** if (this.sqlEx == null) goto lbl-1000
        }
        catch (SQLException var6_7) {
            try {
                this.sqlEx = var6_7;
                ** if (this.sqlEx == null) goto lbl-1000
            }
            catch (Throwable var9_13) {
                if (this.sqlEx != null) {
                    var10_14 = this.sqlEx.getMessage();
                    var11_15 = new XAException(var10_14);
                    var12_16 = var10_14.indexOf("returns");
                    var11_15.errorCode = var12_16 == -1 ? -3 : Integer.parseInt(var10_14.substring(var12_16 + 8));
                    throw var11_15;
                }
                throw var9_13;
            }
lbl-1000:
            // 1 sources

            {
                var6_8 = this.sqlEx.getMessage();
                var7_10 = new XAException(var6_8);
                var8_12 = var6_8.indexOf("returns");
                var7_10.errorCode = var8_12 == -1 ? -3 : Integer.parseInt(var6_8.substring(var8_12 + 8));
                throw var7_10;
            }
lbl-1000:
            // 1 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            var6_6 = this.sqlEx.getMessage();
            var7_9 = new XAException((String)var6_6);
            var8_11 = var6_6.indexOf("returns");
            var7_9.errorCode = var8_11 == -1 ? -3 : Integer.parseInt(var6_6.substring(var8_11 + 8));
            throw var7_9;
        }
lbl-1000:
        // 1 sources

        {
        }
        this.verifyReturnCode("", var4_4);
        return var4_4;
    }

    private final void verifyReturnCode(String string, int n) throws XAException {
        if (n >= 0) {
            return;
        }
        XAException xAException = new XAException(string);
        xAException.errorCode = n;
        throw xAException;
    }

    private byte[] getXidBytes(Xid xid) {
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = 6 + byArray.length + byArray2.length;
        byte[] byArray3 = new byte[n2];
        byArray3[0] = (byte)(n >>> 0 & 0xFF);
        byArray3[1] = (byte)(n >>> 8 & 0xFF);
        byArray3[2] = (byte)(n >>> 16 & 0xFF);
        byArray3[3] = (byte)(n >>> 24 & 0xFF);
        byArray3[4] = (byte)byArray.length;
        byArray3[5] = (byte)byArray2.length;
        System.arraycopy(byArray, 0, byArray3, 6, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 6 + byArray.length, byArray2.length);
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enlist() throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            if (this.enlisted) {
                return;
            }
            try {
                int n = this.connection.getTransactionIsolation();
                this.request.enlistConnection(this.cookie);
                if (n != 8) {
                    this.connection.setTransactionIsolation(n);
                }
                this.enlisted = true;
            }
            catch (SQLException sQLException) {
                XAException xAException = new XAException(sQLException.getMessage());
                xAException.errorCode = -3;
                throw xAException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unenlist() throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.unenlistConnection();
                this.enlisted = false;
            }
            catch (SQLException sQLException) {
                XAException xAException = new XAException(sQLException.getMessage());
                xAException.errorCode = -3;
                throw xAException;
            }
        }
    }
}

