/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.basic;

import com.metamatrix.data.DataPlugin;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.basic.BasicValueChunk;
import com.metamatrix.data.exception.ConnectorException;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class BasicValueReference
implements ValueReference {
    private Reader charReader;
    private InputStream byteInputStream;
    private boolean isBinary = false;
    private Object value;
    private long size = 999999L;
    private long currentPos = 0L;

    public BasicValueReference(InputStream value) {
        this.byteInputStream = value;
        this.isBinary = true;
        this.value = value;
    }

    public BasicValueReference(byte[] value) {
        this.byteInputStream = new ByteArrayInputStream(value);
        this.isBinary = true;
        this.value = value;
    }

    public BasicValueReference(Reader value) {
        this.charReader = value;
        this.isBinary = false;
        this.value = value;
    }

    public BasicValueReference(char[] value) {
        this.charReader = new CharArrayReader(value);
        this.isBinary = false;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public long getSize() {
        return this.size;
    }

    public ValueChunk createChunk(long startPos, int chunkSize) throws ConnectorException {
        if (chunkSize == 0) {
            return new BasicValueChunk(new char[0], false, false);
        }
        if (startPos != this.currentPos) {
            throw new ConnectorException(DataPlugin.Util.getString("BasicValueReference_walkbackerror"));
        }
        if (this.isBinary()) {
            return this.sendBinaryChunk(chunkSize);
        }
        return this.sendCharacterChunk(chunkSize);
    }

    private ValueChunk sendBinaryChunk(int chunkSize) throws ConnectorException {
        boolean isLast = false;
        byte[] chunk = new byte[chunkSize];
        try {
            int read = this.byteInputStream.read(chunk);
            if (read > 0 && read < chunkSize) {
                byte[] lastChunk = new byte[read];
                System.arraycopy(chunk, 0, lastChunk, 0, read);
                chunk = lastChunk;
                isLast = true;
                this.byteInputStream.close();
            }
            this.currentPos += (long)read;
        }
        catch (IOException ie) {
            throw new ConnectorException(ie, DataPlugin.Util.getString("BasicValueReference_error"));
        }
        return new BasicValueChunk(chunk, true, isLast);
    }

    private ValueChunk sendCharacterChunk(int chunkSize) throws ConnectorException {
        boolean isLast = false;
        char[] chunk = new char[chunkSize];
        try {
            int read = this.charReader.read(chunk);
            if (read > 0 && read < chunkSize) {
                char[] lastChunk = new char[read];
                System.arraycopy(chunk, 0, lastChunk, 0, read);
                chunk = lastChunk;
                isLast = true;
                this.charReader.close();
            }
            this.currentPos += (long)read;
        }
        catch (IOException ie) {
            throw new ConnectorException(ie, DataPlugin.Util.getString("BasicValueReference_error"));
        }
        return new BasicValueChunk(chunk, false, isLast);
    }

    public boolean isBinary() {
        return this.isBinary;
    }
}

