/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.visitor.framework;

import com.metamatrix.data.language.IAggregate;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.ICaseExpression;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExistsCriteria;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IGroupBy;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.INotCriteria;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IOrderByItem;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IScalarSubquery;
import com.metamatrix.data.language.ISearchedCaseExpression;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.language.ISubqueryInCriteria;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.visitor.framework.AbstractLanguageVisitor;
import java.util.Iterator;

public abstract class HierarchyVisitor
extends AbstractLanguageVisitor {
    public void visit(IAggregate obj) {
        this.visitNode(obj.getExpression());
    }

    public void visit(IBatchedUpdates obj) {
        this.visitNodes(obj.getUpdateCommands());
    }

    public void visit(ICaseExpression obj) {
        this.visitNode(obj.getExpression());
        int whenCount = obj.getWhenCount();
        for (int i = 0; i < whenCount; ++i) {
            this.visitNode(obj.getWhenExpression(i));
            this.visitNode(obj.getThenExpression(i));
        }
        this.visitNode(obj.getElseExpression());
    }

    public void visit(ICompareCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getRightExpression());
    }

    public void visit(ICompoundCriteria obj) {
        this.visitNodes(obj.getCriteria());
    }

    public void visit(IDelete obj) {
        this.visitNode(obj.getGroup());
        this.visitNode(obj.getCriteria());
    }

    public void visit(IElement obj) {
    }

    public void visit(IProcedure obj) {
        this.visitNodes(obj.getParameters());
    }

    public void visit(IExistsCriteria obj) {
        this.visitNode(obj.getQuery());
    }

    public void visit(IFrom obj) {
        this.visitNodes(obj.getItems());
    }

    public void visit(IFunction obj) {
        this.visitNodes(obj.getParameters());
    }

    public void visit(IGroup obj) {
    }

    public void visit(IGroupBy obj) {
        this.visitNodes(obj.getElements());
    }

    public void visit(IInCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitNodes(obj.getRightExpressions());
    }

    public void visit(IInsert obj) {
        this.visitNode(obj.getGroup());
        this.visitNodes(obj.getElements());
        this.visitNodes(obj.getValues());
    }

    public void visit(IIsNullCriteria obj) {
        this.visitNode(obj.getExpression());
    }

    public void visit(IJoin obj) {
        this.visitNode(obj.getLeftItem());
        this.visitNode(obj.getRightItem());
        if (obj.getCriteria() != null) {
            this.visitNodes(obj.getCriteria());
        }
    }

    public void visit(ILikeCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getRightExpression());
    }

    public void visit(ILiteral obj) {
    }

    public void visit(INotCriteria obj) {
        this.visitNode(obj.getCriteria());
    }

    public void visit(IOrderBy obj) {
        this.visitNodes(obj.getItems());
    }

    public void visit(IOrderByItem obj) {
    }

    public void visit(IParameter obj) {
    }

    public void visit(IQuery obj) {
        this.visitNode(obj.getSelect());
        this.visitNode(obj.getFrom());
        this.visitNode(obj.getWhere());
        this.visitNode(obj.getGroupBy());
        this.visitNode(obj.getHaving());
        this.visitNode(obj.getOrderBy());
        this.visitNode(obj.getLimit());
    }

    public void visit(IScalarSubquery obj) {
        this.visitNode(obj.getQuery());
    }

    public void visit(ISearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        for (int i = 0; i < whenCount; ++i) {
            this.visitNode(obj.getWhenCriteria(i));
            this.visitNode(obj.getThenExpression(i));
        }
        this.visitNode(obj.getElseExpression());
    }

    public void visit(ISelect obj) {
        this.visitNodes(obj.getSelectSymbols());
    }

    public void visit(ISelectSymbol obj) {
        this.visitNode(obj.getExpression());
    }

    public void visit(ISubqueryCompareCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getQuery());
    }

    public void visit(ISubqueryInCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getQuery());
    }

    public void visit(IUnion obj) {
        this.visitNode(obj.getSelect());
        this.visitNode(obj.getFrom());
        this.visitNode(obj.getWhere());
        this.visitNode(obj.getGroupBy());
        this.visitNode(obj.getHaving());
        this.visitNode(obj.getOrderBy());
        Iterator queryIter = obj.getUnionQueries().iterator();
        while (queryIter.hasNext()) {
            this.visitNode((ILanguageObject)queryIter.next());
        }
        this.visitNode(obj.getUnionOrderBy());
    }

    public void visit(IUpdate obj) {
        this.visitNode(obj.getGroup());
        this.visitNodes(obj.getChanges());
        this.visitNode(obj.getCriteria());
    }

    public void reset() {
    }
}

