/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.crypto.Base64ByteEncoder;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoKeyManager;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.CryptorCache;
import com.metamatrix.common.util.crypto.Decryptor;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.cipher.BasicCryptor;
import com.metamatrix.common.util.crypto.cipher.SerializableEncryptor;
import com.metamatrix.common.util.crypto.keymanage.AsymKeyStoreManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.Key;
import java.security.Provider;

public class CryptoFactory {
    private static Provider installedProvider = null;
    private static CryptoKeyManager keyManager = null;
    private static CryptorCache cryptorCache = new CryptorCache();

    public static void init(String storeFile, char[] storePass, String keyName) throws CryptoException, FileNotFoundException, IOException {
        CryptoFactory.init(storeFile, storePass, keyName, true);
    }

    public static synchronized void init(String storeFile, char[] storePass, String keyName, boolean readFromCP) throws CryptoException, FileNotFoundException, IOException {
        CryptoUtil.initJCEProvider();
        cryptorCache.clearCache();
        keyManager = new AsymKeyStoreManager(storeFile, CryptoFactory.deArgle(storePass), keyName, readFromCP);
    }

    public static synchronized void init(URL storeFile, char[] storePass, String keyName) throws CryptoException, FileNotFoundException, IOException {
        CryptoUtil.initJCEProvider();
        cryptorCache.clearCache();
        keyManager = new AsymKeyStoreManager(storeFile, CryptoFactory.deArgle(storePass), keyName);
    }

    public static void unload() {
        CryptoUtil.unloadJCEProvider();
        CryptoFactory.clearCache();
    }

    public static synchronized Cryptor getCryptor() throws CryptoException {
        Cryptor cryptor = cryptorCache.getCryptor();
        if (cryptor == null) {
            Key encryptKey = keyManager.getEncryptKey();
            Key decryptKey = keyManager.getDecryptKey();
            cryptor = installedProvider != null ? new BasicCryptor(encryptKey, decryptKey, installedProvider.getName()) : new BasicCryptor(encryptKey, decryptKey);
            cryptorCache.setCryptor(cryptor);
        }
        return cryptor;
    }

    public static synchronized Encryptor getEncryptor() throws CryptoException {
        Encryptor encryptor = cryptorCache.getEncryptor();
        if (encryptor == null) {
            Key encryptKey = keyManager.getEncryptKey();
            encryptor = installedProvider != null ? new SerializableEncryptor(encryptKey, installedProvider.getName()) : new SerializableEncryptor(encryptKey);
            cryptorCache.setEncryptor(encryptor);
        }
        return encryptor;
    }

    public static synchronized Decryptor getDecryptor() throws CryptoException {
        Decryptor decryptor = cryptorCache.getDecryptor();
        if (decryptor == null) {
            Key encryptKey = keyManager.getEncryptKey();
            Key decryptKey = keyManager.getDecryptKey();
            decryptor = installedProvider != null ? new BasicCryptor(encryptKey, decryptKey, installedProvider.getName()) : new BasicCryptor(encryptKey, decryptKey);
            cryptorCache.setDecryptor(decryptor);
        }
        return decryptor;
    }

    public static synchronized void clearCache() {
        cryptorCache.clearCache();
    }

    public static char[] argle(char[] deArgled) {
        String deArgledStr = new String(deArgled);
        byte[] deArgledByte = deArgledStr.getBytes();
        String argled = Base64ByteEncoder.encode(deArgledByte);
        return argled.toCharArray();
    }

    public static char[] deArgle(char[] argled) {
        String argledStr = new String(argled);
        byte[] deArgled = Base64ByteEncoder.decode(argledStr);
        return new String(deArgled).toCharArray();
    }

    public static char[] encodeBytes(byte[] bytes) {
        return Base64ByteEncoder.encode(bytes).toCharArray();
    }

    public static byte[] decodeBytes(char[] encodedBytes) {
        try {
            return Base64ByteEncoder.decode(new String(encodedBytes));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0057", new String(encodedBytes), e.getMessage()));
        }
    }

    public static void printKeyInfo(String header, Key key) {
        System.out.println(header);
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0025", key.getAlgorithm()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0026", key.getFormat()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0027", new String(CryptoFactory.encodeBytes(key.getEncoded()))));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0028", ByteArrayHelper.toString(key.getEncoded())));
    }

    public static void main(String[] args) throws Exception {
        String storeFile = args.length > 0 ? args[0] : null;
        char[] storePass = args.length > 1 ? args[1].toCharArray() : "password".toCharArray();
        String keyName = args.length > 2 ? args[2] : "encrypt";
        String cleartext = args.length > 3 ? args[3] : "Clear text.";
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0029", new Integer(cleartext.length()), cleartext));
        CryptoFactory.init(storeFile, storePass, keyName, true);
        Encryptor encryptor = CryptoFactory.getEncryptor();
        Decryptor decryptor = CryptoFactory.getDecryptor();
        CryptoFactory.testByteMethods(encryptor, decryptor, cleartext);
        CryptoFactory.testCharMethods(encryptor, decryptor, cleartext);
    }

    static void testByteMethods(Encryptor encryptor, Decryptor decryptor, String cleartext) throws CryptoException {
        byte[] clearBytes = cleartext.getBytes();
        byte[] cipherBytes = encryptor.encrypt(clearBytes);
        CryptoFactory.printByteInfo("\nOriginal  cleartext  bytes...", clearBytes);
        CryptoFactory.printByteInfo("\nEncrypted ciphertext bytes...", cipherBytes);
        byte[] clearBytes2 = decryptor.decrypt(cipherBytes);
        CryptoFactory.checkEncryptDecrypt("\nCompare bytes...", cleartext, clearBytes2);
        String ciphertext = new String(CryptoFactory.encodeBytes(cipherBytes));
        System.out.println("\nEncoded ciphertext (length " + ciphertext.length() + "): " + ciphertext);
        byte[] clearBytes3 = decryptor.decrypt(CryptoFactory.decodeBytes(ciphertext.toCharArray()));
        CryptoFactory.checkEncryptDecrypt("\nCompare encoded bytes...", cleartext, clearBytes3);
    }

    static void testCharMethods(Encryptor encryptor, Decryptor decryptor, String cleartext) throws CryptoException {
        char[] clearChars = cleartext.toCharArray();
        char[] cipherChars = encryptor.encrypt(clearChars);
        CryptoFactory.printCharInfo("\nOriginal  cleartext  chars...", clearChars);
        CryptoFactory.printCharInfo("\nEncrypted ciphertext chars...", cipherChars);
        char[] clearChars2 = decryptor.decrypt(cipherChars);
        CryptoFactory.checkEncryptDecrypt("\nCompare chars...", cleartext, clearChars2);
    }

    static void checkEncryptDecrypt(String header, String cleartext, byte[] clearBytes2) {
        System.out.println(header);
        String cleartext2 = new String(clearBytes2);
        if (cleartext2.equals(cleartext)) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0030"));
        } else {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0058"));
        }
    }

    static void checkEncryptDecrypt(String header, String cleartext, char[] clearBytes2) {
        System.out.println(header);
        String cleartext2 = new String(clearBytes2);
        if (cleartext2.equals(cleartext)) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0030"));
        } else {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0058"));
        }
    }

    static void printByteInfo(String header, byte[] data) {
        System.out.println(header);
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0031", data.length));
        String encodeBA = ByteArrayHelper.toString(data);
        String encodeB64 = Base64ByteEncoder.encode(data);
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0031", encodeBA));
        System.out.println("    -> Length = " + encodeBA.length());
        System.out.println("  Encoded via Base64         : " + encodeB64);
        System.out.println("    -> Length = " + encodeB64.length());
    }

    static void printCharInfo(String header, char[] data) {
        System.out.println(header);
        System.out.println("  Length of char array = " + data.length);
        System.out.println("  Data: " + new String(data));
    }
}

