/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.Decryptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class PasswordChangeUtility {
    private String oldKeystoreName;
    private char[] oldKeystorePwd;
    private String newKeystoreName;
    private char[] newKeystorePwd;
    protected boolean initialized;
    protected Cryptor oldCryptor;
    protected Cryptor newCryptor;

    public PasswordChangeUtility(String oldKeystoreFileName, char[] oldKeystorePwd, String newKeystoreFileName, char[] newKeystorePwd) {
        if (oldKeystoreFileName == null || oldKeystoreFileName.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0062"));
        }
        if (oldKeystorePwd == null || oldKeystorePwd.length == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0063"));
        }
        if (newKeystoreFileName == null || newKeystoreFileName.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0064"));
        }
        if (newKeystorePwd == null || newKeystorePwd.length == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0065"));
        }
        this.oldKeystoreName = oldKeystoreFileName;
        this.oldKeystorePwd = oldKeystorePwd;
        this.newKeystoreName = newKeystoreFileName;
        this.newKeystorePwd = newKeystorePwd;
        this.initialized = false;
    }

    public synchronized void init() throws CryptoException {
        if (!this.initialized) {
            String keyName = PasswordChangeUtility.getKeyName();
            try {
                CryptoFactory.init(this.oldKeystoreName, this.oldKeystorePwd, keyName, false);
                this.oldCryptor = CryptoFactory.getCryptor();
            }
            catch (FileNotFoundException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0066", CommonPlugin.Util.getString("ERR.003.030.0066", e.getMessage()));
            }
            catch (IOException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0066", CommonPlugin.Util.getString("ERR.003.030.0066", e.getMessage()));
            }
            try {
                CryptoFactory.init(this.newKeystoreName, this.newKeystorePwd, keyName, false);
                this.newCryptor = CryptoFactory.getCryptor();
            }
            catch (FileNotFoundException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0066", CommonPlugin.Util.getString("ERR.003.030.0067", e.getMessage()));
            }
            catch (IOException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0066", CommonPlugin.Util.getString("ERR.003.030.0067", e.getMessage()));
            }
            this.initialized = true;
        }
    }

    public static String getKeyName() {
        return "encrypt";
    }

    public char[] oldEncrypt(char[] cleartext) throws CryptoException {
        this.init();
        return this.oldCryptor.encrypt(cleartext);
    }

    public Properties oldEncrypt(String match, Properties props) throws CryptoException {
        this.init();
        return this.doCrypt(this.oldCryptor, true, match, props);
    }

    public char[] oldDecrypt(char[] ciphertext) throws CryptoException {
        this.init();
        return this.oldCryptor.decrypt(ciphertext);
    }

    public Properties oldDecrypt(String match, Properties props) throws CryptoException {
        this.init();
        return this.doCrypt(this.oldCryptor, false, match, props);
    }

    public char[] newEncrypt(char[] cleartext) throws CryptoException {
        this.init();
        return this.newCryptor.encrypt(cleartext);
    }

    public Properties newEncrypt(String match, Properties props) throws CryptoException {
        this.init();
        return this.doCrypt(this.newCryptor, true, match, props);
    }

    public char[] newDecrypt(char[] ciphertext) throws CryptoException {
        this.init();
        return this.newCryptor.decrypt(ciphertext);
    }

    public Properties newDecrypt(String match, Properties props) throws CryptoException {
        this.init();
        return this.doCrypt(this.newCryptor, false, match, props);
    }

    private Properties doCrypt(Cryptor cryptor, boolean encrypt, String match, Properties props) throws CryptoException {
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        String matchUpper = match.toUpperCase();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (propName.toUpperCase().endsWith(matchUpper)) {
                String propVal = props.getProperty(propName);
                if (propVal == null || propVal.length() <= 0) continue;
                char[] cryptValue = encrypt ? cryptor.encrypt(propVal.toCharArray()) : cryptor.decrypt(propVal.toCharArray());
                modifiedProps.setProperty(propName, new String(cryptValue));
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("-decrypt")) {
                if (args.length != 4) {
                    System.out.println("usage: PasswordCryptoFactory -decrypt <keystore file name> <keystorePwd> <ciphertext>");
                    System.exit(-1);
                }
                String keystore = args[1];
                char[] storePass = args[2].toCharArray();
                char[] ciphertext = args[3].toCharArray();
                System.out.println("\nCiphertext (length " + ciphertext.length + "): " + new String(ciphertext));
                CryptoFactory.init(keystore, storePass, PasswordChangeUtility.getKeyName(), false);
                Decryptor decryptor = CryptoFactory.getDecryptor();
                char[] clearChars = decryptor.decrypt(ciphertext);
                System.out.println("Cleartext: <" + new String(clearChars) + ">");
                System.exit(0);
            }
            if (args.length != 5) {
                System.out.println("usage: PasswordCryptoFactory <oldKeystore file name> <oldKeystorePwd> <newKeystore file name> <newKeystorePwd> <cleartext>");
                System.exit(-1);
            }
            String oldKeystore = args[0];
            char[] oldStorePass = args[1].toCharArray();
            String newKeystore = args[2];
            char[] newStorePass = args[3].toCharArray();
            String cleartext = args[4];
            System.out.println("\nCleartext (length " + cleartext.length() + "): " + cleartext);
            PasswordChangeUtility pcu = new PasswordChangeUtility(oldKeystore, oldStorePass, newKeystore, newStorePass);
            char[] clearChars = cleartext.toCharArray();
            char[] cipherCharsFromOld = pcu.oldEncrypt(clearChars);
            String ciphertext = new String(cipherCharsFromOld);
            System.out.println("\nOld Ciphertext (length " + ciphertext.length() + ", ratio " + PasswordChangeUtility.getRatio(cleartext, ciphertext) + "):\n" + ciphertext);
            char[] clearCharsFromOld = pcu.oldDecrypt(cipherCharsFromOld);
            PasswordChangeUtility.checkEncryptDecrypt(cleartext, clearCharsFromOld);
            char[] cipherCharsFromNew = pcu.newEncrypt(clearCharsFromOld);
            ciphertext = new String(cipherCharsFromNew);
            System.out.println("\nNew Ciphertext (length " + ciphertext.length() + ", ratio " + PasswordChangeUtility.getRatio(cleartext, ciphertext) + "):\n" + ciphertext);
            char[] clearCharsFromNew = pcu.newDecrypt(cipherCharsFromNew);
            PasswordChangeUtility.checkEncryptDecrypt(cleartext, clearCharsFromNew);
            System.out.println("\nAttempting to use new decryptor on ciphertext encrypted with old encryptor...");
            try {
                clearCharsFromNew = pcu.newDecrypt(cipherCharsFromOld);
            }
            catch (CryptoException e) {
                System.out.println("  Attempt failed (as it should): " + e.getFullMessage());
                clearCharsFromNew = new char[]{};
            }
            PasswordChangeUtility.checkEncryptDecrypt(cleartext, clearCharsFromNew);
        }
        catch (CryptoException e) {
            System.err.println("Error running PasswordChangeUtility test: " + e.getFullMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    static void checkEncryptDecrypt(String cleartext, char[] clearChars) {
        String cleartext2 = new String(clearChars);
        if (cleartext2.equals(cleartext)) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0030"));
        } else {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0058"));
        }
    }

    static float getRatio(String s1, String s2) {
        float ratio = (float)s2.length() / (float)s1.length();
        return (float)((int)(100.0f * ratio)) / 100.0f;
    }
}

