/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.common.util.SqlUtil;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.dqp.datatype.BlobImpl;
import com.metamatrix.dqp.datatype.ClobImpl;
import com.metamatrix.dqp.message.MetaDataMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.CursorResultsImpl;
import com.metamatrix.jdbc.DataTypeTransformer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ResultsMetadataWithProvider;
import com.metamatrix.jdbc.StaticMetadataProvider;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.transaction.UserTransaction;

public class MMPreparedStatement
extends MMStatement
implements PreparedStatement {
    private String prepareSql;
    private Map parameterMap;
    private MMResultSet resultSet;
    private ResultSetMetaData metadata;
    private Calendar serverCalendar;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMPreparedStatement;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMConnection;
    static /* synthetic */ Class class$java$lang$String;

    static MMPreparedStatement newInstance(MMConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (AOP.useproxy()) {
            return (MMPreparedStatement)ProxyFactory.extend(class$com$metamatrix$jdbc$MMPreparedStatement == null ? (class$com$metamatrix$jdbc$MMPreparedStatement = MMPreparedStatement.class$("com.metamatrix.jdbc.MMPreparedStatement")) : class$com$metamatrix$jdbc$MMPreparedStatement, new Class[]{class$com$metamatrix$jdbc$MMConnection == null ? (class$com$metamatrix$jdbc$MMConnection = MMPreparedStatement.class$("com.metamatrix.jdbc.MMConnection")) : class$com$metamatrix$jdbc$MMConnection, class$java$lang$String == null ? (class$java$lang$String = MMPreparedStatement.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE}, new Object[]{connection, sql, new Integer(resultSetType), new Integer(resultSetConcurrency)});
        }
        return new MMPreparedStatement(connection, sql, resultSetType, resultSetConcurrency);
    }

    MMPreparedStatement(MMConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency);
        ArgCheck.isNotNull(sql, JDBCPlugin.Util.getString("MMPreparedStatement.Err_prep_sql"));
        this.prepareSql = sql;
        this.isUpdateSql(sql);
        TimeZone timezone = connection.getConnection().getTimeZone();
        if (timezone != null && !timezone.equals(TimestampWithTimezone.DEFAULT_TIME_ZONE)) {
            this.serverCalendar = Calendar.getInstance(timezone);
        }
    }

    public void addBatch() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void clearParameters() throws SQLException {
        this.checkStatement();
        if (this.parameterMap != null) {
            this.parameterMap.clear();
        }
    }

    public void close() throws SQLException {
        this.prepareSql = null;
        super.close();
    }

    public boolean execute() throws SQLException {
        this.checkStatement();
        if (this.isUpdateSql(this.prepareSql)) {
            this.executeUpdate();
            return false;
        }
        this.executeQuery();
        return true;
    }

    private void processQueryMessage(ResultsMessage resultsMsg) {
        try {
            CursorResultsImpl resultsImpl = null;
            List resultsWarning = resultsMsg.getWarnings();
            this.setAnalysisInfo(resultsMsg);
            if (resultsMsg.getException() != null) {
                this.setException(resultsMsg.getException());
            }
            if (resultsWarning != null) {
                this.setWarnings(resultsWarning);
            }
            resultsImpl = !resultsMsg.isPartialResults() ? CursorResultsImpl.newInstance(resultsMsg, this) : CursorResultsImpl.newInstance(resultsMsg, this);
            this.resultSet = resultsImpl;
        }
        catch (Throwable t) {
            this.setException(t);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        String logMsg;
        this.checkStatement();
        this.resetExecutionState();
        if (!this.createExplicitTransaction()) {
            this.processQueryMessage(this.internalExecute(null, new String[]{this.prepareSql}, super.getQueryTimeout()));
        } else {
            UserTransaction tx = this.getUserTxn();
            this.processQueryMessage(this.internalExecute(tx, new String[]{this.prepareSql}, super.getQueryTimeout()));
            Collection<UserTransaction> values = new ArrayList<UserTransaction>();
            if (this.transactionMap.containsKey(this)) {
                values = (Collection)this.transactionMap.get(this);
            }
            values.add(tx);
            this.transactionMap.put(this, values);
        }
        MMSQLException ex = this.getException();
        if (ex != null) {
            this.endTransaction(false);
        } else if (this.resultSet != null) {
            this.endTransaction(true);
        } else {
            String msg;
            this.endTransaction(false);
            if (this.commandStatus == 4) {
                msg = JDBCPlugin.Util.getString("MMStatement.Timeout_before_execute");
                this.setException(new MMSQLException(msg));
            } else if (this.commandStatus == 3) {
                msg = JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute");
                this.setException(new MMSQLException(msg));
            }
        }
        ex = this.getException();
        if (ex != null) {
            logMsg = JDBCPlugin.Util.getString("MMStatement.Err_query", this.prepareSql, ex.getMessage());
            this.getLogger().log(2, ex, logMsg);
            throw MMSQLException.create(ex);
        }
        logMsg = JDBCPlugin.Util.getString("MMStatement.Success_query", this.prepareSql);
        this.getLogger().log(4, logMsg);
        super.setResultSet(this.resultSet);
        return this.resultSet;
    }

    private void processUpdateMessage(ResultsMessage resultsMsg) {
        MetaMatrixException resultsExp = resultsMsg.getException();
        List resultsWarning = resultsMsg.getWarnings();
        this.setAnalysisInfo(resultsMsg);
        if (resultsExp != null) {
            this.setException(resultsExp);
        } else {
            if (resultsWarning != null) {
                this.setWarnings(resultsWarning);
            }
            this.resultSet = CursorResultsImpl.newInstance(resultsMsg, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        String logMsg;
        String msg;
        this.checkStatement();
        if (this.driverConnection.isReadOnly()) {
            String logMsg2 = JDBCPlugin.Util.getString("MMStatement.Operation_Not_Supported", this.prepareSql);
            this.getLogger().log(2, logMsg2);
            throw new MMSQLException(logMsg2);
        }
        int updateCount = 0;
        this.resetExecutionState();
        if (!this.createExplicitTransaction()) {
            this.processUpdateMessage(this.internalExecute(null, new String[]{this.prepareSql}, 0));
        } else {
            UserTransaction tx = this.getUserTxn();
            this.processUpdateMessage(this.internalExecute(tx, new String[]{this.prepareSql}, super.getQueryTimeout()));
            Collection<UserTransaction> values = new ArrayList<UserTransaction>();
            if (this.transactionMap.containsKey(this)) {
                values = (Collection)this.transactionMap.get(this);
            }
            values.add(tx);
            this.transactionMap.put(this, values);
        }
        MMSQLException ex = this.getException();
        if (ex != null) {
            this.endTransaction(false);
        } else if (this.commandStatus == 4) {
            this.endTransaction(false);
            msg = JDBCPlugin.Util.getString("MMStatement.Timeout_before_execute");
            this.setException(new MMSQLException(msg));
        } else if (this.commandStatus == 3) {
            this.endTransaction(false);
            msg = JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute");
            this.setException(new MMSQLException(msg));
        } else if (this.resultSet.next()) {
            try {
                updateCount = this.resultSet.getInt(1);
                super.setUpdateCount(updateCount);
                logMsg = JDBCPlugin.Util.getString("MMStatement.Success_update", this.prepareSql);
                this.getLogger().log(4, logMsg);
            }
            catch (SQLException se) {
                String msg2 = JDBCPlugin.Util.getString("MMStatement.Err_getting_update_row");
                this.getLogger().log(2, msg2);
                this.setException(MMSQLException.create(se, msg2));
            }
            finally {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        ex = this.getException();
        if (ex != null) {
            logMsg = JDBCPlugin.Util.getString("MMStatement.Err_update", this.prepareSql, ex.getMessage());
            this.getLogger().log(2, ex, logMsg);
            throw MMSQLException.create(ex, ex.getMessage());
        }
        return updateCount;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkStatement();
        if (SqlUtil.isUpdateSql(this.prepareSql)) {
            return null;
        }
        if (this.metadata == null) {
            ResultSet resultSet = this.getResultSet();
            if (resultSet != null) {
                this.metadata = resultSet.getMetaData();
            } else {
                MetaDataMessage metadataMsg = new MetaDataMessage(this.prepareSql);
                metadataMsg.setDoubleQuotedVariablesAllowed(Boolean.valueOf(this.getExecutionProperty("allowDoubleQuotedVariable")));
                Message results = this.executeAsynchAndWait(metadataMsg, false);
                if (results instanceof MessageHolder) {
                    MessageHolder holder = (MessageHolder)results;
                    ExceptionHolder exHolder = (ExceptionHolder)holder.contents;
                    throw MMSQLException.create(exHolder.exception);
                }
                MetaDataMessage returnedMetadataMsg = (MetaDataMessage)results;
                if (returnedMetadataMsg.getException() != null) {
                    throw MMSQLException.create(returnedMetadataMsg.getException());
                }
                StaticMetadataProvider provider = StaticMetadataProvider.createWithData(returnedMetadataMsg.getMetadataMap(), returnedMetadataMsg.getParameterCount(), this.getLogger());
                this.metadata = ResultsMetadataWithProvider.newInstance(provider, this.getLogger());
            }
        }
        return this.metadata;
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setAsciiStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setObject(parameterIndex, new ClobImpl(in, length));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    public void setBinaryStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setObject(parameterIndex, new BlobImpl(in, length));
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setObject(parameterIndex, new Boolean(value));
    }

    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.setObject(parameterIndex, new Byte(value));
    }

    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.setObject(parameterIndex, new BlobImpl(bytes));
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setObject(parameterIndex, new ClobImpl(reader, length));
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.setDate(parameterIndex, value, null);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createDate(x, cal.getTimeZone(), this.getDefaultCalendar()));
    }

    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setObject(parameterIndex, new Double(value));
    }

    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setObject(parameterIndex, new Float(value));
    }

    public void setInt(int parameterIndex, int value) throws SQLException {
        this.setObject(parameterIndex, new Integer(value));
    }

    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setObject(parameterIndex, new Long(value));
    }

    public void setNull(int parameterIndex, int jdbcType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    public void setNull(int parameterIndex, int jdbcType, String typeName) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    public void setObject(int parameterIndex, Object value, int targetJdbcType, int scale) throws SQLException {
        if (value == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        if (targetJdbcType != 3 || targetJdbcType != 2) {
            this.setObject(parameterIndex, value, targetJdbcType);
        } else {
            BigDecimal bigDecimalObject = DataTypeTransformer.getBigDecimal(value);
            bigDecimalObject.setScale(scale);
            this.setObject(parameterIndex, bigDecimalObject);
        }
    }

    public void setObject(int parameterIndex, Object value, int targetJdbcType) throws SQLException {
        Object targetObject = null;
        if (value == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        String javaClassName = MMJDBCSQLTypeInfo.getJavaClassName(targetJdbcType);
        if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.STRING_CLASS)) {
            targetObject = value.toString();
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.CHAR_CLASS)) {
            targetObject = DataTypeTransformer.getCharacter(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.INTEGER_CLASS)) {
            targetObject = DataTypeTransformer.getInteger(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BYTE_CLASS)) {
            targetObject = DataTypeTransformer.getByte(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.SHORT_CLASS)) {
            targetObject = DataTypeTransformer.getShort(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.LONG_CLASS)) {
            targetObject = DataTypeTransformer.getLong(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.FLOAT_CLASS)) {
            targetObject = DataTypeTransformer.getFloat(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.DOUBLE_CLASS)) {
            targetObject = DataTypeTransformer.getDouble(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BOOLEAN_CLASS)) {
            targetObject = DataTypeTransformer.getBoolean(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BIGDECIMAL_CLASS)) {
            targetObject = DataTypeTransformer.getBigDecimal(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.TIMESTAMP_CLASS)) {
            targetObject = DataTypeTransformer.getTimestamp(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.DATE_CLASS)) {
            targetObject = DataTypeTransformer.getDate(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.TIME_CLASS)) {
            targetObject = DataTypeTransformer.getTime(value);
        } else if (javaClassName.equalsIgnoreCase("java.sql.Blob")) {
            targetObject = DataTypeTransformer.getBlob(value);
        } else if (javaClassName.equalsIgnoreCase("java.sql.Clob")) {
            targetObject = DataTypeTransformer.getClob(value);
        } else {
            String msg = JDBCPlugin.Util.getString("MMPreparedStatement.Err_transform_obj");
            throw new MMSQLException(msg);
        }
        this.setObject(parameterIndex, targetObject);
    }

    public void setObject(int parameterIndex, Object value) throws SQLException {
        ArgCheck.isPositive(parameterIndex, JDBCPlugin.Util.getString("MMPreparedStatement.Invalid_param_index"));
        if (this.parameterMap == null) {
            this.parameterMap = new TreeMap();
        }
        if (this.serverCalendar != null && value instanceof java.util.Date) {
            value = TimestampWithTimezone.create((java.util.Date)value, null, this.serverCalendar, value.getClass());
        }
        this.parameterMap.put(new Integer(parameterIndex), value);
    }

    public void setRef(int parameterIndex, Ref jdbcType) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setObject(parameterIndex, new Short(value));
    }

    public void setString(int parameterIndex, String value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.setTime(parameterIndex, value, null);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createTime(x, cal.getTimeZone(), this.getDefaultCalendar()));
    }

    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.setTimestamp(parameterIndex, value, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createTimestamp(x, cal.getTimeZone(), this.getDefaultCalendar()));
    }

    public void setUnicodeStream(int parameterIndex, InputStream fin, int length) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    protected void timeoutOccurred(Object ID) {
        String logMsg = JDBCPlugin.Util.getString("MMPreparedStatement.Timeout_ocurred_in_PreparedStatement.");
        this.getLogger().log(3, logMsg);
        try {
            this.timeoutCancel();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException se) {
            logMsg = JDBCPlugin.Util.getString("MMStatement.Error_timing_out.");
            this.getLogger().log(2, se, logMsg);
        }
    }

    protected ResultsMessage internalExecute(UserTransaction transaction, String[] commands, int timeout) throws SQLException {
        try {
            return this.sendRequestMessageAndWait(transaction, commands, timeout, true, false, this.getParameterValues(), false);
        }
        catch (Throwable ex) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Error_executing_stmt", commands[0]);
            this.getLogger().log(2, ex, msg);
            throw MMSQLException.create(ex, msg);
        }
    }

    public List getParameterValues() {
        if (this.parameterMap == null || this.parameterMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.parameterMap.values());
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public synchronized boolean execute(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public int executeUpdate(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    protected void resetExecutionState() throws SQLException {
        super.resetExecutionState();
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    void setServerCalendar(Calendar serverCalendar) {
        this.serverCalendar = serverCalendar;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

