/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.GranteeEntitlementEntry;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UserEntitlementInfo
implements Serializable {
    private String VDBName;
    private String VDBVersion;
    private String groupName;
    private String eleName;
    private Map granteeMap;

    public UserEntitlementInfo(AuthorizationRealm realm, String groupName, String eleName) {
        this.VDBName = realm.getSuperRealmName();
        this.VDBVersion = realm.getSubRealmName();
        this.groupName = groupName;
        this.eleName = eleName;
    }

    public boolean isGroupEntitlement() {
        return this.eleName == null;
    }

    public String getVDBName() {
        return this.VDBName;
    }

    public String getVDBVersion() {
        return this.VDBVersion;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getElementName() {
        return this.eleName;
    }

    public int size() {
        return this.granteeMap.size();
    }

    public boolean contains(String grantee) {
        return this.granteeMap != null && this.granteeMap.containsKey(grantee.toUpperCase());
    }

    public Collection getGrantees() {
        ArrayList granteeList = new ArrayList();
        if (this.granteeMap != null && this.granteeMap.size() > 0) {
            Iterator granteeItr = this.granteeMap.keySet().iterator();
            while (granteeItr.hasNext()) {
                Set granteeEntries = (Set)this.granteeMap.get(granteeItr.next());
                granteeList.addAll(granteeEntries);
            }
            Collections.sort(granteeList);
        }
        return granteeList;
    }

    public Iterator iterator() {
        if (this.granteeMap == null || this.granteeMap.size() == 0) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.getGrantees().iterator();
    }

    public void addTriplet(MetaMatrixPrincipalName grantee, String grantor, int allowedActions) {
        GranteeEntitlementEntry anEntry = new GranteeEntitlementEntry(grantee, grantor, allowedActions);
        this.addTriplet(anEntry);
    }

    public void addTriplet(GranteeEntitlementEntry newEntry) {
        String granteeName;
        HashSet<GranteeEntitlementEntry> granteeEntries;
        if (this.granteeMap == null) {
            this.granteeMap = new HashMap();
        }
        if ((granteeEntries = (HashSet<GranteeEntitlementEntry>)this.granteeMap.get(granteeName = newEntry.getGrantee().toUpperCase())) == null) {
            granteeEntries = new HashSet<GranteeEntitlementEntry>();
        } else {
            Iterator granteeEntryItr = granteeEntries.iterator();
            while (granteeEntryItr.hasNext()) {
                GranteeEntitlementEntry aCurrentEntry = (GranteeEntitlementEntry)granteeEntryItr.next();
                if (!newEntry.getGrantor().equalsIgnoreCase(aCurrentEntry.getGrantor())) continue;
                granteeEntries.remove(aCurrentEntry);
                newEntry.addActions(aCurrentEntry.getActions());
                break;
            }
        }
        granteeEntries.add(newEntry);
        this.granteeMap.put(granteeName, granteeEntries);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.VDBName + ", ");
        buf.append(this.VDBVersion + "\n");
        buf.append(this.groupName + "\n");
        if (this.eleName != null) {
            buf.append(" " + this.eleName + "\n");
        }
        Iterator granteeItr = this.getGrantees().iterator();
        while (granteeItr.hasNext()) {
            GranteeEntitlementEntry entry = (GranteeEntitlementEntry)granteeItr.next();
            buf.append("  " + entry.toString() + "\n");
        }
        return buf.toString();
    }
}

